/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.context;

import co.codewizards.cloudstore.core.context.ExtensibleContext;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.HashMap;
import java.util.Map;

public class ExtensibleContextSupport
implements ExtensibleContext {
    private final Map<Class<?>, Object> contextClass2ContextObject = new HashMap();

    @Override
    public void setContextObject(Object object) {
        Class<?> clazz;
        AssertUtil.assertNotNull("object", object);
        if (clazz == Object.class) {
            throw new IllegalArgumentException("object is of type java.lang.Object! Must be a sub-class!");
        }
        if (clazz == Class.class) {
            throw new IllegalArgumentException("object is of type java.lang.Class!");
        }
        for (clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            this.registerContextObject(clazz, object);
        }
    }

    private void registerContextObject(Class<?> clazz, Object object) {
        Class<?>[] interfaces;
        this.contextClass2ContextObject.put(clazz, object);
        for (Class<?> iface : interfaces = clazz.getInterfaces()) {
            this.registerContextObject(iface, object);
        }
    }

    @Override
    public <T> T getContextObject(Class<T> clazz) {
        AssertUtil.assertNotNull("clazz", clazz);
        return clazz.cast(this.contextClass2ContextObject.get(clazz));
    }

    @Override
    public void removeContextObject(Object object) {
        AssertUtil.assertNotNull("object", object);
        this.removeContextObject(object.getClass());
    }

    @Override
    public void removeContextObject(Class<?> clazz) {
        AssertUtil.assertNotNull("clazz", clazz);
        while (clazz != Object.class) {
            Class<?>[] interfaces;
            this.contextClass2ContextObject.remove(clazz);
            for (Class<?> iface : interfaces = clazz.getInterfaces()) {
                this.contextClass2ContextObject.remove(iface);
            }
            clazz = clazz.getSuperclass();
        }
    }
}

