/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.CharArrayWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.BitSet;

public final class UrlEncoder {
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;

    private UrlEncoder() {
    }

    public static String encode(String s) {
        String str = UrlEncoder.encode(s, StandardCharsets.UTF_8);
        return str;
    }

    @Deprecated
    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        Charset charset;
        AssertUtil.assertNotNull("s", s);
        AssertUtil.assertNotNull("enc", enc);
        try {
            charset = Charset.forName(enc);
        }
        catch (IllegalCharsetNameException e) {
            throw new UnsupportedEncodingException(enc);
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(enc);
        }
        return UrlEncoder.encode(s, charset);
    }

    @Deprecated
    public static String encode(String s, Charset charset) {
        AssertUtil.assertNotNull("s", s);
        AssertUtil.assertNotNull("charset", charset);
        boolean needToChange = false;
        StringBuffer out = new StringBuffer(s.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (dontNeedEncoding.get(c)) {
                out.append(c);
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c);
                if (c < '\ud800' || c > '\udbff' || i + 1 >= s.length() || (d = s.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                charArrayWriter.write(d);
                ++i;
            } while (++i < s.length() && !dontNeedEncoding.get(c = s.charAt(i)));
            charArrayWriter.flush();
            String str = new String(charArrayWriter.toCharArray());
            byte[] ba = str.getBytes(charset);
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            charArrayWriter.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    static {
        int i;
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

