/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.Indices;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.listener.StoreCallback;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.PermissionSet;
import org.subshare.local.persistence.SignatureImpl;
import org.subshare.local.persistence.UserRepoKeyPublicKey;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Unique(name="UK_Permission_permissionId", members={"permissionId"})
@Indices(value={@Index(name="Permission_permissionId", members={"permissionId"}), @Index(name="Permission_permissionType", members={"permissionType"}), @Index(name="Permission_localRevision", members={"localRevision"}), @Index(name="Permission_validFrom", members={"validFrom"}), @Index(name="Permission_validTo", members={"validTo"})})
@Queries(value={@Query(name="getPermission_permissionId", value="SELECT UNIQUE WHERE this.permissionId == :permissionId"), @Query(name="getNonRevokedPermissions_permissionSet_permissionType_userRepoKeyId", value="SELECT WHERE this.permissionSet == :permissionSet && this.permissionType == :permissionType && this.userRepoKeyPublicKey.userRepoKeyId == :userRepoKeyId && this.revoked == null"), @Query(name="getNonRevokedPermissions_permissionType_userRepoKeyId", value="SELECT WHERE this.permissionType == :permissionType && this.userRepoKeyPublicKey.userRepoKeyId == :userRepoKeyId && this.revoked == null"), @Query(name="getNonRevokedPermissions_permissionType", value="SELECT WHERE this.permissionType == :permissionType && this.revoked == null"), @Query(name="getValidPermissions_permissionSet_permissionType_userRepoKeyId_timestamp", value="SELECT WHERE this.permissionSet == :permissionSet && this.permissionType == :permissionType && this.userRepoKeyPublicKey.userRepoKeyId == :userRepoKeyId && this.validFrom <= :timestamp && ( this.validTo == null || this.validTo > :timestamp )"), @Query(name="getValidPermissions_permissionType_userRepoKeyId_timestamp", value="SELECT WHERE this.permissionType == :permissionType && this.userRepoKeyPublicKey.userRepoKeyId == :userRepoKeyId && this.validFrom <= :timestamp && ( this.validTo == null || this.validTo > :timestamp )"), @Query(name="PermissionCountOfDirectChildCryptoRepoFiles_parentCryptoRepoFile_permissionType", value="SELECT count(this) WHERE this.permissionSet.cryptoRepoFile.parent == :parentCryptoRepoFile && this.permissionType == :permissionType "), @Query(name="getPermissions_userRepoKeyPublicKey", value="SELECT WHERE this.userRepoKeyPublicKey == :userRepoKeyPublicKey "), @Query(name="getPermissions_signingUserRepoKeyId", value="SELECT WHERE this.signature.signingUserRepoKeyId == :signingUserRepoKeyId"), @Query(name="getPermissionsChangedAfter_localRevision", value="SELECT WHERE this.localRevision > :localRevision")})
public class Permission
extends Entity
implements WriteProtected,
AutoTrackLocalRevision,
StoreCallback,
Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(length=22)
    private String permissionId;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private PermissionSet permissionSet;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private UserRepoKeyPublicKey userRepoKeyPublicKey;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(jdbcType="INTEGER")
    private PermissionType permissionType;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private Date validFrom = new Date();
    private Date revoked;
    private Date validTo;
    private long localRevision;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public Permission() {
    }

    public Permission(Uid permissionId) {
        this.permissionId = permissionId == null ? null : permissionId.toString();
    }

    public Uid getPermissionId() {
        if (Permission.dnGetpermissionId(this) == null) {
            Permission.dnSetpermissionId(this, new Uid().toString());
        }
        return new Uid(Permission.dnGetpermissionId(this));
    }

    public PermissionSet getPermissionSet() {
        return Permission.dnGetpermissionSet(this);
    }

    public void setPermissionSet(PermissionSet permissionSet) {
        if (!Util.equal((Object)((Object)Permission.dnGetpermissionSet(this)), (Object)((Object)permissionSet))) {
            Permission.dnSetpermissionSet(this, permissionSet);
        }
    }

    public UserRepoKeyPublicKey getUserRepoKeyPublicKey() {
        return Permission.dnGetuserRepoKeyPublicKey(this);
    }

    public void setUserRepoKeyPublicKey(UserRepoKeyPublicKey userRepoKeyPublicKey) {
        if (!Util.equal((Object)((Object)Permission.dnGetuserRepoKeyPublicKey(this)), (Object)((Object)userRepoKeyPublicKey))) {
            Permission.dnSetuserRepoKeyPublicKey(this, userRepoKeyPublicKey);
        }
    }

    public PermissionType getPermissionType() {
        return Permission.dnGetpermissionType(this);
    }

    public void setPermissionType(PermissionType permissionType) {
        if (Util.equal((Object)Permission.dnGetpermissionType(this), (Object)permissionType)) {
            return;
        }
        if (permissionType != null) {
            switch (permissionType) {
                case grant: 
                case write: 
                case readUserIdentity: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("PermissionType unknown or not allowed here: " + permissionType);
                }
            }
        }
        Permission.dnSetpermissionType(this, permissionType);
    }

    public long getLocalRevision() {
        return Permission.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)Permission.dnGetlocalRevision(this), (long)localRevision)) {
            Permission.dnSetlocalRevision(this, localRevision);
        }
    }

    public void jdoPreStore() {
        this.getPermissionId();
    }

    public Date getValidFrom() {
        return Permission.dnGetvalidFrom(this);
    }

    public void setValidFrom(Date validFrom) {
        if (!Util.equal((Object)Permission.dnGetvalidFrom(this), (Object)validFrom)) {
            Permission.dnSetvalidFrom(this, validFrom);
        }
    }

    public Date getRevoked() {
        return Permission.dnGetrevoked(this);
    }

    public void setRevoked(Date revoked) {
        if (!Util.equal((Object)Permission.dnGetrevoked(this), (Object)revoked)) {
            Permission.dnSetrevoked(this, revoked);
        }
    }

    public Date getValidTo() {
        return Permission.dnGetvalidTo(this);
    }

    public void setValidTo(Date validTo) {
        if (!Util.equal((Object)Permission.dnGetvalidTo(this), (Object)validTo)) {
            Permission.dnSetvalidTo(this, validTo);
        }
    }

    public String getSignedDataType() {
        return "Permission";
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[13];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((Uid)this.getPermissionId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource((Uid)Permission.dnGetpermissionSet(this).getCryptoRepoFile().getCryptoRepoFileId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource((Uid)Permission.dnGetuserRepoKeyPublicKey(this).getUserRepoKeyId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[5] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[6] = InputStreamSource.Helper.createInputStreamSource((int)Permission.dnGetpermissionType(this).ordinal());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[7] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[8] = InputStreamSource.Helper.createInputStreamSource((Date)Permission.dnGetvalidFrom(this));
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[9] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[10] = InputStreamSource.Helper.createInputStreamSource((Date)Permission.dnGetrevoked(this));
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[11] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[12] = InputStreamSource.Helper.createInputStreamSource((Date)Permission.dnGetvalidTo(this));
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return Permission.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)Permission.dnGetsignature(this), (Object)signature)) {
            Permission.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    public Uid getCryptoRepoFileIdControllingPermissions() {
        AssertUtil.assertNotNull((String)"permissionSet", (Object)((Object)Permission.dnGetpermissionSet(this)));
        return (Uid)AssertUtil.assertNotNull((String)"permissionSet.cryptoRepoFile.cryptoRepoFileId", (Object)((CryptoRepoFile)((Object)AssertUtil.assertNotNull((String)"permissionSet.cryptoRepoFile", (Object)((Object)Permission.dnGetpermissionSet(this).getCryptoRepoFile())))).getCryptoRepoFileId());
    }

    public PermissionType getPermissionTypeRequiredForWrite() {
        return PermissionType.grant;
    }

    static {
        dnFieldNames = Permission.__dnFieldNamesInit();
        dnFieldTypes = Permission.__dnFieldTypesInit();
        dnFieldFlags = Permission.__dnFieldFlagsInit();
        dnInheritedFieldCount = Permission.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = Permission.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)Permission.___dn$loadClass("org.subshare.local.persistence.Permission"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new Permission());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        Permission result = new Permission();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        Permission result = new Permission();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 1: {
                this.permissionId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.permissionSet = (PermissionSet)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 3: {
                this.permissionType = (PermissionType)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.revoked = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 5: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 6: {
                this.userRepoKeyPublicKey = (UserRepoKeyPublicKey)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 7: {
                this.validFrom = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 8: {
                this.validTo = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.permissionId);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.permissionSet);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.permissionType);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.revoked);
                break;
            }
            case 5: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            case 6: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.userRepoKeyPublicKey);
                break;
            }
            case 7: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.validFrom);
                break;
            }
            case 8: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.validTo);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(Permission obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 1: {
                this.permissionId = obj.permissionId;
                break;
            }
            case 2: {
                this.permissionSet = obj.permissionSet;
                break;
            }
            case 3: {
                this.permissionType = obj.permissionType;
                break;
            }
            case 4: {
                this.revoked = obj.revoked;
                break;
            }
            case 5: {
                this.signature = obj.signature;
                break;
            }
            case 6: {
                this.userRepoKeyPublicKey = obj.userRepoKeyPublicKey;
                break;
            }
            case 7: {
                this.validFrom = obj.validFrom;
                break;
            }
            case 8: {
                this.validTo = obj.validTo;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Permission)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.Permission");
        }
        Permission other = (Permission)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"localRevision", "permissionId", "permissionSet", "permissionType", "revoked", "signature", "userRepoKeyPublicKey", "validFrom", "validTo"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{Long.TYPE, Permission.___dn$loadClass("java.lang.String"), Permission.___dn$loadClass("org.subshare.local.persistence.PermissionSet"), Permission.___dn$loadClass("org.subshare.core.dto.PermissionType"), Permission.___dn$loadClass("java.util.Date"), Permission.___dn$loadClass("org.subshare.local.persistence.SignatureImpl"), Permission.___dn$loadClass("org.subshare.local.persistence.UserRepoKeyPublicKey"), Permission.___dn$loadClass("java.util.Date"), Permission.___dn$loadClass("java.util.Date")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{21, 21, 10, 21, 21, 10, 10, 21, 21};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 9 + Entity.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return Permission.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Entity");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        Permission o = (Permission)((Object)super.clone());
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static long dnGetlocalRevision(Permission objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(Permission objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static String dnGetpermissionId(Permission objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.permissionId);
        }
        return objPC.permissionId;
    }

    private static void dnSetpermissionId(Permission objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.permissionId, val);
        } else {
            objPC.permissionId = val;
        }
    }

    private static PermissionSet dnGetpermissionSet(Permission objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return (PermissionSet)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.permissionSet));
        }
        return objPC.permissionSet;
    }

    private static void dnSetpermissionSet(Permission objPC, PermissionSet val) {
        if (objPC.dnStateManager == null) {
            objPC.permissionSet = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.permissionSet, (Object)val);
        }
    }

    private static PermissionType dnGetpermissionType(Permission objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return (PermissionType)objPC.dnStateManager.getObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, (Object)objPC.permissionType);
        }
        return objPC.permissionType;
    }

    private static void dnSetpermissionType(Permission objPC, PermissionType val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, (Object)objPC.permissionType, (Object)val);
        } else {
            objPC.permissionType = val;
        }
    }

    private static Date dnGetrevoked(Permission objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4 + dnInheritedFieldCount)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.revoked);
        }
        return objPC.revoked;
    }

    private static void dnSetrevoked(Permission objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.revoked, (Object)val);
        } else {
            objPC.revoked = val;
        }
    }

    private static SignatureImpl dnGetsignature(Permission objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(Permission objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }

    private static UserRepoKeyPublicKey dnGetuserRepoKeyPublicKey(Permission objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6 + dnInheritedFieldCount)) {
            return (UserRepoKeyPublicKey)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 6 + dnInheritedFieldCount, (Object)objPC.userRepoKeyPublicKey));
        }
        return objPC.userRepoKeyPublicKey;
    }

    private static void dnSetuserRepoKeyPublicKey(Permission objPC, UserRepoKeyPublicKey val) {
        if (objPC.dnStateManager == null) {
            objPC.userRepoKeyPublicKey = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 6 + dnInheritedFieldCount, (Object)objPC.userRepoKeyPublicKey, (Object)val);
        }
    }

    private static Date dnGetvalidFrom(Permission objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7 + dnInheritedFieldCount)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 7 + dnInheritedFieldCount, (Object)objPC.validFrom);
        }
        return objPC.validFrom;
    }

    private static void dnSetvalidFrom(Permission objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 7 + dnInheritedFieldCount, (Object)objPC.validFrom, (Object)val);
        } else {
            objPC.validFrom = val;
        }
    }

    private static Date dnGetvalidTo(Permission objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 8 + dnInheritedFieldCount)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 8 + dnInheritedFieldCount, (Object)objPC.validTo);
        }
        return objPC.validTo;
    }

    private static void dnSetvalidTo(Permission objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 8 + dnInheritedFieldCount, (Object)objPC.validTo, (Object)val);
        } else {
            objPC.validTo = val;
        }
    }
}

