/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.persistence.Dao;
import java.util.Collection;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.PermissionSet;

public class PermissionSetDao
extends Dao<PermissionSet, PermissionSetDao> {
    private static final Logger logger = LoggerFactory.getLogger(PermissionSetDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionSet getPermissionSet(CryptoRepoFile cryptoRepoFile) {
        AssertUtil.assertNotNull((String)"cryptoRepoFile", (Object)((Object)cryptoRepoFile));
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getPermissionSet_cryptoRepoFile");
        try {
            PermissionSet permissionSet;
            PermissionSet permissionSet2 = permissionSet = (PermissionSet)((Object)query.execute((Object)cryptoRepoFile));
            return permissionSet2;
        }
        finally {
            query.closeAll();
        }
    }

    public PermissionSet getPermissionSetOrFail(CryptoRepoFile cryptoRepoFile) {
        PermissionSet permissionSet = this.getPermissionSet(cryptoRepoFile);
        if (permissionSet == null) {
            throw new IllegalArgumentException("There is no PermissionSet for this CryptoRepoFile: " + (Object)((Object)cryptoRepoFile));
        }
        return permissionSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PermissionSet> getPermissionSetsChangedAfter(long localRevision) {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getPermissionSetsChangedAfter_localRevision");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection permissionSets = (Collection)query.execute((Object)localRevision);
            logger.debug("getPermissionSetsChangedAfter: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            permissionSets = this.load(permissionSets);
            logger.debug("getPermissionSetsChangedAfter: Loading result-set with {} elements took {} ms.", (Object)permissionSets.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = permissionSets;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }
}

