/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.sync;

import co.codewizards.cloudstore.core.Severity;
import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoHelper;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncActivity;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncActivityType;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncDaemon;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncQueueItem;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncRunner;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncState;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoSyncDaemonImpl
implements RepoSyncDaemon {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Set<RepoSyncQueueItem> syncQueue = new LinkedHashSet<RepoSyncQueueItem>();
    private Map<UUID, RepoSyncRunner> repositoryId2SyncRunner = new HashMap<UUID, RepoSyncRunner>();
    private final ExecutorService executorService;
    private Map<UUID, Set<RepoSyncActivity>> repositoryId2SyncActivities = new HashMap<UUID, Set<RepoSyncActivity>>();
    private Map<UUID, List<RepoSyncState>> repositoryId2SyncStates = new HashMap<UUID, List<RepoSyncState>>();
    private static final AtomicInteger threadGroupIndex = new AtomicInteger();
    private final AtomicInteger threadIndex = new AtomicInteger();

    protected RepoSyncDaemonImpl() {
        final int tgi = threadGroupIndex.getAndIncrement();
        final ThreadGroup threadGroup = new ThreadGroup("RepoSyncDaemonThreadGroup_" + tgi);
        this.executorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(threadGroup, r, "RepoSyncDaemonThread_" + tgi + "_" + RepoSyncDaemonImpl.this.threadIndex.getAndIncrement());
            }
        });
    }

    public static RepoSyncDaemon getInstance() {
        return Holder.instance;
    }

    @Override
    public UUID startSync(File file) {
        UUID repositoryId;
        AssertUtil.assertNotNull("file", file);
        File localRoot = LocalRepoHelper.getLocalRootContainingFile(file);
        if (localRoot == null) {
            throw new IllegalArgumentException("File is not located inside a local repository: " + file);
        }
        try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRoot);){
            repositoryId = localRepoManager.getRepositoryId();
        }
        RepoSyncQueueItem repoSyncQueueItem = new RepoSyncQueueItem(repositoryId, localRoot);
        this.enqueue(repoSyncQueueItem);
        this.startSyncWithNextSyncQueueItem(repositoryId);
        this.updateActivities(repositoryId);
        return repositoryId;
    }

    private synchronized void enqueue(RepoSyncQueueItem repoSyncQueueItem) {
        this.syncQueue.add(repoSyncQueueItem);
    }

    private synchronized void startSyncWithNextSyncQueueItem(UUID repositoryId) {
        RepoSyncQueueItem nextSyncQueueItem;
        AssertUtil.assertNotNull("repositoryId", repositoryId);
        if (!this.repositoryId2SyncRunner.containsKey(repositoryId) && (nextSyncQueueItem = this.pollSyncQueueItem(repositoryId)) != null) {
            RepoSyncRunner repoSyncRunner = new RepoSyncRunner(nextSyncQueueItem);
            this.repositoryId2SyncRunner.put(nextSyncQueueItem.repositoryId, repoSyncRunner);
            this.submitToExecutorService(nextSyncQueueItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitToExecutorService(RepoSyncQueueItem repoSyncQueueItem) {
        RepoSyncRunner repoSyncRunner = new RepoSyncRunner(repoSyncQueueItem);
        RepoSyncDaemonImpl repoSyncDaemonImpl = this;
        synchronized (repoSyncDaemonImpl) {
            this.repositoryId2SyncRunner.put(repoSyncQueueItem.repositoryId, repoSyncRunner);
        }
        this.executorService.submit(new WrapperRunnable(repoSyncRunner));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSyncSuccess(RepoSyncRunner repoSyncRunner) {
        List<RepoSyncState> statesRemoved;
        AssertUtil.assertNotNull("repoSyncRunner", repoSyncRunner);
        ArrayList<RepoSyncState> statesAdded = new ArrayList<RepoSyncState>();
        UUID localRepositoryId = repoSyncRunner.getSyncQueueItem().repositoryId;
        File localRoot = repoSyncRunner.getSyncQueueItem().localRoot;
        RepoSyncDaemonImpl repoSyncDaemonImpl = this;
        synchronized (repoSyncDaemonImpl) {
            List<RepoSyncState> list = this._getRepoSyncStates(localRepositoryId);
            for (Map.Entry<UUID, URL> me : repoSyncRunner.getRemoteRepositoryId2RemoteRootMap().entrySet()) {
                UUID remoteRepositoryId = me.getKey();
                URL remoteRoot = me.getValue();
                RepoSyncState state = new RepoSyncState(localRepositoryId, remoteRepositoryId, localRoot, remoteRoot, Severity.INFO, "Sync OK.", null, repoSyncRunner.getSyncStarted(), repoSyncRunner.getSyncFinished());
                list.add(state);
                statesAdded.add(state);
            }
            statesRemoved = this.evictOldStates(localRepositoryId, localRoot);
        }
        this.firePropertyChange(RepoSyncDaemon.PropertyEnum.states_added, null, Collections.unmodifiableList(statesAdded));
        if (!statesRemoved.isEmpty()) {
            this.firePropertyChange(RepoSyncDaemon.PropertyEnum.states_removed, null, Collections.unmodifiableList(statesRemoved));
        }
        this.firePropertyChange(RepoSyncDaemon.PropertyEnum.states, null, this.getStates(localRepositoryId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSyncError(RepoSyncRunner repoSyncRunner, Throwable exception) {
        List<RepoSyncState> statesRemoved;
        AssertUtil.assertNotNull("repoSyncRunner", repoSyncRunner);
        AssertUtil.assertNotNull("exception", exception);
        ArrayList<RepoSyncState> statesAdded = new ArrayList<RepoSyncState>();
        UUID localRepositoryId = repoSyncRunner.getSyncQueueItem().repositoryId;
        File localRoot = repoSyncRunner.getSyncQueueItem().localRoot;
        RepoSyncDaemonImpl repoSyncDaemonImpl = this;
        synchronized (repoSyncDaemonImpl) {
            List<RepoSyncState> list = this._getRepoSyncStates(localRepositoryId);
            UUID remoteRepositoryId = repoSyncRunner.getRemoteRepositoryId();
            URL remoteRoot = repoSyncRunner.getRemoteRoot();
            RepoSyncState state = new RepoSyncState(localRepositoryId, remoteRepositoryId, localRoot, remoteRoot, Severity.ERROR, exception.getMessage(), new Error(exception), repoSyncRunner.getSyncStarted(), repoSyncRunner.getSyncFinished());
            if (remoteRepositoryId != null && remoteRoot != null) {
                list.add(state);
                statesAdded.add(state);
            } else {
                for (Map.Entry<UUID, URL> me : repoSyncRunner.getRemoteRepositoryId2RemoteRootMap().entrySet()) {
                    remoteRepositoryId = me.getKey();
                    remoteRoot = me.getValue();
                    list.add(state);
                    statesAdded.add(state);
                }
            }
            statesRemoved = this.evictOldStates(localRepositoryId, localRoot);
        }
        this.firePropertyChange(RepoSyncDaemon.PropertyEnum.states_added, null, Collections.unmodifiableList(statesAdded));
        if (!statesRemoved.isEmpty()) {
            this.firePropertyChange(RepoSyncDaemon.PropertyEnum.states_removed, null, Collections.unmodifiableList(statesRemoved));
        }
        this.firePropertyChange(RepoSyncDaemon.PropertyEnum.states, null, this.getStates(localRepositoryId));
    }

    private List<RepoSyncState> _getRepoSyncStates(UUID localRepositoryId) {
        List<RepoSyncState> list = this.repositoryId2SyncStates.get(localRepositoryId);
        if (list == null) {
            list = new LinkedList<RepoSyncState>();
            this.repositoryId2SyncStates.put(localRepositoryId, list);
        }
        return list;
    }

    private synchronized List<RepoSyncState> evictOldStates(UUID localRepositoryId, File localRoot) {
        AssertUtil.assertNotNull("localRepositoryId", localRepositoryId);
        AssertUtil.assertNotNull("localRoot", localRoot);
        ArrayList<RepoSyncState> evicted = new ArrayList<RepoSyncState>();
        Config config = ConfigImpl.getInstanceForDirectory(localRoot);
        int syncStatesMaxSize = config.getPropertyAsPositiveOrZeroInt("repoSyncDaemon.syncStates.maxSize", 1);
        List<RepoSyncState> list = this.repositoryId2SyncStates.get(localRepositoryId);
        if (list != null) {
            Iterator<RepoSyncState> it = list.iterator();
            while (it.hasNext()) {
                RepoSyncState repoSyncState = it.next();
                if (this.getSyncStatesSizeForServerRepositoryId(list, repoSyncState.getServerRepositoryId()) <= syncStatesMaxSize) continue;
                evicted.add(repoSyncState);
                it.remove();
            }
        }
        return evicted;
    }

    private int getSyncStatesSizeForServerRepositoryId(List<RepoSyncState> repoSyncStates, UUID serverRepositoryId) {
        AssertUtil.assertNotNull("serverRepositoryId", serverRepositoryId);
        int result = 0;
        for (RepoSyncState repoSyncState : repoSyncStates) {
            if (!serverRepositoryId.equals(repoSyncState.getServerRepositoryId())) continue;
            ++result;
        }
        return result;
    }

    private synchronized RepoSyncQueueItem pollSyncQueueItem(UUID repositoryId) {
        AssertUtil.assertNotNull("repositoryId", repositoryId);
        Iterator<RepoSyncQueueItem> it = this.syncQueue.iterator();
        while (it.hasNext()) {
            RepoSyncQueueItem repoSyncQueueItem = it.next();
            if (!repositoryId.equals(repoSyncQueueItem.repositoryId)) continue;
            it.remove();
            return repoSyncQueueItem;
        }
        return null;
    }

    @Override
    public synchronized List<RepoSyncState> getStates(UUID localRepositoryId) {
        AssertUtil.assertNotNull("localRepositoryId", localRepositoryId);
        List<RepoSyncState> list = this.repositoryId2SyncStates.get(localRepositoryId);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<RepoSyncState>(list));
    }

    @Override
    public synchronized Set<RepoSyncActivity> getActivities(UUID localRepositoryId) {
        AssertUtil.assertNotNull("localRepositoryId", localRepositoryId);
        Set<RepoSyncActivity> activities = this.repositoryId2SyncActivities.get(localRepositoryId);
        if (activities == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<RepoSyncActivity>(activities));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActivities(UUID localRepositoryId) {
        AssertUtil.assertNotNull("localRepositoryId", localRepositoryId);
        ArrayList<RepoSyncActivity> activitiesAdded = new ArrayList<RepoSyncActivity>();
        ArrayList<RepoSyncActivity> activitiesRemoved = new ArrayList<RepoSyncActivity>();
        RepoSyncDaemonImpl repoSyncDaemonImpl = this;
        synchronized (repoSyncDaemonImpl) {
            RepoSyncRunner repoSyncRunner;
            Set<RepoSyncActivity> activities = this.repositoryId2SyncActivities.get(localRepositoryId);
            if (activities == null) {
                activities = new HashSet<RepoSyncActivity>(2);
                this.repositoryId2SyncActivities.put(localRepositoryId, activities);
            }
            if ((repoSyncRunner = this.repositoryId2SyncRunner.get(localRepositoryId)) == null) {
                List<RepoSyncActivity> activitiesStale = this._findActivities(localRepositoryId, RepoSyncActivityType.IN_PROGRESS);
                activitiesRemoved.addAll(activitiesStale);
                activities.removeAll(activitiesStale);
            } else {
                RepoSyncActivity activity = new RepoSyncActivity(repoSyncRunner.getSyncQueueItem().repositoryId, repoSyncRunner.getSyncQueueItem().localRoot, RepoSyncActivityType.IN_PROGRESS);
                if (activities.add(activity)) {
                    activitiesAdded.add(activity);
                }
            }
            List<RepoSyncQueueItem> queueItems = this._findQueueItems(localRepositoryId);
            if (queueItems.isEmpty()) {
                List<RepoSyncActivity> activitiesStale = this._findActivities(localRepositoryId, RepoSyncActivityType.QUEUED);
                activitiesRemoved.addAll(activitiesStale);
                activities.removeAll(activitiesStale);
            } else {
                RepoSyncActivity activity = new RepoSyncActivity(repoSyncRunner.getSyncQueueItem().repositoryId, repoSyncRunner.getSyncQueueItem().localRoot, RepoSyncActivityType.QUEUED);
                if (activities.add(activity)) {
                    activitiesAdded.add(activity);
                }
            }
        }
        if (!activitiesRemoved.isEmpty()) {
            this.firePropertyChange(RepoSyncDaemon.PropertyEnum.activities_removed, null, activitiesRemoved);
        }
        if (!activitiesAdded.isEmpty()) {
            this.firePropertyChange(RepoSyncDaemon.PropertyEnum.activities_added, null, activitiesAdded);
        }
        if (!activitiesAdded.isEmpty() || !activitiesRemoved.isEmpty()) {
            this.firePropertyChange(RepoSyncDaemon.PropertyEnum.activities, null, this.getActivities(localRepositoryId));
        }
    }

    private synchronized List<RepoSyncActivity> _findActivities(UUID localRepositoryId, RepoSyncActivityType activityType) {
        AssertUtil.assertNotNull("localRepositoryId", localRepositoryId);
        Set<RepoSyncActivity> activities = this.repositoryId2SyncActivities.get(localRepositoryId);
        if (activities == null) {
            return Collections.emptyList();
        }
        ArrayList<RepoSyncActivity> result = new ArrayList<RepoSyncActivity>(1);
        for (RepoSyncActivity activity : activities) {
            if (activity.getActivityType() != activityType) continue;
            result.add(activity);
        }
        return Collections.unmodifiableList(result);
    }

    private synchronized List<RepoSyncQueueItem> _findQueueItems(UUID localRepositoryId) {
        AssertUtil.assertNotNull("localRepositoryId", localRepositoryId);
        ArrayList<RepoSyncQueueItem> result = new ArrayList<RepoSyncQueueItem>(2);
        for (RepoSyncQueueItem queueItem : this.syncQueue) {
            if (!localRepositoryId.equals(queueItem.repositoryId)) continue;
            result.add(queueItem);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.executorService.shutdownNow();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(RepoSyncDaemon.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(RepoSyncDaemon.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), listener);
    }

    protected void firePropertyChange(RepoSyncDaemon.Property property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property.name(), oldValue, newValue);
    }

    private class WrapperRunnable
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(WrapperRunnable.class);
        private final UUID repositoryId;
        private final RepoSyncRunner repoSyncRunner;

        public WrapperRunnable(RepoSyncRunner repoSyncRunner) {
            this.repoSyncRunner = AssertUtil.assertNotNull("repoSyncRunner", repoSyncRunner);
            this.repositoryId = repoSyncRunner.getSyncQueueItem().repositoryId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.repoSyncRunner.run();
                RepoSyncDaemonImpl.this.registerSyncSuccess(this.repoSyncRunner);
            }
            catch (Throwable x) {
                this.logger.error("run: " + x, x);
                RepoSyncDaemonImpl.this.registerSyncError(this.repoSyncRunner, x);
            }
            RepoSyncDaemonImpl repoSyncDaemonImpl = RepoSyncDaemonImpl.this;
            synchronized (repoSyncDaemonImpl) {
                RepoSyncRunner removed = (RepoSyncRunner)RepoSyncDaemonImpl.this.repositoryId2SyncRunner.remove(this.repositoryId);
                if (removed != this.repoSyncRunner) {
                    this.logger.error("run: removed != repoSyncRunner");
                }
                RepoSyncDaemonImpl.this.startSyncWithNextSyncQueueItem(this.repositoryId);
            }
            RepoSyncDaemonImpl.this.updateActivities(this.repositoryId);
        }
    }

    private static final class Holder {
        public static final RepoSyncDaemonImpl instance = new RepoSyncDaemonImpl();

        private Holder() {
        }
    }
}

