/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.sync;

import co.codewizards.cloudstore.core.dto.ChangeSetDto;
import co.codewizards.cloudstore.core.dto.ConfigPropSetDto;
import co.codewizards.cloudstore.core.dto.CopyModificationDto;
import co.codewizards.cloudstore.core.dto.DeleteModificationDto;
import co.codewizards.cloudstore.core.dto.DirectoryDto;
import co.codewizards.cloudstore.core.dto.FileChunkDto;
import co.codewizards.cloudstore.core.dto.ModificationDto;
import co.codewizards.cloudstore.core.dto.NormalFileDto;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.dto.RepoFileDtoTreeNode;
import co.codewizards.cloudstore.core.dto.SymlinkDto;
import co.codewizards.cloudstore.core.dto.VersionInfoDto;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.progress.SubProgressMonitor;
import co.codewizards.cloudstore.core.repo.local.LocalRepoHelper;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.sync.ModificationDtoSet;
import co.codewizards.cloudstore.core.repo.transport.CollisionException;
import co.codewizards.cloudstore.core.repo.transport.LocalRepoTransport;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactory;
import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactoryRegistry;
import co.codewizards.cloudstore.core.repo.transport.TransferDoneMarkerType;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.core.util.UrlUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.core.version.VersionCompatibilityValidator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoToRepoSync
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(RepoToRepoSync.class);
    private static final boolean TEST_INVERSE = false;
    protected final File localRoot;
    protected final URL remoteRoot;
    protected final LocalRepoManager localRepoManager;
    protected final LocalRepoTransport localRepoTransport;
    protected final RepoTransport remoteRepoTransport;
    protected final UUID localRepositoryId;
    protected final UUID remoteRepositoryId;
    private ExecutorService localSyncExecutor;
    private Future<Void> localSyncFuture;

    protected RepoToRepoSync(File localRoot, URL remoteRoot) {
        File localRootWithoutPathPrefix = LocalRepoHelper.getLocalRootContainingFile(AssertUtil.assertNotNull("localRoot", localRoot));
        this.remoteRoot = UrlUtil.canonicalizeURL(AssertUtil.assertNotNull("remoteRoot", remoteRoot));
        this.localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRootWithoutPathPrefix);
        this.localRoot = localRoot = OioFileFactory.createFile(localRootWithoutPathPrefix, this.localRepoManager.getLocalPathPrefixOrFail(remoteRoot));
        this.localRepositoryId = this.localRepoManager.getRepositoryId();
        if (this.localRepositoryId == null) {
            throw new IllegalStateException("localRepoManager.getRepositoryId() returned null!");
        }
        this.remoteRepositoryId = this.localRepoManager.getRemoteRepositoryIdOrFail(remoteRoot);
        this.remoteRepoTransport = this.createRepoTransport(remoteRoot, this.localRepositoryId);
        this.localRepoTransport = (LocalRepoTransport)this.createRepoTransport(localRoot, this.remoteRepositoryId);
    }

    public static RepoToRepoSync create(File localRoot, URL remoteRoot) {
        return ObjectFactoryUtil.createObject(RepoToRepoSync.class, localRoot, remoteRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(final ProgressMonitor monitor) {
        AssertUtil.assertNotNull("monitor", monitor);
        monitor.beginTask("Synchronising...", 201);
        try {
            VersionInfoDto clientVersionInfoDto = this.localRepoTransport.getVersionInfoDto();
            VersionInfoDto serverVersionInfoDto = this.remoteRepoTransport.getVersionInfoDto();
            VersionCompatibilityValidator.getInstance().validate(clientVersionInfoDto, serverVersionInfoDto);
            this.readRemoteRepositoryIdFromRepoTransport();
            monitor.worked(1);
            if (this.localSyncExecutor != null) {
                throw new IllegalStateException("localSyncExecutor != null");
            }
            if (this.localSyncFuture != null) {
                throw new IllegalStateException("localSyncFuture != null");
            }
            this.localSyncExecutor = Executors.newFixedThreadPool(1);
            this.localSyncFuture = this.localSyncExecutor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    logger.info("sync: locally syncing {} ('{}')", (Object)RepoToRepoSync.this.localRepositoryId, (Object)RepoToRepoSync.this.localRoot);
                    RepoToRepoSync.this.localRepoManager.localSync(new SubProgressMonitor(monitor, 50));
                    return null;
                }
            });
            this.syncDown(true, new SubProgressMonitor(monitor, 50));
            if (this.localSyncExecutor != null) {
                throw new IllegalStateException("localSyncExecutor != null");
            }
            if (this.localSyncFuture != null) {
                throw new IllegalStateException("localSyncFuture != null");
            }
            this.syncUp(new SubProgressMonitor(monitor, 50));
            this.syncDown(false, new SubProgressMonitor(monitor, 50));
        }
        finally {
            monitor.done();
        }
    }

    protected void syncUp(ProgressMonitor monitor) {
        logger.info("syncUp: fromID={} from='{}' toID={} to='{}'", new Object[]{this.localRepositoryId, this.localRoot, this.remoteRepositoryId, this.remoteRoot});
        this.sync((RepoTransport)this.localRepoTransport, false, this.remoteRepoTransport, monitor);
    }

    protected void syncDown(boolean fromRepoLocalSync, ProgressMonitor monitor) {
        logger.info("syncDown: fromID={} from='{}' toID={} to='{}', fromRepoLocalSync={}", new Object[]{this.remoteRepositoryId, this.remoteRoot, this.localRepositoryId, this.localRoot, fromRepoLocalSync});
        this.sync(this.remoteRepoTransport, fromRepoLocalSync, this.localRepoTransport, monitor);
    }

    private void waitForAndCheckLocalSyncFutureIfExists() {
        if (this.localSyncFuture != null) {
            this.waitForAndCheckLocalSyncFuture();
        }
    }

    private void waitForAndCheckLocalSyncFuture() {
        try {
            AssertUtil.assertNotNull("localSyncFuture", this.localSyncFuture).get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        AssertUtil.assertNotNull("localSyncExecutor", this.localSyncExecutor).shutdown();
        this.localSyncFuture = null;
        this.localSyncExecutor = null;
    }

    private void readRemoteRepositoryIdFromRepoTransport() {
        UUID repositoryId = this.remoteRepoTransport.getRepositoryId();
        if (repositoryId == null) {
            throw new IllegalStateException("remoteRepoTransport.getRepositoryId() returned null!");
        }
        if (!repositoryId.equals(this.remoteRepositoryId)) {
            throw new IllegalStateException(String.format("remoteRepoTransport.getRepositoryId() does not match repositoryId in local DB! %s != %s", repositoryId, this.remoteRepositoryId));
        }
    }

    private RepoTransport createRepoTransport(File rootFile, UUID clientRepositoryId) {
        URL rootURL;
        try {
            rootURL = rootFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return this.createRepoTransport(rootURL, clientRepositoryId);
    }

    private RepoTransport createRepoTransport(URL remoteRoot, UUID clientRepositoryId) {
        RepoTransportFactory repoTransportFactory = RepoTransportFactoryRegistry.getInstance().getRepoTransportFactoryOrFail(remoteRoot);
        return repoTransportFactory.createRepoTransport(remoteRoot, clientRepositoryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sync(RepoTransport fromRepoTransport, boolean fromRepoLocalSync, RepoTransport toRepoTransport, ProgressMonitor monitor) {
        monitor.beginTask("Synchronising...", 100);
        try {
            ChangeSetDto changeSetDto = fromRepoTransport.getChangeSetDto(fromRepoLocalSync);
            monitor.worked(8);
            this.waitForAndCheckLocalSyncFutureIfExists();
            toRepoTransport.prepareForChangeSetDto(changeSetDto);
            this.sync(fromRepoTransport, toRepoTransport, changeSetDto, (ProgressMonitor)new SubProgressMonitor(monitor, 90));
            fromRepoTransport.endSyncFromRepository();
            toRepoTransport.endSyncToRepository(changeSetDto.getRepositoryDto().getRevision());
            monitor.worked(2);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sync(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, ChangeSetDto changeSetDto, ProgressMonitor monitor) {
        monitor.beginTask("Synchronising...", 1 + changeSetDto.getModificationDtos().size() + 3 * changeSetDto.getRepoFileDtos().size() + 1);
        try {
            this.syncParentConfigPropSetDto(fromRepoTransport, toRepoTransport, changeSetDto.getParentConfigPropSetDto(), new SubProgressMonitor(monitor, 1));
            RepoFileDtoTreeNode repoFileDtoTree = RepoFileDtoTreeNode.createTree(changeSetDto.getRepoFileDtos());
            if (repoFileDtoTree != null) {
                this.sync(fromRepoTransport, toRepoTransport, repoFileDtoTree, new Class[]{DirectoryDto.class}, new Class[0], false, new SubProgressMonitor(monitor, repoFileDtoTree.size()));
            }
            this.syncModifications(fromRepoTransport, toRepoTransport, changeSetDto.getModificationDtos(), new SubProgressMonitor(monitor, changeSetDto.getModificationDtos().size()));
            if (repoFileDtoTree != null) {
                this.sync(fromRepoTransport, toRepoTransport, repoFileDtoTree, new Class[]{RepoFileDto.class}, new Class[]{DirectoryDto.class}, true, new SubProgressMonitor(monitor, repoFileDtoTree.size()));
            }
            if (repoFileDtoTree != null) {
                this.sync(fromRepoTransport, toRepoTransport, repoFileDtoTree, new Class[]{RepoFileDto.class}, new Class[]{DirectoryDto.class}, false, new SubProgressMonitor(monitor, repoFileDtoTree.size()));
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncParentConfigPropSetDto(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, ConfigPropSetDto parentConfigPropSetDto, ProgressMonitor monitor) {
        AssertUtil.assertNotNull("fromRepoTransport", fromRepoTransport);
        AssertUtil.assertNotNull("toRepoTransport", toRepoTransport);
        AssertUtil.assertNotNull("monitor", monitor);
        monitor.beginTask("Synchronising parent-config...", 1);
        try {
            if (parentConfigPropSetDto == null) {
                return;
            }
            toRepoTransport.putParentConfigPropSetDto(parentConfigPropSetDto);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sync(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDtoTreeNode repoFileDtoTree, Class<?>[] repoFileDtoClassesIncl, Class<?>[] repoFileDtoClassesExcl, boolean filesInProgressOnly, ProgressMonitor monitor) {
        AssertUtil.assertNotNull("fromRepoTransport", fromRepoTransport);
        AssertUtil.assertNotNull("toRepoTransport", toRepoTransport);
        AssertUtil.assertNotNull("repoFileDtoTree", repoFileDtoTree);
        AssertUtil.assertNotNull("repoFileDtoClassesIncl", repoFileDtoClassesIncl);
        AssertUtil.assertNotNull("repoFileDtoClassesExcl", repoFileDtoClassesExcl);
        AssertUtil.assertNotNull("monitor", monitor);
        HashMap repoFileDtoClass2Included = new HashMap();
        HashMap repoFileDtoClass2Excluded = new HashMap();
        Set<String> fileInProgressPaths = filesInProgressOnly ? this.localRepoTransport.getFileInProgressPaths(fromRepoTransport.getRepositoryId(), toRepoTransport.getRepositoryId()) : null;
        monitor.beginTask("Synchronising...", repoFileDtoTree.size());
        try {
            for (RepoFileDtoTreeNode repoFileDtoTreeNode : repoFileDtoTree) {
                Boolean excluded;
                if (repoFileDtoTreeNode.getRepoFileDto().isNeededAsParent()) {
                    monitor.worked(1);
                    continue;
                }
                if (fileInProgressPaths != null && !fileInProgressPaths.contains(repoFileDtoTreeNode.getPath())) {
                    monitor.worked(1);
                    continue;
                }
                RepoFileDto repoFileDto = repoFileDtoTreeNode.getRepoFileDto();
                Class<?> repoFileDtoClass = repoFileDto.getClass();
                Boolean included = (Boolean)repoFileDtoClass2Included.get(repoFileDtoClass);
                if (included == null) {
                    included = false;
                    for (Class<?> clazz : repoFileDtoClassesIncl) {
                        if (!clazz.isAssignableFrom(repoFileDtoClass)) continue;
                        included = true;
                        break;
                    }
                    repoFileDtoClass2Included.put(repoFileDtoClass, included);
                }
                if ((excluded = (Boolean)repoFileDtoClass2Excluded.get(repoFileDtoClass)) == null) {
                    excluded = false;
                    for (Class<?> clazz : repoFileDtoClassesExcl) {
                        if (!clazz.isAssignableFrom(repoFileDtoClass)) continue;
                        excluded = true;
                        break;
                    }
                    repoFileDtoClass2Excluded.put(repoFileDtoClass, excluded);
                }
                if (!included.booleanValue() || excluded.booleanValue()) {
                    monitor.worked(1);
                    continue;
                }
                if (this.isDone(fromRepoTransport, toRepoTransport, repoFileDto)) {
                    logger.debug("sync: Skipping file already done in an interrupted transfer before: {}", (Object)repoFileDtoTreeNode.getPath());
                    monitor.worked(1);
                    continue;
                }
                if (repoFileDto instanceof DirectoryDto) {
                    this.syncDirectory(fromRepoTransport, toRepoTransport, repoFileDtoTreeNode, (DirectoryDto)repoFileDto, new SubProgressMonitor(monitor, 1));
                } else if (repoFileDto instanceof NormalFileDto) {
                    this.syncFile(fromRepoTransport, toRepoTransport, repoFileDtoTreeNode, repoFileDto, monitor);
                } else if (repoFileDto instanceof SymlinkDto) {
                    this.syncSymlink(fromRepoTransport, toRepoTransport, repoFileDtoTreeNode, (SymlinkDto)repoFileDto, new SubProgressMonitor(monitor, 1));
                } else {
                    throw new IllegalStateException("Unsupported RepoFileDto type: " + repoFileDto);
                }
                this.markDone(fromRepoTransport, toRepoTransport, repoFileDto);
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean isDone(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDto repoFileDto) {
        return this.localRepoTransport.isTransferDone(fromRepoTransport.getRepositoryId(), toRepoTransport.getRepositoryId(), TransferDoneMarkerType.REPO_FILE, repoFileDto.getId(), repoFileDto.getLocalRevision());
    }

    private void markDone(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDto repoFileDto) {
        this.localRepoTransport.markTransferDone(fromRepoTransport.getRepositoryId(), toRepoTransport.getRepositoryId(), TransferDoneMarkerType.REPO_FILE, repoFileDto.getId(), repoFileDto.getLocalRevision());
    }

    private boolean isDone(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, ModificationDto modificationDto) {
        return this.localRepoTransport.isTransferDone(fromRepoTransport.getRepositoryId(), toRepoTransport.getRepositoryId(), TransferDoneMarkerType.MODIFICATION, modificationDto.getId(), modificationDto.getLocalRevision());
    }

    private void markDone(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, ModificationDto modificationDto) {
        this.localRepoTransport.markTransferDone(fromRepoTransport.getRepositoryId(), toRepoTransport.getRepositoryId(), TransferDoneMarkerType.MODIFICATION, modificationDto.getId(), modificationDto.getLocalRevision());
    }

    private SortedMap<Long, Collection<ModificationDto>> getLocalRevision2ModificationDtos(Collection<ModificationDto> modificationDtos) {
        TreeMap<Long, Collection<ModificationDto>> map = new TreeMap<Long, Collection<ModificationDto>>();
        for (ModificationDto modificationDto : modificationDtos) {
            long localRevision = modificationDto.getLocalRevision();
            ArrayList<ModificationDto> collection = (ArrayList<ModificationDto>)map.get(localRevision);
            if (collection == null) {
                collection = new ArrayList<ModificationDto>();
                map.put(localRevision, collection);
            }
            collection.add(modificationDto);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncModifications(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, Collection<ModificationDto> modificationDtos, ProgressMonitor monitor) {
        monitor.beginTask("Synchronising...", modificationDtos.size());
        try {
            SortedMap<Long, Collection<ModificationDto>> localRevision2ModificationDtos = this.getLocalRevision2ModificationDtos(modificationDtos);
            for (Map.Entry<Long, Collection<ModificationDto>> me : localRevision2ModificationDtos.entrySet()) {
                ModificationDtoSet modificationDtoSet = new ModificationDtoSet(me.getValue());
                for (List<CopyModificationDto> list : modificationDtoSet.getFromPath2CopyModificationDtos().values()) {
                    Iterator<CopyModificationDto> itCopyMod = list.iterator();
                    while (itCopyMod.hasNext()) {
                        CopyModificationDto copyModificationDto = itCopyMod.next();
                        if (this.isDone(fromRepoTransport, toRepoTransport, copyModificationDto)) {
                            logger.debug("sync: Skipping CopyModificaton already done in an interrupted transfer before: {} => {}", (Object)copyModificationDto.getFromPath(), (Object)copyModificationDto.getToPath());
                            monitor.worked(1);
                            continue;
                        }
                        List<DeleteModificationDto> deleteModificationDtos = modificationDtoSet.getPath2DeleteModificationDtos().get(copyModificationDto.getFromPath());
                        boolean moveInstead = false;
                        if (!itCopyMod.hasNext() && deleteModificationDtos != null && !deleteModificationDtos.isEmpty()) {
                            moveInstead = true;
                        }
                        if (moveInstead) {
                            logger.info("syncModifications: Moving from '{}' to '{}'", (Object)copyModificationDto.getFromPath(), (Object)copyModificationDto.getToPath());
                            toRepoTransport.move(copyModificationDto.getFromPath(), copyModificationDto.getToPath());
                        } else {
                            logger.info("syncModifications: Copying from '{}' to '{}'", (Object)copyModificationDto.getFromPath(), (Object)copyModificationDto.getToPath());
                            toRepoTransport.copy(copyModificationDto.getFromPath(), copyModificationDto.getToPath());
                        }
                        if (!moveInstead && deleteModificationDtos != null) {
                            for (DeleteModificationDto deleteModificationDto : deleteModificationDtos) {
                                logger.info("syncModifications: Deleting '{}'", (Object)deleteModificationDto.getPath());
                                this.applyDeleteModification(fromRepoTransport, toRepoTransport, deleteModificationDto);
                            }
                        }
                        this.markDone(fromRepoTransport, toRepoTransport, copyModificationDto);
                    }
                }
                for (List<ModificationDto> list : modificationDtoSet.getPath2DeleteModificationDtos().values()) {
                    for (DeleteModificationDto deleteModificationDto : list) {
                        if (this.isDone(fromRepoTransport, toRepoTransport, deleteModificationDto)) {
                            logger.debug("sync: Skipping DeleteModificaton already done in an interrupted transfer before: {}", (Object)deleteModificationDto.getPath());
                            monitor.worked(1);
                            continue;
                        }
                        logger.info("syncModifications: Deleting '{}'", (Object)deleteModificationDto.getPath());
                        this.applyDeleteModification(fromRepoTransport, toRepoTransport, deleteModificationDto);
                        this.markDone(fromRepoTransport, toRepoTransport, deleteModificationDto);
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void applyDeleteModification(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, DeleteModificationDto deleteModificationDto) {
        AssertUtil.assertNotNull("fromRepoTransport", fromRepoTransport);
        AssertUtil.assertNotNull("toRepoTransport", toRepoTransport);
        AssertUtil.assertNotNull("deleteModificationDto", deleteModificationDto);
        try {
            this.delete(fromRepoTransport, toRepoTransport, deleteModificationDto);
        }
        catch (CollisionException x) {
            logger.info("CollisionException during delete: {}", (Object)deleteModificationDto.getPath());
            if (logger.isDebugEnabled()) {
                logger.debug(x.toString(), (Throwable)x);
            }
            return;
        }
    }

    protected void delete(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, DeleteModificationDto deleteModificationDto) {
        toRepoTransport.delete(deleteModificationDto.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncDirectory(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDtoTreeNode repoFileDtoTreeNode, DirectoryDto directoryDto, ProgressMonitor monitor) {
        monitor.beginTask("Synchronising...", 100);
        try {
            String path = repoFileDtoTreeNode.getPath();
            logger.info("syncDirectory: path='{}'", (Object)path);
            try {
                this.makeDirectory(fromRepoTransport, toRepoTransport, repoFileDtoTreeNode, path, directoryDto);
            }
            catch (CollisionException x) {
                logger.info("CollisionException during makeDirectory: {}", (Object)path);
                if (logger.isDebugEnabled()) {
                    logger.debug(x.toString(), (Throwable)x);
                }
                monitor.done();
                return;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void makeDirectory(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDtoTreeNode repoFileDtoTreeNode, String path, DirectoryDto directoryDto) {
        toRepoTransport.makeDirectory(path, directoryDto.getLastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncSymlink(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDtoTreeNode repoFileDtoTreeNode, SymlinkDto symlinkDto, SubProgressMonitor monitor) {
        monitor.beginTask("Synchronising...", 100);
        try {
            String path = repoFileDtoTreeNode.getPath();
            try {
                toRepoTransport.makeSymlink(path, symlinkDto.getTarget(), symlinkDto.getLastModified());
            }
            catch (CollisionException x) {
                logger.info("CollisionException during makeSymlink: {}", (Object)path);
                if (logger.isDebugEnabled()) {
                    logger.debug(x.toString(), (Throwable)x);
                }
                monitor.done();
                return;
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFile(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDtoTreeNode repoFileDtoTreeNode, RepoFileDto normalFileDto, ProgressMonitor monitor) {
        monitor.beginTask("Synchronising...", 100);
        try {
            String path = repoFileDtoTreeNode.getPath();
            logger.info("syncFile: path='{}'", (Object)path);
            RepoFileDto fromRepoFileDto = fromRepoTransport.getRepoFileDto(path);
            if (fromRepoFileDto == null) {
                logger.warn("File was deleted during sync on source side: {}", (Object)path);
                return;
            }
            if (!(fromRepoFileDto instanceof NormalFileDto)) {
                logger.warn("Normal file was replaced by a directory (or another type) during sync on source side: {}", (Object)path);
                return;
            }
            monitor.worked(10);
            NormalFileDto fromNormalFileDto = (NormalFileDto)fromRepoFileDto;
            RepoFileDto toRepoFileDto = toRepoTransport.getRepoFileDto(path);
            if (this.areFilesExistingAndEqual(fromRepoFileDto, toRepoFileDto)) {
                logger.info("File is already equal on destination side (sha1='{}'): {}", (Object)fromNormalFileDto.getSha1(), (Object)path);
                return;
            }
            monitor.worked(10);
            logger.info("Beginning to copy file (from.sha1='{}' to.sha1='{}'): {}", new Object[]{fromNormalFileDto.getSha1(), toRepoFileDto instanceof NormalFileDto ? ((NormalFileDto)toRepoFileDto).getSha1() : "<NoInstanceOf_NormalFileDto>", path});
            NormalFileDto toNormalFileDto = toRepoFileDto instanceof NormalFileDto ? (NormalFileDto)toRepoFileDto : ObjectFactoryUtil.createObject(NormalFileDto.class);
            try {
                this.beginPutFile(fromRepoTransport, toRepoTransport, repoFileDtoTreeNode, path, fromNormalFileDto);
            }
            catch (CollisionException x) {
                logger.info("CollisionException during beginPutFile: {}", (Object)path);
                if (logger.isDebugEnabled()) {
                    logger.debug(x.toString(), (Throwable)x);
                }
                monitor.done();
                return;
            }
            this.localRepoTransport.markFileInProgress(fromRepoTransport.getRepositoryId(), toRepoTransport.getRepositoryId(), path, true);
            monitor.worked(1);
            HashMap<Long, FileChunkDto> offset2ToTempFileChunkDto = new HashMap<Long, FileChunkDto>(toNormalFileDto.getTempFileChunkDtos().size());
            for (FileChunkDto toTempFileChunkDto : toNormalFileDto.getTempFileChunkDtos()) {
                offset2ToTempFileChunkDto.put(toTempFileChunkDto.getOffset(), toTempFileChunkDto);
            }
            logger.debug("Comparing {} FileChunkDtos. path='{}'", (Object)fromNormalFileDto.getFileChunkDtos().size(), (Object)path);
            ArrayList<FileChunkDto> fromFileChunkDtosDirty = new ArrayList<FileChunkDto>();
            Iterator<FileChunkDto> toFileChunkDtoIterator = toNormalFileDto.getFileChunkDtos().iterator();
            int fileChunkIndex = -1;
            for (FileChunkDto fromFileChunkDto : fromNormalFileDto.getFileChunkDtos()) {
                FileChunkDto toFileChunkDto = toFileChunkDtoIterator.hasNext() ? toFileChunkDtoIterator.next() : null;
                ++fileChunkIndex;
                FileChunkDto toTempFileChunkDto = (FileChunkDto)offset2ToTempFileChunkDto.get(fromFileChunkDto.getOffset());
                if (toTempFileChunkDto == null) {
                    if (toFileChunkDto != null && Util.equal(fromFileChunkDto.getOffset(), toFileChunkDto.getOffset()) && Util.equal(fromFileChunkDto.getLength(), toFileChunkDto.getLength()) && Util.equal(fromFileChunkDto.getSha1(), toFileChunkDto.getSha1())) {
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("Skipping clean FileChunkDto. index={} offset={} sha1='{}'", new Object[]{fileChunkIndex, fromFileChunkDto.getOffset(), fromFileChunkDto.getSha1()});
                        continue;
                    }
                } else if (Util.equal(fromFileChunkDto.getOffset(), toTempFileChunkDto.getOffset()) && Util.equal(fromFileChunkDto.getLength(), toTempFileChunkDto.getLength()) && Util.equal(fromFileChunkDto.getSha1(), toTempFileChunkDto.getSha1())) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Skipping clean temporary FileChunkDto. index={} offset={} sha1='{}'", new Object[]{fileChunkIndex, fromFileChunkDto.getOffset(), fromFileChunkDto.getSha1()});
                    continue;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Enlisting dirty FileChunkDto. index={} fromOffset={} toOffset={} fromSha1='{}' toSha1='{}'", new Object[]{fileChunkIndex, fromFileChunkDto.getOffset(), toFileChunkDto == null ? "null" : Long.valueOf(toFileChunkDto.getOffset()), fromFileChunkDto.getSha1(), toFileChunkDto == null ? "null" : toFileChunkDto.getSha1()});
                }
                fromFileChunkDtosDirty.add(fromFileChunkDto);
            }
            logger.info("Need to copy {} dirty file-chunks (of {} total). path='{}'", new Object[]{fromFileChunkDtosDirty.size(), fromNormalFileDto.getFileChunkDtos().size(), path});
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 73);
            subMonitor.beginTask("Synchronising...", fromFileChunkDtosDirty.size());
            fileChunkIndex = -1;
            long bytesCopied = 0L;
            long copyChunksBeginTimestamp = System.currentTimeMillis();
            for (FileChunkDto fileChunkDto : fromFileChunkDtosDirty) {
                byte[] fileData;
                ++fileChunkIndex;
                if (logger.isTraceEnabled()) {
                    logger.trace("Reading data for dirty FileChunkDto (index {} of {}). path='{}' offset={}", new Object[]{fileChunkIndex, fromFileChunkDtosDirty.size(), path, fileChunkDto.getOffset()});
                }
                if ((fileData = this.getFileData(fromRepoTransport, toRepoTransport, repoFileDtoTreeNode, path, fileChunkDto)) == null) {
                    logger.warn("Source file was modified or deleted during sync: {}", (Object)path);
                    return;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Writing data for dirty FileChunkDto ({} of {}). path='{}' offset={}", new Object[]{fileChunkIndex + 1, fromFileChunkDtosDirty.size(), path, fileChunkDto.getOffset()});
                }
                try {
                    this.putFileData(fromRepoTransport, toRepoTransport, repoFileDtoTreeNode, path, fileChunkDto, fileData);
                }
                catch (CollisionException x) {
                    logger.info("CollisionException during putFileData: {}", (Object)path);
                    if (logger.isDebugEnabled()) {
                        logger.debug(x.toString(), (Throwable)x);
                    }
                    monitor.done();
                    return;
                }
                bytesCopied += (long)fileData.length;
                subMonitor.worked(1);
            }
            subMonitor.done();
            logger.info("Copied {} dirty file-chunks with together {} bytes in {} ms. path='{}'", new Object[]{fromFileChunkDtosDirty.size(), bytesCopied, System.currentTimeMillis() - copyChunksBeginTimestamp, path});
            this.endPutFile(fromRepoTransport, toRepoTransport, repoFileDtoTreeNode, path, fromNormalFileDto);
            this.localRepoTransport.markFileInProgress(fromRepoTransport.getRepositoryId(), toRepoTransport.getRepositoryId(), path, false);
            monitor.worked(6);
        }
        finally {
            monitor.done();
        }
    }

    protected byte[] getFileData(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDtoTreeNode repoFileDtoTreeNode, String path, FileChunkDto fileChunkDto) {
        byte[] fileData = fromRepoTransport.getFileData(path, fileChunkDto.getOffset(), fileChunkDto.getLength());
        if (fileData == null) {
            return null;
        }
        if (fileData.length != fileChunkDto.getLength() || !HashUtil.sha1(fileData).equals(fileChunkDto.getSha1())) {
            return null;
        }
        return fileData;
    }

    protected void putFileData(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDtoTreeNode repoFileDtoTreeNode, String path, FileChunkDto fileChunkDto, byte[] fileData) {
        toRepoTransport.putFileData(path, fileChunkDto.getOffset(), fileData);
    }

    protected void beginPutFile(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDtoTreeNode repoFileDtoTreeNode, String path, NormalFileDto fromNormalFileDto) throws CollisionException {
        toRepoTransport.beginPutFile(path);
    }

    protected void endPutFile(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDtoTreeNode repoFileDtoTreeNode, String path, NormalFileDto fromNormalFileDto) {
        toRepoTransport.endPutFile(path, fromNormalFileDto.getLastModified(), fromNormalFileDto.getLength(), fromNormalFileDto.getSha1());
    }

    private boolean areFilesExistingAndEqual(RepoFileDto fromRepoFileDto, RepoFileDto toRepoFileDto) {
        if (!(fromRepoFileDto instanceof NormalFileDto)) {
            return false;
        }
        if (!(toRepoFileDto instanceof NormalFileDto)) {
            return false;
        }
        NormalFileDto fromNormalFileDto = (NormalFileDto)fromRepoFileDto;
        NormalFileDto toNormalFileDto = (NormalFileDto)toRepoFileDto;
        return Util.equal(fromNormalFileDto.getLength(), toNormalFileDto.getLength()) && Util.equal(fromNormalFileDto.getLastModified(), toNormalFileDto.getLastModified()) && Util.equal(fromNormalFileDto.getSha1(), toNormalFileDto.getSha1());
    }

    @Override
    public void close() {
        this.localRepoManager.close();
        this.localRepoTransport.close();
        this.remoteRepoTransport.close();
    }
}

