/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server;

import co.codewizards.cloudstore.core.concurrent.DeferredCompletionException;
import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.dto.ErrorStackTraceElement;
import co.codewizards.cloudstore.rest.server.CloudStoreRest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class DefaultExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionMapper.class);

    public DefaultExceptionMapper(@Context CloudStoreRest cloudStoreRest) {
        logger.debug("<init>: Instance created. cloudStoreRest={}", (Object)cloudStoreRest);
        if (cloudStoreRest == null) {
            throw new IllegalArgumentException("cloudStoreRest == null");
        }
    }

    public Response toResponse(Throwable throwable) {
        Error error;
        if (throwable instanceof DeferredCompletionException) {
            logger.debug(String.valueOf(throwable), throwable);
        } else {
            logger.error(String.valueOf(throwable), throwable);
        }
        if (throwable instanceof WebApplicationException) {
            return ((WebApplicationException)throwable).getResponse();
        }
        Error e = error = new Error(throwable);
        Throwable t = throwable;
        while (t != null) {
            for (StackTraceElement stackTraceElement : t.getStackTrace()) {
                e.getStackTraceElements().add(new ErrorStackTraceElement(stackTraceElement));
            }
            if ((t = t.getCause()) == null) continue;
            Error oldE = e;
            e = new Error(t);
            oldE.setCause(e);
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/xml").entity((Object)error).build();
    }
}

