/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.auth;

import co.codewizards.cloudstore.core.auth.AuthToken;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.UUID;

public class TransientRepoPassword {
    private final UUID serverRepositoryId;
    private final UUID clientRepositoryId;
    private final AuthToken authToken;
    private final char[] password;

    protected TransientRepoPassword(UUID serverRepositoryId, UUID clientRepositoryId, AuthToken authToken) {
        this.serverRepositoryId = (UUID)AssertUtil.assertNotNull((String)"serverRepositoryId", (Object)serverRepositoryId);
        this.clientRepositoryId = (UUID)AssertUtil.assertNotNull((String)"clientRepositoryId", (Object)clientRepositoryId);
        this.authToken = (AuthToken)AssertUtil.assertNotNull((String)"authToken", (Object)authToken);
        authToken.makeUnmodifiable();
        AssertUtil.assertNotNull((String)"authToken.expiryDateTime", (Object)authToken.getExpiryDateTime());
        AssertUtil.assertNotNull((String)"authToken.password", (Object)authToken.getPassword());
        this.password = authToken.getPassword().toCharArray();
    }

    public UUID getServerRepositoryId() {
        return this.serverRepositoryId;
    }

    public UUID getClientRepositoryId() {
        return this.clientRepositoryId;
    }

    public AuthToken getAuthToken() {
        return this.authToken;
    }

    public char[] getPassword() {
        return this.password;
    }
}

