/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.ldap;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.rest.server.auth.Auth;
import co.codewizards.cloudstore.rest.server.auth.NotAuthorizedException;
import co.codewizards.cloudstore.rest.server.ldap.LdapClient;
import co.codewizards.cloudstore.rest.server.ldap.LdapConfig;
import java.util.HashMap;
import java.util.List;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;

public class SimpleLdapClient
implements LdapClient {
    private static final String TEMPLATE_VARIABLE = "login";
    private final List<String> templates;
    private final String url;

    public SimpleLdapClient(List<String> templates, String url) {
        this.templates = (List)AssertUtil.assertNotEmpty((String)"templates", templates);
        this.validateTemplates(templates);
        this.url = (String)AssertUtil.assertNotNull((String)"url", (Object)url);
    }

    @Override
    public String authenticate(Auth auth) {
        for (String template : this.templates) {
            String userNameTemplate = this.convertTemplate(template, auth.getUserName());
            LdapConfig config = new LdapConfig(this.url, userNameTemplate, auth.getPassword());
            if (!this.tryAuthenticate(config)) continue;
            return auth.getUserName();
        }
        throw new NotAuthorizedException();
    }

    private boolean tryAuthenticate(LdapConfig env) {
        try {
            new InitialDirContext(env);
            return true;
        }
        catch (AuthenticationException e) {
            return false;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    private String convertTemplate(String template, String username) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(TEMPLATE_VARIABLE, username);
        return IOUtil.replaceTemplateVariables((String)template, map);
    }

    private void validateTemplates(List<String> templates) {
        String variable = "${login}";
        for (String template : templates) {
            if (template.contains(variable)) continue;
            throw new IllegalArgumentException("every template has to contain " + variable);
        }
    }
}

