/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.service;

import co.codewizards.cloudstore.core.dto.DateTime;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.rest.server.service.AbstractServiceWithRepoToRepoAuth;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="_makeSymlink/{repositoryName}")
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public class MakeSymlinkService
extends AbstractServiceWithRepoToRepoAuth {
    private static final Logger logger = LoggerFactory.getLogger(MakeSymlinkService.class);
    @QueryParam(value="target")
    private String target;
    @QueryParam(value="lastModified")
    private DateTime lastModified;

    public MakeSymlinkService() {
        logger.debug("<init>: created new instance");
    }

    @POST
    public void makeSymlink() {
        this.makeSymlink("");
    }

    @POST
    @Path(value="{path:.*}")
    public void makeSymlink(@PathParam(value="path") String path) {
        AssertUtil.assertNotNull((String)"path", (Object)path);
        AssertUtil.assertNotNull((String)"target", (Object)this.target);
        try (RepoTransport repoTransport = this.authenticateAndCreateLocalRepoTransport();){
            path = repoTransport.unprefixPath(path);
            repoTransport.makeSymlink(path, this.target, this.lastModified == null ? null : this.lastModified.toDate());
        }
    }
}

