/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local;

import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerCloseEvent;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerCloseListener;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.LocalRepoManagerImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalRepoManagerInvocationHandler
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(LocalRepoManagerInvocationHandler.class);
    final LocalRepoManagerImpl localRepoManagerImpl;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final List<LocalRepoManagerCloseListener> localRepoManagerCloseListeners = new CopyOnWriteArrayList<LocalRepoManagerCloseListener>();
    private volatile Throwable proxyCreatedStackTraceException = new Exception("proxyCreatedStackTraceException").fillInStackTrace();
    private static final Set<String> methodsAllowedOnClosedProxy = new HashSet<String>(Arrays.asList("close", "finalize", "isOpen", "equals", "hashCode", "toString"));

    public LocalRepoManagerInvocationHandler(LocalRepoManagerImpl localRepoManagerImpl) {
        this.localRepoManagerImpl = (LocalRepoManagerImpl)AssertUtil.assertNotNull((String)"localRepoManagerImpl", (Object)localRepoManagerImpl);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        LocalRepoManager localRepoManagerProxy = (LocalRepoManager)proxy;
        boolean proxyClosedInThisInvocation = false;
        if (!methodsAllowedOnClosedProxy.contains(method.getName())) {
            this.assertOpen();
        }
        if ("close".equals(method.getName())) {
            proxyClosedInThisInvocation = this.close(localRepoManagerProxy, method, args);
            if (!proxyClosedInThisInvocation) {
                return null;
            }
        } else {
            if ("isOpen".equals(method.getName())) {
                return this.isOpen(localRepoManagerProxy, method, args);
            }
            if ("addLocalRepoManagerCloseListener".equals(method.getName())) {
                this.addLocalRepoManagerCloseListener(localRepoManagerProxy, method, args);
            } else if ("removeLocalRepoManagerCloseListener".equals(method.getName())) {
                this.removeLocalRepoManagerCloseListener(localRepoManagerProxy, method, args);
            } else if ("finalize".equals(method.getName())) {
                this.finalize(localRepoManagerProxy, method, args);
                return null;
            }
        }
        Object result = method.invoke((Object)this.localRepoManagerImpl, args);
        if (proxyClosedInThisInvocation) {
            this.firePostClose(localRepoManagerProxy);
        }
        return result;
    }

    private void assertOpen() {
        if (!this.open.get()) {
            throw new IllegalStateException("This LocalRepoManager (proxy) is already closed!");
        }
    }

    private boolean close(LocalRepoManager localRepoManagerProxy, Method method, Object[] args) {
        this.proxyCreatedStackTraceException = null;
        if (this.open.compareAndSet(true, false)) {
            this.firePreClose(localRepoManagerProxy);
            return true;
        }
        return false;
    }

    private void finalize(LocalRepoManager localRepoManagerProxy, Method method, Object[] args) {
        if (this.proxyCreatedStackTraceException != null) {
            logger.warn("finalize: Detected forgotten close() invocation!", this.proxyCreatedStackTraceException);
        }
        this.close(localRepoManagerProxy, method, args);
    }

    private void firePreClose(LocalRepoManager localRepoManagerProxy) {
        LocalRepoManagerCloseEvent event = new LocalRepoManagerCloseEvent((Object)localRepoManagerProxy, localRepoManagerProxy, false);
        for (LocalRepoManagerCloseListener listener : this.localRepoManagerCloseListeners) {
            listener.preClose(event);
        }
    }

    private void firePostClose(LocalRepoManager localRepoManagerProxy) {
        LocalRepoManagerCloseEvent event = new LocalRepoManagerCloseEvent((Object)localRepoManagerProxy, localRepoManagerProxy, false);
        for (LocalRepoManagerCloseListener listener : this.localRepoManagerCloseListeners) {
            listener.postClose(event);
        }
    }

    private boolean isOpen(LocalRepoManager localRepoManagerProxy, Method method, Object[] args) {
        return this.open.get();
    }

    private void addLocalRepoManagerCloseListener(LocalRepoManager localRepoManagerProxy, Method method, Object[] args) {
        if (args == null || args.length != 1) {
            throw new IllegalArgumentException("args == null || args.length != 1");
        }
        if (!(args[0] instanceof LocalRepoManagerCloseListener)) {
            throw new IllegalArgumentException("args[0] is not an instance of LocalRepoManagerCloseListener");
        }
        this.localRepoManagerCloseListeners.add((LocalRepoManagerCloseListener)args[0]);
    }

    private void removeLocalRepoManagerCloseListener(LocalRepoManager localRepoManagerProxy, Method method, Object[] args) {
        if (args == null || args.length != 1) {
            throw new IllegalArgumentException("args == null || args.length != 1");
        }
        if (!(args[0] instanceof LocalRepoManagerCloseListener)) {
            throw new IllegalArgumentException("args[0] is not an instance of LocalRepoManagerCloseListener");
        }
        this.localRepoManagerCloseListeners.remove(args[0]);
    }
}

