/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.db;

import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.local.db.DatabaseAdapter;
import co.codewizards.cloudstore.local.db.DatabaseAdapterFactory;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseAdapterFactoryRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseAdapterFactoryRegistry.class);
    private DatabaseAdapterFactory databaseAdapterFactory;

    protected DatabaseAdapterFactoryRegistry() {
    }

    public static DatabaseAdapterFactoryRegistry getInstance() {
        return Holder.instance;
    }

    @Deprecated
    public void clearCache() {
        logger.info("clearCache: entered.");
        this.databaseAdapterFactory = null;
    }

    public DatabaseAdapter createDatabaseAdapter() {
        DatabaseAdapterFactory databaseAdapterFactory = this.getDatabaseAdapterFactoryOrFail();
        DatabaseAdapter databaseAdapter = databaseAdapterFactory.createDatabaseAdapter();
        if (databaseAdapter == null) {
            throw new IllegalStateException(String.format("databaseAdapterFactory.createDatabaseAdapter() returned null! Implementation error in %s!", databaseAdapterFactory.getClass().getName()));
        }
        return databaseAdapter;
    }

    protected DatabaseAdapterFactory getDatabaseAdapterFactoryOrFail() {
        DatabaseAdapterFactory databaseAdapterFactory = this.databaseAdapterFactory;
        if (databaseAdapterFactory == null) {
            String databaseAdaptorName = ConfigImpl.getInstance().getPropertyAsNonEmptyTrimmedString("databaseAdapter.name", DatabaseAdapterFactory.DEFAULT_DATABASE_ADAPTER_NAME);
            SortedMap<String, DatabaseAdapterFactory> name2DatabaseAdapter = DatabaseAdapterFactoryRegistry.getName2DatabaseAdapterFactory();
            if (name2DatabaseAdapter.isEmpty()) {
                throw new IllegalStateException("There is no DatabaseAdapterFactory registered!");
            }
            if (StringUtil.isEmpty((String)databaseAdaptorName)) {
                databaseAdapterFactory = DatabaseAdapterFactoryRegistry.getDatabaseAdapterFactoryWithHighestPriority(name2DatabaseAdapter);
            } else {
                databaseAdapterFactory = (DatabaseAdapterFactory)name2DatabaseAdapter.get(databaseAdaptorName);
                if (databaseAdapterFactory == null) {
                    throw new IllegalArgumentException(String.format("There is no DatabaseAdapterFactory with name='%s'!", databaseAdaptorName));
                }
            }
            this.databaseAdapterFactory = databaseAdapterFactory;
        } else {
            logger.debug("getDatabaseAdapterFactoryOrFail: returning existing DatabaseAdapterFactory instance.");
        }
        return databaseAdapterFactory;
    }

    private static SortedMap<String, DatabaseAdapterFactory> getName2DatabaseAdapterFactory() {
        TreeMap<String, DatabaseAdapterFactory> result = new TreeMap<String, DatabaseAdapterFactory>();
        for (DatabaseAdapterFactory a : ServiceLoader.load(DatabaseAdapterFactory.class)) {
            String name = a.getName();
            AssertUtil.assertNotNull((String)String.format("%s.getName()", a.getClass().getName()), (Object)name);
            if (name.indexOf(32) >= 0) {
                throw new IllegalStateException(String.format("%s.getName() returned a symbolic name containing a space!", a.getClass().getName()));
            }
            DatabaseAdapterFactory old = result.put(name, a);
            if (old == null) continue;
            throw new IllegalStateException(String.format("There are multiple DatabaseAdapterFactory classes with name='%s'! %s + %s", name, a.getClass().getName(), old.getClass().getName()));
        }
        return result;
    }

    private static DatabaseAdapterFactory getDatabaseAdapterFactoryWithHighestPriority(SortedMap<String, DatabaseAdapterFactory> name2DatabaseAdapter) {
        DatabaseAdapterFactory databaseAdapterFactory = null;
        for (DatabaseAdapterFactory a : name2DatabaseAdapter.values()) {
            if (databaseAdapterFactory != null && databaseAdapterFactory.getPriority() >= a.getPriority()) continue;
            databaseAdapterFactory = a;
        }
        return databaseAdapterFactory;
    }

    private static final class Holder {
        public static final DatabaseAdapterFactoryRegistry instance = new DatabaseAdapterFactoryRegistry();

        private Holder() {
        }
    }
}

