/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.repo.transport.TransferDoneMarkerType;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.TransferDoneMarker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferDoneMarkerDao
extends Dao<TransferDoneMarker, TransferDoneMarkerDao> {
    private static final Logger logger = LoggerFactory.getLogger(TransferDoneMarkerDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferDoneMarker getTransferDoneMarker(UUID fromRepositoryId, UUID toRepositoryId, TransferDoneMarkerType transferDoneMarkerType, long fromEntityId) {
        AssertUtil.assertNotNull((String)"fromRepositoryId", (Object)fromRepositoryId);
        AssertUtil.assertNotNull((String)"toRepositoryId", (Object)toRepositoryId);
        AssertUtil.assertNotNull((String)"transferDoneMarkerType", (Object)transferDoneMarkerType);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getTransferDoneMarker_fromRepositoryId_toRepositoryId_transferDoneMarkerType_fromEntityId");
        try {
            TransferDoneMarker result;
            HashMap<String, Object> m = new HashMap<String, Object>(4);
            m.put("fromRepositoryId", fromRepositoryId.toString());
            m.put("toRepositoryId", toRepositoryId.toString());
            m.put("transferDoneMarkerType", transferDoneMarkerType);
            m.put("fromEntityId", fromEntityId);
            TransferDoneMarker transferDoneMarker = result = (TransferDoneMarker)query.executeWithMap(m);
            return transferDoneMarker;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TransferDoneMarker> getRepoFileTransferDones(UUID fromRepositoryId, UUID toRepositoryId) {
        AssertUtil.assertNotNull((String)"fromRepositoryId", (Object)fromRepositoryId);
        AssertUtil.assertNotNull((String)"toRepositoryId", (Object)toRepositoryId);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getTransferDoneMarkers_fromRepositoryId_toRepositoryId");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection<TransferDoneMarker> result = (Collection<TransferDoneMarker>)query.execute((Object)fromRepositoryId.toString(), (Object)toRepositoryId.toString());
            logger.debug("getRepoFileTransferDones: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getRepoFileTransferDones: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection<TransferDoneMarker> collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    public void deleteRepoFileTransferDones(UUID fromRepositoryId, UUID toRepositoryId) {
        Collection<TransferDoneMarker> transferDoneMarkers = this.getRepoFileTransferDones(fromRepositoryId, toRepositoryId);
        this.deletePersistentAll(transferDoneMarkers);
    }

    @Override
    protected Collection<TransferDoneMarker> load(Collection<TransferDoneMarker> entities) {
        return new ArrayList<TransferDoneMarker>(entities);
    }
}

