/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot.internal;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.wot.Config;
import org.bouncycastle.openpgp.wot.TrustConst;
import org.bouncycastle.openpgp.wot.TrustDbIoException;
import org.bouncycastle.openpgp.wot.internal.Mutex;
import org.bouncycastle.openpgp.wot.internal.TrustRecord;
import org.bouncycastle.openpgp.wot.internal.TrustRecordType;
import org.bouncycastle.openpgp.wot.internal.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TrustDbIo
implements AutoCloseable,
TrustConst {
    private static final Logger logger = LoggerFactory.getLogger(TrustDbIo.class);
    private final SortedMap<Long, TrustRecord> dirtyRecordNum2TrustRecord = new TreeMap<Long, TrustRecord>();
    private final LinkedHashSet<Long> cacheRecordNums = new LinkedHashSet();
    private final Map<Long, TrustRecord> cacheRecordNum2TrustRecord = new HashMap<Long, TrustRecord>();
    private final File file;
    private final Mutex mutex;
    private final RandomAccessFile raf;
    private final FileLock fileLock;
    private boolean closed;
    private long trustHashRec = 0L;

    public TrustDbIo(File file, Mutex mutex) throws TrustDbIoException {
        this.file = Util.assertNotNull("file", file);
        this.mutex = Util.assertNotNull("mutex", mutex);
        RandomAccessFile raf = null;
        FileLock fileLock = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            int timeoutMillis = 60000;
            int sleepMillis = 500;
            int tryCount = 120;
            for (int i = 0; i < 120; ++i) {
                if (fileLock == null && i != 0) {
                    logger.warn("Locking file '{}' failed. Retrying.", (Object)file.getAbsolutePath());
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Util.doNothing();
                    }
                }
                try {
                    fileLock = raf.getChannel().tryLock();
                }
                catch (OverlappingFileLockException y) {
                    Util.doNothing();
                }
                if (fileLock != null) break;
            }
            if (fileLock == null) {
                fileLock = raf.getChannel().lock();
            }
        }
        catch (IOException x) {
            throw new TrustDbIoException(x);
        }
        finally {
            if (fileLock == null && raf != null) {
                try {
                    raf.close();
                }
                catch (Exception e) {
                    logger.warn("Closing file failed: " + e, (Throwable)e);
                }
            }
        }
        this.raf = raf;
        this.fileLock = fileLock;
        if (this.getTrustRecord(0L, TrustRecord.Version.class) == null) {
            this.createVersionRecord();
        }
    }

    private void createVersionRecord() throws TrustDbIoException {
        Config config = Config.getInstance();
        TrustRecord.Version version = new TrustRecord.Version();
        version.setVersion((short)3);
        version.setCreated(new Date());
        version.setNextCheck(version.getCreated());
        version.setMarginalsNeeded(config.getMarginalsNeeded());
        version.setCompletesNeeded(config.getCompletesNeeded());
        version.setCertDepth(config.getMaxCertDepth());
        version.setTrustModel(config.getTrustModel());
        version.setMinCertLevel(config.getMinCertLevel());
        version.setRecordNum(0L);
        this.putTrustRecord(version);
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVersionRecord(Date nextCheck) throws TrustDbIoException {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            Util.assertNotNull("nextCheck", nextCheck);
            TrustRecord.Version version = this.getTrustRecord(0L, TrustRecord.Version.class);
            Util.assertNotNull("version", version);
            Config config = Config.getInstance();
            version.setCreated(new Date());
            version.setNextCheck(nextCheck);
            version.setMarginalsNeeded(config.getMarginalsNeeded());
            version.setCompletesNeeded(config.getCompletesNeeded());
            version.setCertDepth(config.getMaxCertDepth());
            version.setTrustModel(config.getTrustModel());
            version.setMinCertLevel(config.getMinCertLevel());
            this.putTrustRecord(version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrustRecord getTrustRecord(long recordNum) throws TrustDbIoException {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            return this.getTrustRecord(recordNum, TrustRecord.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrustRecord.Trust getTrustByPublicKey(PGPPublicKey pk) throws TrustDbIoException {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            byte[] fingerprint = pk.getFingerprint();
            return this.getTrustByFingerprint(fingerprint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getTrustHashRec() {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            if (this.trustHashRec == 0L) {
                TrustRecord.Version version = this.getTrustRecord(0L, TrustRecord.Version.class);
                Util.assertNotNull("version", version);
                this.trustHashRec = version.getTrustHashTbl();
                if (this.trustHashRec == 0L) {
                    this.createHashTable(0);
                    this.trustHashRec = version.getTrustHashTbl();
                }
            }
            return this.trustHashRec;
        }
    }

    private void createHashTable(int type) throws TrustDbIoException {
        long offset;
        TrustRecord.Version version = this.getTrustRecord(0L, TrustRecord.Version.class);
        Util.assertNotNull("version", version);
        this.flush();
        try {
            offset = this.raf.length();
            this.raf.seek(offset);
        }
        catch (IOException e) {
            throw new TrustDbIoException(e);
        }
        long recnum = offset / 40L;
        if (recnum <= 0L) {
            throw new IllegalStateException("recnum <= 0");
        }
        if (type == 0) {
            version.setTrustHashTbl(recnum);
        }
        int n = 29;
        int i = 0;
        while (i < 29) {
            TrustRecord.HashTbl hashTable = new TrustRecord.HashTbl();
            hashTable.setRecordNum(recnum);
            this.putTrustRecord(hashTable);
            ++i;
            ++recnum;
        }
        this.putTrustRecord(version);
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long newRecordNum() throws TrustDbIoException {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            long recordNum;
            TrustRecord.Version version = this.getTrustRecord(0L, TrustRecord.Version.class);
            Util.assertNotNull("version", version);
            if (version.getFirstFree() != 0L) {
                recordNum = version.getFirstFree();
                TrustRecord.Free free = this.getTrustRecord(recordNum, TrustRecord.Free.class);
                Util.assertNotNull("free", free);
                version.setFirstFree(free.getNext());
                this.putTrustRecord(version);
            } else {
                long lastDirtyRecordNum;
                long fileLength;
                try {
                    fileLength = this.raf.length();
                }
                catch (IOException e) {
                    throw new TrustDbIoException(e);
                }
                recordNum = fileLength / 40L;
                if (recordNum < 1L) {
                    throw new IllegalStateException("recnum < 1");
                }
                if (!this.dirtyRecordNum2TrustRecord.isEmpty() && (lastDirtyRecordNum = this.dirtyRecordNum2TrustRecord.lastKey().longValue()) >= recordNum) {
                    recordNum = lastDirtyRecordNum + 1L;
                }
            }
            TrustRecord.Unused unused = new TrustRecord.Unused();
            unused.setRecordNum(recordNum);
            this.putTrustRecord(unused);
            return recordNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrustRecord.Trust getTrustByFingerprint(final byte[] fingerprint) throws TrustDbIoException {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            TrustRecord rec = this.getTrustRecordViaHashTable(this.getTrustHashRec(), fingerprint, new TrustRecordMatcher(){

                @Override
                public boolean matches(TrustRecord trustRecord) {
                    if (!(trustRecord instanceof TrustRecord.Trust)) {
                        return false;
                    }
                    TrustRecord.Trust trust = (TrustRecord.Trust)trustRecord;
                    return Arrays.equals(trust.getFingerprint(), fingerprint);
                }
            });
            return (TrustRecord.Trust)rec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrustRecord getTrustRecordViaHashTable(long table, byte[] key, TrustRecordMatcher matcher) {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            TrustRecord record;
            block10: {
                int level = 0;
                long hashrec = table;
                do {
                    int msb;
                    TrustRecord.HashTbl hashTable;
                    if ((hashTable = this.getTrustRecord(hashrec += (long)((msb = key[level] & 0xFF) / 9), TrustRecord.HashTbl.class)) == null) {
                        return null;
                    }
                    long item = hashTable.getItem(msb % 9);
                    if (item == 0L) {
                        return null;
                    }
                    record = this.getTrustRecord(item);
                    Util.assertNotNull("record", record);
                    if (record.getType() != TrustRecordType.HTBL) break block10;
                    hashrec = item;
                } while (++level < key.length);
                throw new TrustDbIoException("hashtable has invalid indirections");
            }
            if (record.getType() == TrustRecordType.HLST) {
                TrustRecord.HashLst hashList = (TrustRecord.HashLst)record;
                while (true) {
                    for (int i = 0; i < 6; ++i) {
                        TrustRecord tmp;
                        if (hashList.getRNum(i) == 0L || (tmp = this.getTrustRecord(hashList.getRNum(i))) == null || !matcher.matches(tmp)) continue;
                        return tmp;
                    }
                    if (hashList.getNext() == 0L) break;
                    hashList = this.getTrustRecord(hashList.getNext(), TrustRecord.HashLst.class);
                    Util.assertNotNull("hashList", hashList);
                }
                return null;
            }
            if (matcher.matches(record)) {
                return record;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends TrustRecord> T getTrustRecord(long recordNum, Class<T> expectedTrustRecordClass) throws TrustDbIoException {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            Util.assertNotNull("expectedTrustRecordClass", expectedTrustRecordClass);
            TrustRecordType expectedType = expectedTrustRecordClass == TrustRecord.class ? null : TrustRecordType.fromClass(expectedTrustRecordClass);
            TrustRecord record = this.getFromCache(recordNum);
            if (record == null) {
                try {
                    this.raf.seek(recordNum * 40L);
                }
                catch (IOException x) {
                    throw new TrustDbIoException(x);
                }
                byte[] buf = new byte[40];
                try {
                    this.raf.readFully(buf);
                }
                catch (EOFException x) {
                    return null;
                }
                catch (IOException x) {
                    throw new TrustDbIoException(x);
                }
                int bufIdx = 0;
                TrustRecordType type = TrustRecordType.fromId((short)(buf[bufIdx++] & 0xFF));
                if (expectedType != null && !expectedType.equals((Object)type)) {
                    throw new IllegalStateException(String.format("expectedType != foundType :: %s != %s", new Object[]{expectedType, type}));
                }
                ++bufIdx;
                switch (type) {
                    case UNUSED: {
                        record = new TrustRecord.Unused();
                        break;
                    }
                    case VERSION: {
                        TrustRecord.Version version = new TrustRecord.Version();
                        record = version;
                        int n = --bufIdx;
                        ++bufIdx;
                        if (buf[n] != 103 || buf[bufIdx++] != 112 || buf[bufIdx++] != 103) {
                            throw new TrustDbIoException(String.format("Not a trustdb file: %s", this.file.getAbsolutePath()));
                        }
                        version.version = (short)(buf[bufIdx++] & 0xFF);
                        version.marginalsNeeded = (short)(buf[bufIdx++] & 0xFF);
                        version.completesNeeded = (short)(buf[bufIdx++] & 0xFF);
                        version.certDepth = (short)(buf[bufIdx++] & 0xFF);
                        version.trustModel = (short)(buf[bufIdx++] & 0xFF);
                        version.minCertLevel = (short)(buf[bufIdx++] & 0xFF);
                        version.created = new Date(1000L * ((long)Util.bytesToInt(buf, bufIdx += 2) & 0xFFFFFFFFL));
                        version.nextCheck = new Date(1000L * ((long)Util.bytesToInt(buf, bufIdx += 4) & 0xFFFFFFFFL));
                        bufIdx += 4;
                        bufIdx += 4;
                        version.firstFree = (long)Util.bytesToInt(buf, bufIdx += 4) & 0xFFFFFFFFL;
                        bufIdx += 4;
                        version.trustHashTbl = (long)Util.bytesToInt(buf, bufIdx += 4) & 0xFFFFFFFFL;
                        bufIdx += 4;
                        if (version.version == 3) break;
                        throw new TrustDbIoException(String.format("Wrong version number (3 expected, but %d found): %s", version.version, this.file.getAbsolutePath()));
                    }
                    case FREE: {
                        TrustRecord.Free free = new TrustRecord.Free();
                        record = free;
                        free.next = (long)Util.bytesToInt(buf, bufIdx) & 0xFFFFFFFFL;
                        bufIdx += 4;
                        break;
                    }
                    case HTBL: {
                        TrustRecord.HashTbl hashTbl = new TrustRecord.HashTbl();
                        record = hashTbl;
                        for (int i = 0; i < 9; ++i) {
                            hashTbl.item[i] = (long)Util.bytesToInt(buf, bufIdx) & 0xFFFFFFFFL;
                            bufIdx += 4;
                        }
                        break;
                    }
                    case HLST: {
                        TrustRecord.HashLst hashLst = new TrustRecord.HashLst();
                        record = hashLst;
                        hashLst.next = (long)Util.bytesToInt(buf, bufIdx) & 0xFFFFFFFFL;
                        bufIdx += 4;
                        for (int i = 0; i < 6; ++i) {
                            hashLst.rnum[i] = (long)Util.bytesToInt(buf, bufIdx) & 0xFFFFFFFFL;
                            bufIdx += 4;
                        }
                        break;
                    }
                    case TRUST: {
                        TrustRecord.Trust trust = new TrustRecord.Trust();
                        record = trust;
                        System.arraycopy(buf, bufIdx, trust.fingerprint, 0, 20);
                        bufIdx += 20;
                        trust.ownerTrust = (short)(buf[bufIdx++] & 0xFF);
                        trust.depth = (short)(buf[bufIdx++] & 0xFF);
                        trust.minOwnerTrust = (short)(buf[bufIdx++] & 0xFF);
                        trust.validList = (long)Util.bytesToInt(buf, ++bufIdx) & 0xFFFFFFFFL;
                        bufIdx += 4;
                        break;
                    }
                    case VALID: {
                        TrustRecord.Valid valid = new TrustRecord.Valid();
                        record = valid;
                        System.arraycopy(buf, bufIdx, valid.nameHash, 0, 20);
                        bufIdx += 20;
                        valid.validity = (short)(buf[bufIdx++] & 0xFF);
                        valid.next = (long)Util.bytesToInt(buf, bufIdx) & 0xFFFFFFFFL;
                        bufIdx += 4;
                        valid.fullCount = (short)(buf[bufIdx++] & 0xFF);
                        valid.marginalCount = (short)(buf[bufIdx++] & 0xFF);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected TrustRecordType: " + (Object)((Object)type));
                    }
                }
                record.recordNum = recordNum;
                this.putToCache(record);
            } else if (expectedType != null && !expectedType.equals((Object)record.getType())) {
                throw new IllegalStateException(String.format("expectedType != foundType :: %s != %s", new Object[]{expectedType, record.getType()}));
            }
            return (T)((TrustRecord)expectedTrustRecordClass.cast(record));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTrustRecord(TrustRecord trustRecord) throws TrustDbIoException {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            Util.assertNotNull("trustRecord", trustRecord);
            if (trustRecord.getRecordNum() < 0L) {
                trustRecord.setRecordNum(this.newRecordNum());
            }
            this.putToCache(trustRecord);
            long recordNum = trustRecord.getRecordNum();
            this.dirtyRecordNum2TrustRecord.put(recordNum, trustRecord);
            if (trustRecord instanceof TrustRecord.Trust) {
                this.updateHashTable(this.getTrustHashRec(), ((TrustRecord.Trust)trustRecord).getFingerprint(), recordNum);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTrustRecord(TrustRecord record) throws TrustDbIoException {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            int bufIdx = 0;
            byte[] buf = new byte[40];
            buf[bufIdx++] = (byte)record.getType().getId();
            ++bufIdx;
            switch (record.getType()) {
                case UNUSED: {
                    break;
                }
                case VERSION: {
                    TrustRecord.Version version = (TrustRecord.Version)record;
                    int n = --bufIdx;
                    buf[n] = 103;
                    int n2 = ++bufIdx;
                    buf[n2] = 112;
                    int n3 = ++bufIdx;
                    buf[n3] = 103;
                    int n4 = ++bufIdx;
                    buf[n4] = (byte)version.version;
                    int n5 = ++bufIdx;
                    buf[n5] = (byte)version.marginalsNeeded;
                    int n6 = ++bufIdx;
                    buf[n6] = (byte)version.completesNeeded;
                    int n7 = ++bufIdx;
                    buf[n7] = (byte)version.certDepth;
                    int n8 = ++bufIdx;
                    buf[n8] = (byte)version.trustModel;
                    int n9 = ++bufIdx;
                    ++bufIdx;
                    buf[n9] = (byte)version.minCertLevel;
                    Util.intToBytes((int)(version.created.getTime() / 1000L), buf, bufIdx += 2);
                    Util.intToBytes((int)(version.nextCheck.getTime() / 1000L), buf, bufIdx += 4);
                    bufIdx += 4;
                    bufIdx += 4;
                    Util.intToBytes((int)version.firstFree, buf, bufIdx += 4);
                    bufIdx += 4;
                    Util.intToBytes((int)version.trustHashTbl, buf, bufIdx += 4);
                    bufIdx += 4;
                    if (version.version == 3) break;
                    throw new TrustDbIoException(String.format("Wrong version number (3 expected, but %d found): %s", version.version, this.file.getAbsolutePath()));
                }
                case FREE: {
                    TrustRecord.Free free = (TrustRecord.Free)record;
                    Util.intToBytes((int)free.next, buf, bufIdx);
                    bufIdx += 4;
                    break;
                }
                case HTBL: {
                    TrustRecord.HashTbl hashTbl = (TrustRecord.HashTbl)record;
                    for (int i = 0; i < 9; ++i) {
                        Util.intToBytes((int)hashTbl.item[i], buf, bufIdx);
                        bufIdx += 4;
                    }
                    break;
                }
                case HLST: {
                    TrustRecord.HashLst hashLst = (TrustRecord.HashLst)record;
                    Util.intToBytes((int)hashLst.next, buf, bufIdx);
                    bufIdx += 4;
                    for (int i = 0; i < 6; ++i) {
                        Util.intToBytes((int)hashLst.rnum[i], buf, bufIdx);
                        bufIdx += 4;
                    }
                    break;
                }
                case TRUST: {
                    TrustRecord.Trust trust = (TrustRecord.Trust)record;
                    System.arraycopy(trust.fingerprint, 0, buf, bufIdx, 20);
                    bufIdx += 20;
                    buf[bufIdx++] = (byte)trust.ownerTrust;
                    buf[bufIdx++] = (byte)trust.depth;
                    buf[bufIdx++] = (byte)trust.minOwnerTrust;
                    Util.intToBytes((int)trust.validList, buf, ++bufIdx);
                    bufIdx += 4;
                    break;
                }
                case VALID: {
                    TrustRecord.Valid valid = (TrustRecord.Valid)record;
                    System.arraycopy(valid.nameHash, 0, buf, bufIdx, 20);
                    bufIdx += 20;
                    buf[bufIdx++] = (byte)valid.validity;
                    Util.intToBytes((int)valid.next, buf, bufIdx);
                    bufIdx += 4;
                    buf[bufIdx++] = (byte)valid.fullCount;
                    buf[bufIdx++] = (byte)valid.marginalCount;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected TrustRecordType: " + (Object)((Object)record.getType()));
                }
            }
            try {
                this.raf.seek(record.getRecordNum() * 40L);
                this.raf.write(buf);
            }
            catch (IOException e) {
                throw new TrustDbIoException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateHashTable(long table, byte[] key, long recordNum) throws TrustDbIoException {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            TrustRecord rec;
            int msb;
            long item;
            long hashrec;
            TrustRecord.HashTbl lastHashTable;
            block13: {
                lastHashTable = null;
                int level = 0;
                hashrec = table;
                do {
                    TrustRecord.HashTbl hashTable;
                    if ((item = (hashTable = this.getTrustRecord(hashrec += (long)((msb = key[level] & 0xFF) / 9), TrustRecord.HashTbl.class)).getItem(msb % 9)) == 0L) {
                        hashTable.setItem(msb % 9, recordNum);
                        this.putTrustRecord(hashTable);
                        return;
                    }
                    if (item == recordNum) {
                        return;
                    }
                    lastHashTable = hashTable;
                    hashTable = null;
                    rec = this.getTrustRecord(item);
                    if (rec.getType() != TrustRecordType.HTBL) break block13;
                    hashrec = item;
                } while (++level < key.length);
                throw new TrustDbIoException("hashtable has invalid indirections.");
            }
            if (rec.getType() == TrustRecordType.HLST) {
                int i;
                TrustRecord.HashLst hashList = (TrustRecord.HashLst)rec;
                while (true) {
                    for (i = 0; i < 6; ++i) {
                        if (hashList.getRNum(i) != recordNum) continue;
                        return;
                    }
                    if (hashList.getNext() == 0L) break;
                    hashList = this.getTrustRecord(hashList.getNext(), TrustRecord.HashLst.class);
                    Util.assertNotNull("hashList", hashList);
                }
                hashList = (TrustRecord.HashLst)rec;
                while (true) {
                    for (i = 0; i < 6; ++i) {
                        if (hashList.getRNum(i) != 0L) continue;
                        hashList.setRnum(i, recordNum);
                        this.putTrustRecord(hashList);
                        return;
                    }
                    if (hashList.getNext() == 0L) break;
                    hashList = this.getTrustRecord(hashList.getNext(), TrustRecord.HashLst.class);
                }
                TrustRecord.HashLst old = hashList;
                hashList = new TrustRecord.HashLst();
                hashList.setRnum(0, recordNum);
                this.putTrustRecord(hashList);
                old.setNext(hashList.getRecordNum());
                this.putTrustRecord(old);
                return;
            }
            if (rec.getType() != TrustRecordType.TRUST) {
                throw new IllegalStateException(String.format("hashtbl %d: %d/%d points to an invalid record %d", table, hashrec, msb % 9, item));
            }
            if (rec.getRecordNum() == recordNum) {
                return;
            }
            TrustRecord.HashLst hashList = new TrustRecord.HashLst();
            hashList.setRnum(0, rec.getRecordNum());
            hashList.setRnum(1, recordNum);
            this.putTrustRecord(hashList);
            Util.assertNotNull("lastHashTable", lastHashTable).setItem(msb % 9, hashList.getRecordNum());
            this.putTrustRecord(lastHashTable);
            return;
        }
    }

    private TrustRecord getFromCache(long recordNum) {
        TrustRecord trustRecord = this.cacheRecordNum2TrustRecord.get(recordNum);
        logger.trace("getFromCache: recordNum={} found={}", (Object)recordNum, (Object)(trustRecord != null ? 1 : 0));
        return trustRecord;
    }

    private void putToCache(TrustRecord trustRecord) {
        Util.assertNotNull("trustRecord", trustRecord);
        long recordNum = trustRecord.getRecordNum();
        if (this.cacheRecordNum2TrustRecord.containsKey(recordNum)) {
            this.cacheRecordNums.remove(recordNum);
        }
        while (this.cacheRecordNums.size() + 1 > 0x100000) {
            Long oldestRecordNum = (Long)this.cacheRecordNums.iterator().next();
            this.cacheRecordNums.remove(oldestRecordNum);
            this.cacheRecordNum2TrustRecord.remove(oldestRecordNum);
        }
        this.cacheRecordNum2TrustRecord.put(recordNum, trustRecord);
        this.cacheRecordNums.add(recordNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws TrustDbIoException {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            for (TrustRecord trustRecord : this.dirtyRecordNum2TrustRecord.values()) {
                this.writeTrustRecord(trustRecord);
            }
            this.dirtyRecordNum2TrustRecord.clear();
            try {
                this.raf.getFD().sync();
            }
            catch (IOException e) {
                throw new TrustDbIoException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws TrustDbIoException {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            if (this.closed) {
                return;
            }
            this.flush();
            this.closed = true;
            try {
                this.fileLock.release();
                this.raf.close();
            }
            catch (IOException e) {
                throw new TrustDbIoException(e);
            }
        }
    }

    private static interface TrustRecordMatcher {
        public boolean matches(TrustRecord var1);
    }
}

