/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.user;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.List;
import java.util.UUID;
import org.subshare.core.repo.ServerRepo;
import org.subshare.core.repo.ServerRepoRegistryImpl;
import org.subshare.core.user.User;
import org.subshare.core.user.UserRegistryImpl;
import org.subshare.core.user.UserRepoKeyRing;
import org.subshare.core.user.UserRepoKeyRingLookup;
import org.subshare.core.user.UserRepoKeyRingLookupContext;

public class UserRepoKeyRingLookupImpl
implements UserRepoKeyRingLookup {
    @Override
    public UserRepoKeyRing getUserRepoKeyRing(UserRepoKeyRingLookupContext context) {
        AssertUtil.assertNotNull((String)"context", (Object)context);
        UUID serverRepositoryId = context.getServerRepositoryId();
        List<ServerRepo> serverRepos = ServerRepoRegistryImpl.getInstance().getServerRepos();
        for (ServerRepo serverRepo : serverRepos) {
            if (!serverRepositoryId.equals(serverRepo.getRepositoryId())) continue;
            return this.getUserRepoKeyRing(serverRepo);
        }
        throw new IllegalArgumentException("No ServerRepo found with serverRepositoryId=" + serverRepositoryId);
    }

    private UserRepoKeyRing getUserRepoKeyRing(ServerRepo serverRepo) {
        AssertUtil.assertNotNull((String)"serverRepo", (Object)serverRepo);
        Uid userId = serverRepo.getUserId();
        AssertUtil.assertNotNull((String)"serverRepo.userId", (Object)userId);
        User user = UserRegistryImpl.getInstance().getUserByUserIdOrFail(userId);
        return user.getUserRepoKeyRingOrCreate();
    }
}

