/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.rest.server.service;

import co.codewizards.cloudstore.core.repo.local.ContextWithLocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.rest.server.service.AbstractServiceWithRepoToRepoAuth;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.Cryptree;
import org.subshare.core.CryptreeFactory;
import org.subshare.core.CryptreeFactoryRegistry;
import org.subshare.core.dto.HistoFrameDto;

@Path(value="_HistoFrameDto/{repositoryName}")
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public class HistoFrameDtoService
extends AbstractServiceWithRepoToRepoAuth {
    private static final Logger logger = LoggerFactory.getLogger(HistoFrameDtoService.class);
    private LocalRepoTransaction transaction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    public void putHistoFrameDto(HistoFrameDto histoFrameDto) {
        AssertUtil.assertNotNull((String)"histoFrameDto", (Object)histoFrameDto);
        try (RepoTransport repoTransport = this.authenticateAndCreateLocalRepoTransport();){
            UUID clientRepositoryId = (UUID)AssertUtil.assertNotNull((String)"clientRepositoryId", (Object)repoTransport.getClientRepositoryId());
            LocalRepoManager localRepoManager = ((ContextWithLocalRepoManager)repoTransport).getLocalRepoManager();
            this.transaction = localRepoManager.beginWriteTransaction();
            try {
                CryptreeFactory cryptreeFactory = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail();
                Cryptree cryptree = cryptreeFactory.getCryptreeOrCreate(this.transaction, clientRepositoryId);
                cryptree.putHistoFrameDto(histoFrameDto);
                this.transaction.commit();
            }
            finally {
                this.transaction.rollbackIfActive();
            }
        }
    }
}

