/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.rest.server.service;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.repo.local.ContextWithLocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.rest.server.service.WebDavService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.UUID;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.subshare.core.Cryptree;
import org.subshare.core.CryptreeFactory;
import org.subshare.core.CryptreeFactoryRegistry;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.sign.VerifierInputStream;
import org.subshare.core.user.UserRepoKey;

@Path(value="{repositoryName:[^_/][^/]*}")
public class SsWebDavService
extends WebDavService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFileData(String path, long offset, byte[] fileData) {
        AssertUtil.assertNotNull((String)"path", (Object)path);
        AssertUtil.assertNotNull((String)"fileData", (Object)fileData);
        try (RepoTransport repoTransport = this.authenticateAndCreateLocalRepoTransport();){
            UUID clientRepositoryId = (UUID)AssertUtil.assertNotNull((String)"clientRepositoryId", (Object)repoTransport.getClientRepositoryId());
            LocalRepoManager localRepoManager = ((ContextWithLocalRepoManager)repoTransport).getLocalRepoManager();
            LocalRepoTransaction transaction = localRepoManager.beginReadTransaction();
            try {
                Uid cryptoRepoFileId;
                UserRepoKey.PublicKey signingUserRepoKeyPublicKey;
                Date signatureCreated;
                CryptreeFactory cryptreeFactory = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail();
                Cryptree cryptree = cryptreeFactory.getCryptreeOrCreate(transaction, clientRepositoryId);
                try {
                    byte[] buf = new byte[65536];
                    ByteArrayInputStream in = new ByteArrayInputStream(fileData);
                    try (VerifierInputStream verifierIn = new VerifierInputStream((InputStream)in, cryptree.getUserRepoKeyPublicKeyLookup());){
                        signatureCreated = verifierIn.getSignatureCreated();
                        signingUserRepoKeyPublicKey = verifierIn.getSigningUserRepoKeyPublicKey();
                        while (verifierIn.read(buf) >= 0) {
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (path.isEmpty() || "/".equals(path)) {
                    cryptoRepoFileId = cryptree.getRootCryptoRepoFileId();
                } else {
                    int lastSlashIndex = path.lastIndexOf(47);
                    String uidStr = lastSlashIndex < 0 ? path : path.substring(lastSlashIndex + 1);
                    cryptoRepoFileId = new Uid(uidStr);
                }
                cryptree.assertIsNotDeletedDuplicateCryptoRepoFile(cryptoRepoFileId);
                cryptree.assertHasPermission(cryptoRepoFileId, signingUserRepoKeyPublicKey.getUserRepoKeyId(), PermissionType.write, signatureCreated);
                transaction.commit();
            }
            finally {
                transaction.rollbackIfActive();
            }
        }
        super.putFileData(path, offset, fileData);
    }

    @DELETE
    @Path(value="{path:.*}")
    public void delete(String path) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }
}

