/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.sign;

import co.codewizards.cloudstore.core.auth.SignatureException;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.io.NullOutputStream;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpDecoder;
import org.subshare.core.pgp.PgpRegistry;
import org.subshare.core.pgp.PgpSignature;
import org.subshare.core.sign.PgpSignable;

public class PgpSignableVerifier {
    private final Pgp pgp;

    public PgpSignableVerifier() {
        this(PgpRegistry.getInstance().getPgpOrFail());
    }

    public PgpSignableVerifier(Pgp pgp) {
        this.pgp = Objects.requireNonNull(pgp, "pgp");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public PgpSignature verify(PgpSignable pgpSignable) throws SignatureException {
        byte[] pgpSignatureData = Objects.requireNonNull(pgpSignable, "pgpSignable").getPgpSignatureData();
        if (pgpSignatureData == null) {
            throw new SignatureException("There is no signature! pgpSignable.pgpSignatureData == null");
        }
        String signedDataType = pgpSignable.getSignedDataType();
        if (StringUtil.isEmpty((String)signedDataType)) {
            throw new IllegalArgumentException(String.format("Implementation error in class %s: pgpSignable.getSignedDataType() returned null! %s", pgpSignable.getClass().getName(), pgpSignable));
        }
        try {
            ByteArrayInputStream in1 = new ByteArrayInputStream(pgpSignatureData);
            int version = in1.read();
            if (version != 1) {
                throw new SignatureException(String.format("pgpSignatureData has unsupported version=%s!", version));
            }
            int signedDataVersion = IOUtil.readOrFail((InputStream)in1) + (IOUtil.readOrFail((InputStream)in1) << 8);
            int signatureBytesLength = IOUtil.readOrFail((InputStream)in1) + (IOUtil.readOrFail((InputStream)in1) << 8) + (IOUtil.readOrFail((InputStream)in1) << 16) + (IOUtil.readOrFail((InputStream)in1) << 24);
            byte[] signatureBytes = new byte[signatureBytesLength];
            IOUtil.readOrFail((InputStream)in1, (byte[])signatureBytes, (int)0, (int)signatureBytesLength);
            ByteArrayOutputStream additionalSignedDataOut = new ByteArrayOutputStream();
            additionalSignedDataOut.write(signedDataType.getBytes(StandardCharsets.UTF_8));
            try (InputStream signedDataInputStream = pgpSignable.getSignedData(signedDataVersion);){
                PgpSignature pgpSignature;
                try (MultiInputStream in = new MultiInputStream(InputStreamSource.Helper.createInputStreamSource(new ByteArrayInputStream(additionalSignedDataOut.toByteArray())), InputStreamSource.Helper.createInputStreamSource(signedDataInputStream));){
                    PgpDecoder decoder = this.pgp.createDecoder(in, new NullOutputStream());
                    decoder.setSignInputStream((IInputStream)new ByteArrayInputStream(signatureBytes));
                    decoder.decode();
                    PgpSignature pgpSignature2 = decoder.getPgpSignature();
                    if (pgpSignature2 == null) {
                        throw new SignatureException("Missing signature!");
                    }
                    pgpSignature = pgpSignature2;
                }
                return pgpSignature;
            }
        }
        catch (IOException x) {
            throw new SignatureException((Throwable)x);
        }
    }
}

