/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.sync;

import co.codewizards.cloudstore.core.Severity;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.util.DateUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.observable.ObservableSet;
import org.subshare.core.observable.standard.StandardPostModificationEvent;
import org.subshare.core.observable.standard.StandardPostModificationListener;
import org.subshare.core.observable.standard.StandardPreModificationEvent;
import org.subshare.core.observable.standard.StandardPreModificationListener;
import org.subshare.core.server.Server;
import org.subshare.core.server.ServerRegistry;
import org.subshare.core.server.ServerRegistryImpl;
import org.subshare.core.sync.Sync;
import org.subshare.core.sync.SyncDaemon;
import org.subshare.core.sync.SyncState;

public abstract class SyncDaemonImpl
implements SyncDaemon {
    private static final Logger logger = LoggerFactory.getLogger(SyncDaemonImpl.class);
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Map<Server, SyncState> server2State = Collections.synchronizedMap(new HashMap());
    private Timer syncTimer;
    private TimerTask syncTimerTask;
    private volatile long syncPeriod;
    private final AtomicBoolean syncRunning = new AtomicBoolean();
    private ServerRegistry serverRegistry;
    private final ObservableSet<SyncState> states = ObservableSet.decorate(new CopyOnWriteArraySet());
    private final PropertyChangeListener serverRegistryPropertyChangeListener;

    protected abstract String getConfigKeySyncPeriod();

    protected abstract long getConfigDefaultValueSyncPeriod();

    protected SyncDaemonImpl() {
        this.states.getHandler().addPreModificationListener(new StandardPreModificationListener(){

            @Override
            public void modificationOccurring(StandardPreModificationEvent event) {
                Collection changeCollection = event.getChangeCollection();
                if ((0x3F & event.getType()) != 0) {
                    for (SyncState state : changeCollection) {
                        SyncState oldState = (SyncState)((Object)SyncDaemonImpl.this.server2State.remove(state.getServer()));
                        if (oldState == null) continue;
                        SyncDaemonImpl.this.states.remove((Object)oldState);
                    }
                }
            }
        });
        this.states.getHandler().addPostModificationListener(new StandardPostModificationListener(){

            @Override
            public void modificationOccurred(StandardPostModificationEvent event) {
                Collection changeCollection = event.getChangeCollection();
                if ((0x3F & event.getType()) != 0) {
                    for (SyncState state : changeCollection) {
                        SyncDaemonImpl.this.server2State.put(state.getServer(), state);
                    }
                    if (!changeCollection.isEmpty()) {
                        SyncDaemonImpl.this.firePropertyChange(SyncDaemon.PropertyEnum.states_added, null, changeCollection);
                    }
                } else if ((0x3F00 & event.getType()) != 0) {
                    for (SyncState state : changeCollection) {
                        SyncState removed = (SyncState)((Object)SyncDaemonImpl.this.server2State.remove(state.getServer()));
                        if (removed == null || removed == state.getServer()) continue;
                        throw new IllegalStateException("removed != state.server");
                    }
                    if (!changeCollection.isEmpty()) {
                        SyncDaemonImpl.this.firePropertyChange(SyncDaemon.PropertyEnum.states_removed, null, changeCollection);
                    }
                } else if ((0x8000 & event.getType()) != 0) {
                    ArrayList removed = new ArrayList(SyncDaemonImpl.this.server2State.values());
                    SyncDaemonImpl.this.server2State.clear();
                    if (!removed.isEmpty()) {
                        SyncDaemonImpl.this.firePropertyChange(SyncDaemon.PropertyEnum.states_removed, null, removed);
                    }
                } else if ((0x4000 & event.getType()) != 0) {
                    ArrayList<SyncState> removed = new ArrayList<SyncState>();
                    for (SyncState state : SyncDaemonImpl.this.states) {
                        if (changeCollection.contains((Object)state)) continue;
                        removed.add(state);
                        SyncDaemonImpl.this.server2State.remove(state.getServer());
                    }
                    if (!removed.isEmpty()) {
                        SyncDaemonImpl.this.firePropertyChange(SyncDaemon.PropertyEnum.states_removed, null, removed);
                    }
                }
                SyncDaemonImpl.this.firePropertyChange(SyncDaemon.PropertyEnum.states, null, SyncDaemonImpl.this.getStates());
            }
        });
        this.serverRegistryPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SyncDaemonImpl.this.getSyncTimer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        SyncDaemonImpl.this._sync();
                    }
                }, 0L);
            }
        };
        this.createSyncTimerTask(true);
        PropertyChangeListenerUtil.addWeakPropertyChangeListener((Object)this.getServerRegistry(), (PropertyChangeListener)this.serverRegistryPropertyChangeListener);
    }

    @Override
    public void sync() {
        this._sync();
        this.createSyncTimerTask(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sync() {
        if (!this.syncRunning.compareAndSet(false, true)) {
            return;
        }
        try {
            HashSet<Server> oldServers = new HashSet<Server>(this.server2State.keySet());
            for (Server server : this.getServerRegistry().getServers()) {
                oldServers.remove(server);
                Sync sync = this.createSync(server);
                try {
                    Date syncStarted = DateUtil.now();
                    try {
                        long startTimestamp = System.currentTimeMillis();
                        sync.sync();
                        String message = String.format("%s: Synchronizing with server '%s' (%s) took %d ms.", sync.getName(), server.getName(), server.getUrl(), System.currentTimeMillis() - startTimestamp);
                        this.getStates().add(new SyncState(server, server.getUrl(), Severity.INFO, message, null, syncStarted, DateUtil.now()));
                    }
                    catch (Exception x) {
                        logger.error("_sync: " + x, (Throwable)x);
                        this.getStates().add(new SyncState(server, server.getUrl(), Severity.ERROR, String.format("%s: %s", sync.getName(), x.getLocalizedMessage()), new Error((Throwable)x), syncStarted, DateUtil.now()));
                    }
                }
                finally {
                    if (sync == null) continue;
                    sync.close();
                }
            }
            ArrayList<SyncState> oldStates = new ArrayList<SyncState>(oldServers.size());
            for (Server server : oldServers) {
                SyncState state = this.server2State.remove(server);
                if (state == null) continue;
                oldStates.add(state);
            }
            if (!oldStates.isEmpty()) {
                this.getStates().removeAll(oldStates);
            }
        }
        catch (Exception x) {
            logger.error("_sync: " + x, (Throwable)x);
        }
        finally {
            this.syncRunning.set(false);
        }
    }

    protected abstract Sync createSync(Server var1);

    private synchronized void recreateSyncTimerTaskIfPeriodChanged() {
        long syncPeriod = ConfigImpl.getInstance().getPropertyAsLong(this.getConfigKeySyncPeriod(), this.getConfigDefaultValueSyncPeriod());
        if (this.syncPeriod != syncPeriod) {
            this.destroySyncTimerTask();
            if (!this.createSyncTimerTask(false)) {
                this.destroySyncTimer();
            }
        }
    }

    private synchronized void destroySyncTimer() {
        if (this.syncTimer != null) {
            this.syncTimer.cancel();
            this.syncTimer = null;
        }
    }

    private synchronized void destroySyncTimerTask() {
        if (this.syncTimerTask != null) {
            this.syncTimerTask.cancel();
            this.syncTimerTask = null;
        }
    }

    private synchronized boolean createSyncTimerTask(boolean runImmediately) {
        long syncPeriod;
        this.destroySyncTimerTask();
        this.syncPeriod = syncPeriod = ConfigImpl.getInstance().getPropertyAsLong(this.getConfigKeySyncPeriod(), this.getConfigDefaultValueSyncPeriod());
        if (syncPeriod <= 0L) {
            return false;
        }
        this.syncTimerTask = new TimerTask(){

            @Override
            public void run() {
                SyncDaemonImpl.this._sync();
                SyncDaemonImpl.this.recreateSyncTimerTaskIfPeriodChanged();
            }
        };
        long delay = runImmediately ? 500L : syncPeriod;
        this.getSyncTimer().schedule(this.syncTimerTask, delay, syncPeriod);
        return true;
    }

    private synchronized Timer getSyncTimer() {
        if (this.syncTimer == null) {
            this.syncTimer = new Timer(true);
        }
        return this.syncTimer;
    }

    protected ServerRegistry getServerRegistry() {
        if (this.serverRegistry == null) {
            this.serverRegistry = ServerRegistryImpl.getInstance();
        }
        return this.serverRegistry;
    }

    @Override
    public Set<SyncState> getStates() {
        return this.states;
    }

    @Override
    public SyncState getState(Server server) {
        Objects.requireNonNull(server, "server");
        return this.server2State.get(server);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(SyncDaemon.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(SyncDaemon.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), listener);
    }

    protected void firePropertyChange(SyncDaemon.Property property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property.name(), oldValue, newValue);
    }
}

