/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.user;

import java.util.Objects;
import org.subshare.core.dto.UserRepoKeyDto;
import org.subshare.core.sign.Signature;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyImpl;

public class UserRepoKeyDtoConverter {
    public UserRepoKeyDto toUserRepoKeyDto(UserRepoKey userRepoKey) {
        Objects.requireNonNull(userRepoKey, "userRepoKey");
        UserRepoKeyDto userRepoKeyDto = new UserRepoKeyDto();
        userRepoKeyDto.setUserRepoKeyId(userRepoKey.getUserRepoKeyId());
        userRepoKeyDto.setServerRepositoryId(userRepoKey.getServerRepositoryId());
        userRepoKeyDto.setEncryptedSignedPrivateKeyData(userRepoKey.getEncryptedSignedPrivateKeyData());
        userRepoKeyDto.setSignedPublicKeyData(userRepoKey.getSignedPublicKeyData());
        userRepoKeyDto.setValidTo(userRepoKey.getValidTo());
        userRepoKeyDto.setInvitation(userRepoKey.isInvitation());
        userRepoKeyDto.setPublicKeySignature(userRepoKey.getPublicKey().getSignature());
        return userRepoKeyDto;
    }

    public UserRepoKey fromUserRepoKeyDto(UserRepoKeyDto userRepoKeyDto) {
        Objects.requireNonNull(userRepoKeyDto, "userRepoKeyDto");
        UserRepoKeyImpl userRepoKey = new UserRepoKeyImpl(userRepoKeyDto.getUserRepoKeyId(), userRepoKeyDto.getServerRepositoryId(), userRepoKeyDto.getEncryptedSignedPrivateKeyData(), userRepoKeyDto.getSignedPublicKeyData(), userRepoKeyDto.getValidTo(), userRepoKeyDto.isInvitation());
        Signature publicKeySignature = userRepoKeyDto.getPublicKeySignature();
        if (publicKeySignature != null) {
            userRepoKey.getPublicKey().setSignature(publicKeySignature);
        }
        return userRepoKey;
    }
}

