/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.local;

import co.codewizards.cloudstore.core.appid.AppIdRegistry;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerCloseListener;
import co.codewizards.cloudstore.core.repo.local.LocalRepoMetaData;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;

public interface LocalRepoManager
extends AutoCloseable {
    public static final String APP_ID_SIMPLE_ID = AppIdRegistry.getInstance().getAppIdOrFail().getSimpleId();
    public static final String SYSTEM_PROPERTY_KEY_SIZE = APP_ID_SIMPLE_ID + ".repository.asymmetricKey.size";
    public static final int DEFAULT_KEY_SIZE = 4096;
    @Deprecated
    public static final String SYSTEM_PROPERTY_CLOSE_DEFERRED_MILLIS = APP_ID_SIMPLE_ID + ".localRepoManager.closeDeferredMillis";
    public static final String CONFIG_KEY_CLOSE_DEFERRED_MILLIS = "localRepoManager.closeDeferredMillis";
    public static final long DEFAULT_CLOSE_DEFERRED_MILLIS = 20000L;
    public static final String META_DIR_NAME = "." + APP_ID_SIMPLE_ID + "-repo";
    public static final String TEMP_DIR_NAME = "." + APP_ID_SIMPLE_ID + "-tmp";
    public static final String TEMP_NEW_FILE_PREFIX = "." + APP_ID_SIMPLE_ID + "-new_";
    public static final String REPO_TEMP_DIR_NAME = "tmp";
    public static final String REPOSITORY_LOCK_FILE_NAME = APP_ID_SIMPLE_ID + "-repository.lock";
    public static final String REPOSITORY_PROPERTIES_FILE_NAME = APP_ID_SIMPLE_ID + "-repository.properties";
    public static final String PROP_REPOSITORY_ID = "repository.id";
    public static final String PROP_VERSION = "repository.version";
    public static final String PROP_REPOSITORY_ALIASES = "repository.aliases";
    public static final String PERSISTENCE_PROPERTIES_FILE_NAME = APP_ID_SIMPLE_ID + "-persistence.properties";
    public static final String VAR_REPOSITORY_ID = "repository.id";
    public static final String VAR_LOCAL_ROOT = "repository.localRoot";
    public static final String VAR_META_DIR = "repository.metaDir";

    public File getLocalRoot();

    public UUID getRepositoryId();

    public byte[] getPrivateKey();

    public byte[] getPublicKey();

    public byte[] getRemoteRepositoryPublicKeyOrFail(UUID var1);

    public void addLocalRepoManagerCloseListener(LocalRepoManagerCloseListener var1);

    public void removeLocalRepoManagerCloseListener(LocalRepoManagerCloseListener var1);

    public boolean isOpen();

    @Override
    public void close();

    public LocalRepoTransaction beginReadTransaction();

    public LocalRepoTransaction beginWriteTransaction();

    public void localSync(ProgressMonitor var1);

    public void putRemoteRepository(UUID var1, URL var2, byte[] var3, String var4);

    public void deleteRemoteRepository(UUID var1);

    public Map<UUID, URL> getRemoteRepositoryId2RemoteRootMap();

    public String getLocalPathPrefixOrFail(URL var1);

    public String getLocalPathPrefixOrFail(UUID var1);

    public UUID getRemoteRepositoryIdOrFail(URL var1);

    public Lock getLock();

    @Deprecated
    public void finalize() throws Throwable;

    public void putRepositoryAlias(String var1);

    public void removeRepositoryAlias(String var1);

    public LocalRepoMetaData getLocalRepoMetaData();
}

