/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Objects;

public final class UrlDecoder {
    private UrlDecoder() {
    }

    public static String decode(String s) {
        String str = UrlDecoder.decode(s, StandardCharsets.UTF_8);
        return str;
    }

    @Deprecated
    public static String decode(String s, String enc) throws UnsupportedEncodingException {
        Charset charset;
        Objects.requireNonNull(s, "s");
        Objects.requireNonNull(enc, "enc");
        try {
            charset = Charset.forName(enc);
        }
        catch (IllegalCharsetNameException e) {
            throw new UnsupportedEncodingException(enc);
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(enc);
        }
        return UrlDecoder.decode(s, charset);
    }

    @Deprecated
    public static String decode(String s, Charset charset) {
        Objects.requireNonNull(s, "s");
        Objects.requireNonNull(charset, "charset");
        boolean needToChange = false;
        int numChars = s.length();
        StringBuffer sb = new StringBuffer(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        block5: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if (v < 0) {
                                throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - negative value");
                            }
                            bytes[pos++] = (byte)v;
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, charset));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block5;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }
}

