/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.version;

import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.UrlUtil;
import co.codewizards.cloudstore.core.version.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocalVersionInIdeHelper {
    protected URL resource;

    protected LocalVersionInIdeHelper() {
    }

    public static LocalVersionInIdeHelper getInstance() {
        return ObjectFactoryUtil.createObject(LocalVersionInIdeHelper.class);
    }

    public Version getLocalVersionInIde() {
        this.resource = this.getClass().getResource("");
        if (this.resource.getProtocol().equalsIgnoreCase("jar")) {
            return this.getLocalVersionInIde_jar();
        }
        if (this.resource.getProtocol().equalsIgnoreCase("file")) {
            return this.getLocalVersionInIde_file();
        }
        throw new IllegalStateException("LocalVersionInIdeHelper was not loaded from a local JAR or class file!");
    }

    protected Version getLocalVersionInIde_jar() {
        Version version;
        block9: {
            String pomXmlResourceName = "META-INF/maven/co.codewizards.cloudstore/co.codewizards.cloudstore.core/pom.xml";
            this.resource = this.getClass().getClassLoader().getResource("META-INF/maven/co.codewizards.cloudstore/co.codewizards.cloudstore.core/pom.xml");
            if (this.resource == null) {
                throw new IllegalStateException("Resource not found in JAR: META-INF/maven/co.codewizards.cloudstore/co.codewizards.cloudstore.core/pom.xml");
            }
            InputStream pomXmlIn = this.resource.openStream();
            try {
                version = this.readVersionFromPomXml(pomXmlIn);
                if (pomXmlIn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pomXmlIn != null) {
                        try {
                            pomXmlIn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            pomXmlIn.close();
        }
        return version;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Version getLocalVersionInIde_file() {
        Version version;
        File pomXmlFile;
        File dir = UrlUtil.getFile(this.resource).getCanonicalFile();
        do {
            pomXmlFile = null;
            if ((dir = dir.getParentFile()) == null) break;
        } while (!(pomXmlFile = dir.createFile("pom.xml")).exists());
        if (pomXmlFile == null) throw new IllegalStateException("Could not determine local version!");
        InputStream pomXmlIn = StreamUtil.castStream(pomXmlFile.createInputStream());
        try {
            version = this.readVersionFromPomXml(pomXmlIn);
            if (pomXmlIn == null) return version;
        }
        catch (Throwable throwable) {
            try {
                if (pomXmlIn == null) throw throwable;
                try {
                    pomXmlIn.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        pomXmlIn.close();
        return version;
    }

    protected Version readVersionFromPomXml(InputStream pomXmlIn) throws IOException {
        String line;
        Pattern pattern = Pattern.compile("<version>([^<]*)</version>");
        BufferedReader reader = new BufferedReader(new InputStreamReader(pomXmlIn, StandardCharsets.UTF_8));
        Matcher matcher = null;
        while (null != (line = reader.readLine())) {
            if (matcher == null) {
                matcher = pattern.matcher(line);
            } else {
                matcher.reset(line);
            }
            if (!matcher.find()) continue;
            String versionString = matcher.group(1);
            return new Version(versionString);
        }
        throw new IllegalStateException("Could not find version inside pom.xml!");
    }
}

