/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local;

import co.codewizards.cloudstore.core.dto.FileChunkDto;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.local.dto.FileChunkDtoConverter;
import co.codewizards.cloudstore.local.dto.RepoFileDtoConverter;
import co.codewizards.cloudstore.local.persistence.FileChunk;
import co.codewizards.cloudstore.local.persistence.LocalRepositoryDao;
import co.codewizards.cloudstore.local.persistence.NormalFile;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.AbstractLocalRepoStorage;
import org.subshare.local.dto.SsFileChunkDtoConverter;
import org.subshare.local.persistence.LocalRepositoryType;
import org.subshare.local.persistence.SsLocalRepository;
import org.subshare.local.persistence.TempFileChunk;
import org.subshare.local.persistence.TempFileChunkDao;

public class LocalRepoStorageImpl
extends AbstractLocalRepoStorage {
    private static final Logger logger = LoggerFactory.getLogger(LocalRepoStorageImpl.class);

    public void makeMetaOnly() {
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        SsLocalRepository localRepository = (SsLocalRepository)((LocalRepositoryDao)transaction.getDao(LocalRepositoryDao.class)).getLocalRepositoryOrFail();
        if (localRepository.getLocalRepositoryType() != LocalRepositoryType.UNINITIALISED) {
            throw new IllegalStateException("localRepositoryType is already initialised: " + localRepository.getLocalRepositoryType());
        }
        localRepository.setLocalRepositoryType(LocalRepositoryType.CLIENT_META_ONLY);
    }

    public boolean isMetaOnly() {
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        SsLocalRepository localRepository = (SsLocalRepository)((LocalRepositoryDao)transaction.getDao(LocalRepositoryDao.class)).getLocalRepositoryOrFail();
        return localRepository.getLocalRepositoryType() == LocalRepositoryType.CLIENT_META_ONLY;
    }

    public Collection<? extends FileChunkDto> getTempFileChunkDtos(String localPath) {
        Objects.requireNonNull(localPath, "localPath");
        UUID remoteRepositoryId = this.getRemoteRepositoryIdOrFail();
        TempFileChunkDao tfcDao = (TempFileChunkDao)((Object)this.getTransactionOrFail().getDao(TempFileChunkDao.class));
        RepoFile repoFile = this.getRepoFile(localPath);
        if (!(repoFile instanceof NormalFile)) {
            return Collections.emptyList();
        }
        NormalFile normalFile = (NormalFile)repoFile;
        SsFileChunkDtoConverter fcDtoConverter = (SsFileChunkDtoConverter)FileChunkDtoConverter.create();
        Collection<TempFileChunk> tempFileChunks = tfcDao.getTempFileChunks(normalFile, remoteRepositoryId);
        ArrayList<FileChunkDto> result = new ArrayList<FileChunkDto>(tempFileChunks.size());
        for (TempFileChunk tempFileChunk : tempFileChunks) {
            if (TempFileChunk.Role.SENDING != tempFileChunk.getRole()) {
                logger.warn("getTempFileChunkDtos: tempFileChunk.role is not SENDING! localPath='{}' normalFile={} tempFileChunk={}", new Object[]{localPath, normalFile, tempFileChunk});
                continue;
            }
            FileChunkDto fileChunkDto = fcDtoConverter.toFileChunkDto(tempFileChunk);
            result.add(fileChunkDto);
        }
        return result;
    }

    public RepoFileDto getRepoFileDto(String localPath) {
        Objects.requireNonNull(localPath, "localPath");
        RepoFile repoFile = this.getRepoFile(localPath);
        if (repoFile == null) {
            return null;
        }
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        RepoFileDtoConverter converter = RepoFileDtoConverter.create((LocalRepoTransaction)transaction);
        RepoFileDto repoFileDto = converter.toRepoFileDto(repoFile, Integer.MAX_VALUE);
        return repoFileDto;
    }

    public void putTempFileChunkDto(String localPath, long offset) {
        Objects.requireNonNull(localPath, "localPath");
        UUID remoteRepositoryId = this.getRemoteRepositoryIdOrFail();
        TempFileChunkDao tfcDao = (TempFileChunkDao)((Object)this.getTransactionOrFail().getDao(TempFileChunkDao.class));
        RepoFile repoFile = this.getRepoFile(localPath);
        if (repoFile == null) {
            throw new IllegalStateException("RepoFile not found for localPath: " + localPath);
        }
        NormalFile normalFile = (NormalFile)repoFile;
        TempFileChunk tempFileChunk = tfcDao.getTempFileChunk(normalFile, remoteRepositoryId, offset);
        if (tempFileChunk == null) {
            tempFileChunk = new TempFileChunk();
            tempFileChunk.setNormalFile(normalFile);
            tempFileChunk.setOffset(offset);
            tempFileChunk.setRemoteRepositoryId(remoteRepositoryId);
        } else if (TempFileChunk.Role.SENDING != tempFileChunk.getRole()) {
            logger.warn("getTempFileChunkDtos: tempFileChunk.role is not SENDING! localPath='{}' normalFile={} tempFileChunk={}", new Object[]{localPath, normalFile, tempFileChunk});
        }
        tempFileChunk.setRole(TempFileChunk.Role.SENDING);
        FileChunk fileChunk = this.getFileChunkOrFail(normalFile, offset);
        tempFileChunk.setLength(fileChunk.getLength());
        tempFileChunk.setSha1(fileChunk.getSha1());
        tfcDao.makePersistent(tempFileChunk);
    }

    private FileChunk getFileChunkOrFail(NormalFile normalFile, long offset) {
        for (FileChunk fileChunk : normalFile.getFileChunks()) {
            if (offset != fileChunk.getOffset()) continue;
            return fileChunk;
        }
        throw new IllegalArgumentException("No FileChunk found for: " + normalFile + " " + offset);
    }

    public void clearTempFileChunkDtos(String localPath) {
        Objects.requireNonNull(localPath, "localPath");
        UUID remoteRepositoryId = this.getRemoteRepositoryIdOrFail();
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        TempFileChunkDao tfcDao = (TempFileChunkDao)((Object)transaction.getDao(TempFileChunkDao.class));
        RepoFile repoFile = this.getRepoFile(localPath);
        if (repoFile == null) {
            logger.debug("clearTempFileChunkDtos: localPath='{}': Nothing to delete!", (Object)localPath);
            return;
        }
        NormalFile normalFile = (NormalFile)repoFile;
        Collection<TempFileChunk> tempFileChunks = tfcDao.getTempFileChunks(normalFile, remoteRepositoryId);
        logger.debug("clearTempFileChunkDtos: localPath='{}': Deleting {} tempFileChunks!", (Object)localPath, (Object)tempFileChunks.size());
        tfcDao.deletePersistentAll(tempFileChunks);
        transaction.flush();
    }

    protected RepoFile getRepoFile(String localPath) {
        Objects.requireNonNull(localPath, "localPath");
        LocalRepoTransaction transaction = this.getTransactionOrFail();
        LocalRepoManager localRepoManager = transaction.getLocalRepoManager();
        RepoFileDao repoFileDao = (RepoFileDao)transaction.getDao(RepoFileDao.class);
        RepoFile repoFile = repoFileDao.getRepoFile(localRepoManager.getLocalRoot(), OioFileFactory.createFile((File)localRepoManager.getLocalRoot(), (String[])new String[]{localPath}));
        return repoFile;
    }
}

