/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.Entity;
import co.codewizards.cloudstore.local.persistence.FetchPlanBackup;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.dto.CryptoRepoFileDto;
import org.subshare.local.persistence.CryptoKeyDao;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CurrentHistoCryptoRepoFile;
import org.subshare.local.persistence.CurrentHistoCryptoRepoFileDao;
import org.subshare.local.persistence.HistoCryptoRepoFile;
import org.subshare.local.persistence.HistoCryptoRepoFileDao;

public class CryptoRepoFileDao
extends Dao<CryptoRepoFile, CryptoRepoFileDao> {
    private static final Logger logger = LoggerFactory.getLogger(CryptoRepoFileDao.class);

    public CryptoRepoFile getCryptoRepoFileOrFail(Uid cryptoRepoFileId) {
        CryptoRepoFile result = this.getCryptoRepoFile(cryptoRepoFileId);
        if (result == null) {
            throw new IllegalArgumentException("There is no CryptoRepoFile for this cryptoRepoFileId: " + cryptoRepoFileId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CryptoRepoFile getCryptoRepoFile(Uid cryptoRepoFileId) {
        Objects.requireNonNull(cryptoRepoFileId, "cryptoRepoFileId");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCryptoRepoFile_cryptoRepoFileId");
        try {
            CryptoRepoFile cryptoRepoFile;
            CryptoRepoFile cryptoRepoFile2 = cryptoRepoFile = (CryptoRepoFile)((Object)query.execute((Object)cryptoRepoFileId.toString()));
            return cryptoRepoFile2;
        }
        finally {
            query.closeAll();
        }
    }

    public CryptoRepoFile getCryptoRepoFileOrFail(RepoFile repoFile) {
        CryptoRepoFile result = this.getCryptoRepoFile(repoFile);
        if (result == null) {
            throw new IllegalArgumentException("There is no CryptoRepoFile for this RepoFile: " + repoFile);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CryptoRepoFile getCryptoRepoFile(RepoFile repoFile) {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCryptoRepoFile_repoFile");
        try {
            CryptoRepoFile cryptoRepoFile;
            CryptoRepoFile cryptoRepoFile2 = cryptoRepoFile = (CryptoRepoFile)((Object)query.execute((Object)repoFile));
            return cryptoRepoFile2;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CryptoRepoFile> getCryptoRepoFilesWithoutRepoFileAndNotDeleted() {
        PersistenceManager pm = this.pm();
        FetchPlanBackup fetchPlanBackup = FetchPlanBackup.createFrom((PersistenceManager)pm);
        Query query = pm.newNamedQuery(this.getEntityClass(), "getCryptoRepoFilesWithoutRepoFileAndNotDeleted");
        try {
            this.clearFetchGroups();
            long startTimestamp = System.currentTimeMillis();
            Collection cryptoRepoFiles = (Collection)query.execute();
            logger.debug("getCryptoRepoFilesWithoutRepoFile: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            fetchPlanBackup.restore(pm);
            startTimestamp = System.currentTimeMillis();
            cryptoRepoFiles = this.load(cryptoRepoFiles);
            logger.debug("getCryptoRepoFilesWithoutRepoFile: Loading result-set with {} elements took {} ms.", (Object)cryptoRepoFiles.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = cryptoRepoFiles;
            return collection;
        }
        finally {
            query.closeAll();
            fetchPlanBackup.restore(pm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CryptoRepoFile> getCryptoRepoFilesChangedAfterExclLastSyncFromRepositoryId(long localRevision, UUID exclLastSyncFromRepositoryId) {
        Objects.requireNonNull(exclLastSyncFromRepositoryId, "exclLastSyncFromRepositoryId");
        PersistenceManager pm = this.pm();
        FetchPlanBackup fetchPlanBackup = FetchPlanBackup.createFrom((PersistenceManager)pm);
        Query query = pm.newNamedQuery(this.getEntityClass(), "getCryptoRepoFilesChangedAfter_localRevision_exclLastSyncFromRepositoryId");
        try {
            this.clearFetchGroups();
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute((Object)localRevision, (Object)exclLastSyncFromRepositoryId.toString());
            logger.debug("getCryptoRepoFileChangedAfterExclLastSyncFromRepositoryId: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            fetchPlanBackup.restore(pm);
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getCryptoRepoFileChangedAfterExclLastSyncFromRepositoryId: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
            fetchPlanBackup.restore(pm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CryptoRepoFileDto> getCryptoRepoFileDtosChangedAfterExclLastSyncFromRepositoryId(long localRevision, UUID exclLastSyncFromRepositoryId) {
        Objects.requireNonNull(exclLastSyncFromRepositoryId, "exclLastSyncFromRepositoryId");
        PersistenceManager pm = this.pm();
        FetchPlanBackup fetchPlanBackup = FetchPlanBackup.createFrom((PersistenceManager)pm);
        Query query = pm.newNamedQuery(this.getEntityClass(), "getCryptoRepoFilesChangedAfter_localRevision_exclLastSyncFromRepositoryId");
        try {
            this.clearFetchGroups();
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute((Object)localRevision, (Object)exclLastSyncFromRepositoryId.toString());
            logger.debug("getCryptoRepoFileDtosChangedAfterExclLastSyncFromRepositoryId: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            List<CryptoRepoFileDto> resultDtos = this.loadDtos(result);
            logger.debug("getCryptoRepoFileDtosChangedAfterExclLastSyncFromRepositoryId: Loading result-set with {} elements took {} ms.", (Object)resultDtos.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            List<CryptoRepoFileDto> list = resultDtos;
            return list;
        }
        finally {
            query.closeAll();
            fetchPlanBackup.restore(pm);
        }
    }

    protected List<CryptoRepoFileDto> loadDtos(Collection<CryptoRepoFile> entities) {
        return this.loadDtos(entities, CryptoRepoFileDto.class, "this.cryptoRepoFileId, this.parent.cryptoRepoFileId, this.cryptoKey.cryptoKeyId, this.directory, this.repoFileDtoData, this.cryptoRepoFileCreated, this.deleted, this.deletedByIgnoreRule, this.signature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CryptoRepoFile> getChildCryptoRepoFiles(CryptoRepoFile parent) {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getChildCryptoRepoFiles_parent");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection cryptoRepoFiles = (Collection)query.execute((Object)parent);
            logger.debug("getChildCryptoRepoFiles: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            cryptoRepoFiles = this.load(cryptoRepoFiles);
            logger.debug("getChildCryptoRepoFiles: Loading result-set with {} elements took {} ms.", (Object)cryptoRepoFiles.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = cryptoRepoFiles;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected Collection<CryptoRepoFile> getChildCryptoRepoFiles(CryptoRepoFile parent, String localName) {
        Objects.requireNonNull(localName, "localName");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getChildCryptoRepoFiles_parent_localName");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection cryptoRepoFiles = (Collection)query.execute((Object)parent, (Object)localName);
            logger.debug("getChildCryptoRepoFiles: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            cryptoRepoFiles = this.load(cryptoRepoFiles);
            logger.debug("getChildCryptoRepoFiles: Loading result-set with {} elements took {} ms.", (Object)cryptoRepoFiles.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = cryptoRepoFiles;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    public CryptoRepoFile getChildCryptoRepoFile(CryptoRepoFile parent, String localName) {
        Objects.requireNonNull(localName, "localName");
        Collection<CryptoRepoFile> childCryptoRepoFiles = this.getChildCryptoRepoFiles(parent, localName);
        if (childCryptoRepoFiles.isEmpty()) {
            return null;
        }
        if (childCryptoRepoFiles.size() == 1) {
            return childCryptoRepoFiles.iterator().next();
        }
        Uid parentCryptoRepoFileId = parent == null ? null : parent.getCryptoRepoFileId();
        String parentLocalName = parent == null ? null : parent.getLocalName();
        logger.error("getChildCryptoRepoFile: Expected 0 or 1, but found multiple child-CryptoRepoFiles! https://github.com/subshare/subshare/issues/50 parentCryptoRepoFileId={}, parentLocalName={}, localName={}, childCryptoRepoFiles={}", new Object[]{parentCryptoRepoFileId, parentLocalName, localName, childCryptoRepoFiles});
        ArrayList<CryptoRepoFile> nonDeletedCrfs = new ArrayList<CryptoRepoFile>();
        for (CryptoRepoFile crf : childCryptoRepoFiles) {
            if (crf.getDeleted() != null) continue;
            nonDeletedCrfs.add(crf);
        }
        if (nonDeletedCrfs.size() == 1) {
            return (CryptoRepoFile)((Object)nonDeletedCrfs.get(0));
        }
        if (nonDeletedCrfs.size() > 1) {
            throw new IllegalStateException(String.format("Found multiple (%s) non-deleted child-CryptoRepoFiles! parentCryptoRepoFileId=%s, parentLocalName=%s, localName=%s", nonDeletedCrfs.size(), parentCryptoRepoFileId, parentLocalName, localName));
        }
        CryptoRepoFile result = null;
        for (CryptoRepoFile crf : childCryptoRepoFiles) {
            if (result != null && !result.getSignature().getSignatureCreated().before(crf.getSignature().getSignatureCreated())) continue;
            result = crf;
        }
        return result;
    }

    public CryptoRepoFile getRootCryptoRepoFile() {
        Collection<CryptoRepoFile> childCryptoRepoFiles = this.getChildCryptoRepoFiles(null);
        Iterator<CryptoRepoFile> iterator = childCryptoRepoFiles.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        CryptoRepoFile rootCryptoRepoFile = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalStateException("There are multiple root-CryptoRepoFiles!");
        }
        return rootCryptoRepoFile;
    }

    public CryptoRepoFile getCryptoRepoFile(RemoteRepository remoteRepository, String localPath) {
        Objects.requireNonNull(remoteRepository, "remoteRepository");
        Objects.requireNonNull(localPath, "localPath");
        String localPathPrefix = remoteRepository.getLocalPathPrefix();
        if ("/".equals(localPathPrefix)) {
            throw new IllegalStateException("This should never be slash! For the root, it should be empty!");
        }
        StringBuilder prefixedLocalPath = new StringBuilder();
        prefixedLocalPath.append(localPathPrefix);
        if (prefixedLocalPath.length() > 0 && prefixedLocalPath.charAt(prefixedLocalPath.length() - 1) != '/' && localPath.length() > 0 && localPath.charAt(0) != '/') {
            prefixedLocalPath.append('/');
        }
        prefixedLocalPath.append(localPath);
        return this.getCryptoRepoFile(prefixedLocalPath.toString());
    }

    public CryptoRepoFile getCryptoRepoFile(String localPath) {
        return this._getCryptoRepoFile(Objects.requireNonNull(localPath, "localPath"), localPath);
    }

    private CryptoRepoFile _getCryptoRepoFile(String localPath, String originallySearchedLocalPath) {
        if ("/".equals(localPath) || localPath.isEmpty()) {
            return this.getRootCryptoRepoFile();
        }
        String parentLocalPath = this.getParentPath(localPath);
        if (parentLocalPath == null) {
            throw new IllegalArgumentException(String.format("Repository does not contain CryptoRepoFile for local path '%s'!", originallySearchedLocalPath));
        }
        CryptoRepoFile parentRepoFile = this._getCryptoRepoFile(parentLocalPath, originallySearchedLocalPath);
        CryptoRepoFile result = this.getChildCryptoRepoFile(parentRepoFile, this.getName(localPath));
        return result;
    }

    private String getName(String path) {
        if ("/".equals(path) || path.isEmpty()) {
            return "";
        }
        int lastSlashIndex = Objects.requireNonNull(path, "path").lastIndexOf(47);
        return path.substring(lastSlashIndex + 1);
    }

    private String getParentPath(String path) {
        if ("/".equals(path) || path.isEmpty()) {
            return null;
        }
        int lastSlashIndex = Objects.requireNonNull(path, "path").lastIndexOf(47);
        String parentPath = path.substring(0, lastSlashIndex);
        if (parentPath.isEmpty()) {
            return "/";
        }
        return parentPath;
    }

    public void deletePersistent(CryptoRepoFile entity) {
        this.nullCryptoRepoKey(entity);
        this.deleteCurrentHistoCryptoRepoFile(entity);
        this.pm().flush();
        this.deleteHistoCryptoRepoFiles(entity);
        this.pm().flush();
        this.deleteCryptoKeys(entity);
        this.pm().flush();
        super.deletePersistent((Entity)entity);
    }

    public void deletePersistentAll(Collection<? extends CryptoRepoFile> entities) {
        for (CryptoRepoFile cryptoRepoFile : entities) {
            this.nullCryptoRepoKey(cryptoRepoFile);
            this.deleteCurrentHistoCryptoRepoFile(cryptoRepoFile);
        }
        this.pm().flush();
        for (CryptoRepoFile cryptoRepoFile : entities) {
            this.deleteHistoCryptoRepoFiles(cryptoRepoFile);
        }
        this.pm().flush();
        for (CryptoRepoFile cryptoRepoFile : entities) {
            this.deleteCryptoKeys(cryptoRepoFile);
        }
        this.pm().flush();
        super.deletePersistentAll(entities);
    }

    protected void nullCryptoRepoKey(CryptoRepoFile cryptoRepoFile) {
        cryptoRepoFile.setCryptoKey(null);
    }

    protected void deleteCurrentHistoCryptoRepoFile(CryptoRepoFile cryptoRepoFile) {
        Objects.requireNonNull(cryptoRepoFile, "cryptoRepoFile");
        CurrentHistoCryptoRepoFileDao chcrfDao = (CurrentHistoCryptoRepoFileDao)this.getDao(CurrentHistoCryptoRepoFileDao.class);
        CurrentHistoCryptoRepoFile chcrf = chcrfDao.getCurrentHistoCryptoRepoFile(cryptoRepoFile);
        if (chcrf != null) {
            chcrfDao.deletePersistent(chcrf);
        }
    }

    protected void deleteHistoCryptoRepoFiles(CryptoRepoFile cryptoRepoFile) {
        Objects.requireNonNull(cryptoRepoFile, "cryptoRepoFile");
        HistoCryptoRepoFileDao hcrfDao = (HistoCryptoRepoFileDao)this.getDao(HistoCryptoRepoFileDao.class);
        Collection<HistoCryptoRepoFile> histoCryptoRepoFiles = hcrfDao.getHistoCryptoRepoFiles(cryptoRepoFile);
        hcrfDao.deletePersistentAll(histoCryptoRepoFiles);
    }

    protected void deleteCryptoKeys(CryptoRepoFile cryptoRepoFile) {
        Objects.requireNonNull(cryptoRepoFile, "cryptoRepoFile");
        CryptoKeyDao cryptoKeyDao = (CryptoKeyDao)this.getDao(CryptoKeyDao.class);
        cryptoKeyDao.deletePersistentAll(cryptoKeyDao.getCryptoKeys(cryptoRepoFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CryptoRepoFile> getDeletedCryptoRepoFilesWithoutCurrentHistoCryptoRepoFileAlsoDeleted() {
        Query query = this.pm().newQuery("SELECT FROM " + CryptoRepoFile.class.getName() + " WHERE this.deleted != null && (SELECT count(chcrf) FROM " + CurrentHistoCryptoRepoFile.class.getName() + " chcrf WHERE chcrf.cryptoRepoFile == this && chcrf.histoCryptoRepoFile.deleted != null) == 0");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection cryptoRepoFiles = (Collection)query.execute();
            logger.debug("getDeletedCryptoRepoFilesWithoutDeletedHistoCryptoRepoFiles: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            cryptoRepoFiles = this.load(cryptoRepoFiles);
            logger.debug("getDeletedCryptoRepoFilesWithoutDeletedHistoCryptoRepoFiles: Loading result-set with {} elements took {} ms.", (Object)cryptoRepoFiles.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = cryptoRepoFiles;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CryptoRepoFile> getCryptoRepoFilesWithRepoFileAndDeleted() {
        Query query = this.pm().newQuery("SELECT FROM " + CryptoRepoFile.class.getName() + " WHERE this.repoFile != null && this.deleted != null");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection cryptoRepoFiles = (Collection)query.execute();
            logger.debug("getCryptoRepoFilesWithRepoFileAndDeleted: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            cryptoRepoFiles = this.load(cryptoRepoFiles);
            logger.debug("getCryptoRepoFilesWithRepoFileAndDeleted: Loading result-set with {} elements took {} ms.", (Object)cryptoRepoFiles.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = cryptoRepoFiles;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    public Set<Long> getChildCryptoRepoFileOidsRecursively(CryptoRepoFile cryptoRepoFile) {
        Objects.requireNonNull(cryptoRepoFile, "cryptoRepoFile");
        long startTimestamp = System.currentTimeMillis();
        Query query = this.pm().newQuery(CryptoRepoFile.class);
        query.setResult("this.id");
        query.setFilter(":parentOids.contains(this.parent.id)");
        HashSet<Long> filterOids = new HashSet<Long>();
        filterOids.add(cryptoRepoFile.getId());
        HashSet<Long> result = new HashSet<Long>();
        result.addAll(filterOids);
        this.populateChildCryptoRepoFileOidsRecursively(result, filterOids, query);
        logger.info("getChildCryptoRepoFileOidsRecursively: Querying {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
        return result;
    }

    private void populateChildCryptoRepoFileOidsRecursively(Set<Long> result, Set<Long> filterOids, Query query) {
        Collection newOidCol = (Collection)query.execute(filterOids);
        HashSet<Long> newOidSet = new HashSet<Long>(newOidCol);
        newOidSet.removeAll(filterOids);
        result.addAll(newOidSet);
        if (!newOidSet.isEmpty()) {
            this.populateChildCryptoRepoFileOidsRecursively(result, newOidSet, query);
        }
    }
}

