/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import java.util.Comparator;
import java.util.Objects;
import org.subshare.local.persistence.CryptoRepoFile;

public class CryptoRepoFilePathComparator
implements Comparator<CryptoRepoFile> {
    @Override
    public int compare(CryptoRepoFile crf1, CryptoRepoFile crf2) {
        if (crf1.equals((Object)crf2)) {
            return 0;
        }
        if (this.isParentOrEqual(crf1, crf2)) {
            return -1;
        }
        if (this.isParentOrEqual(crf2, crf1)) {
            return 1;
        }
        throw new IllegalArgumentException("CryptoRepoFiles are not in a path: " + crf1 + ", " + crf2);
    }

    private boolean isParentOrEqual(CryptoRepoFile parentCandidate, CryptoRepoFile childCandidate) {
        Objects.requireNonNull(parentCandidate, "parentCandidate");
        Objects.requireNonNull(childCandidate, "childCandidate");
        for (CryptoRepoFile crf = childCandidate; crf != null; crf = crf.getParent()) {
            if (!parentCandidate.equals((Object)crf)) continue;
            return true;
        }
        return false;
    }
}

