/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.UUID;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.FetchGroup;
import javax.jdo.annotations.FetchGroups;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.Indices;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.annotations.Uniques;
import javax.jdo.listener.StoreCallback;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.SignatureImpl;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Uniques(value={@Unique(name="UK_HistoFrame_histoFrameId", members={"histoFrameId"}), @Unique(name="UK_HistoFrame_fromRepositoryId_sealed", members={"fromRepositoryId", "sealed"})})
@Indices(value={@Index(name="HistoFrame_histoFrameId", members={"histoFrameId"}), @Index(name="HistoFrame_fromRepositoryId_sealed", members={"fromRepositoryId", "sealed"})})
@Queries(value={@Query(name="getHistoFrame_histoFrameId", value="SELECT UNIQUE WHERE this.histoFrameId == :histoFrameId"), @Query(name="getHistoFramesChangedAfter_localRevision_exclLastSyncFromRepositoryId", value="SELECT WHERE this.localRevision > :localRevision && (this.lastSyncFromRepositoryId == null || this.lastSyncFromRepositoryId != :lastSyncFromRepositoryId)"), @Query(name="getHistoFrame_fromRepositoryId_sealed", value="SELECT UNIQUE WHERE this.fromRepositoryId == :fromRepositoryId && this.sealed == :sealed")})
@FetchGroups(value={@FetchGroup(name="HistoFrameDto", members={@Persistent(name="signature")}), @FetchGroup(name="Signature", members={@Persistent(name="signature")})})
public class HistoFrame
extends Entity
implements WriteProtected,
AutoTrackLocalRevision,
StoreCallback,
Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(length=22)
    private String histoFrameId;
    private long localRevision;
    private String lastSyncFromRepositoryId;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private String fromRepositoryId;
    private Date sealed;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final String[] dnFieldNames = HistoFrame.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = HistoFrame.__dnGetInheritedFieldCount();

    public HistoFrame() {
    }

    public HistoFrame(Uid histoFrameId) {
        this.histoFrameId = histoFrameId == null ? null : histoFrameId.toString();
    }

    public Uid getHistoFrameId() {
        if (HistoFrame.dnGethistoFrameId(this) == null) {
            HistoFrame.dnSethistoFrameId(this, new Uid().toString());
        }
        return new Uid(HistoFrame.dnGethistoFrameId(this));
    }

    public UUID getFromRepositoryId() {
        return HistoFrame.dnGetfromRepositoryId(this) == null ? null : UUID.fromString(HistoFrame.dnGetfromRepositoryId(this));
    }

    public void setFromRepositoryId(UUID fromRepositoryId) {
        if (!Util.equal((Object)this.getFromRepositoryId(), (Object)fromRepositoryId)) {
            HistoFrame.dnSetfromRepositoryId(this, fromRepositoryId == null ? null : fromRepositoryId.toString());
        }
    }

    public void jdoPreStore() {
        this.getHistoFrameId();
    }

    public long getLocalRevision() {
        return HistoFrame.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)HistoFrame.dnGetlocalRevision(this), (long)localRevision)) {
            HistoFrame.dnSetlocalRevision(this, localRevision);
        }
    }

    public String getSignedDataType() {
        return "HistoFrame";
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public Date getSealed() {
        return HistoFrame.dnGetsealed(this);
    }

    public void setSealed(Date sealed) {
        if (!Util.equal((Object)HistoFrame.dnGetsealed(this), (Object)sealed)) {
            HistoFrame.dnSetsealed(this, sealed);
        }
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[5];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((Uid)this.getHistoFrameId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource((UUID)this.getFromRepositoryId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource((Date)HistoFrame.dnGetsealed(this));
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return HistoFrame.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)HistoFrame.dnGetsignature(this), (Object)signature)) {
            HistoFrame.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    public Uid getCryptoRepoFileIdControllingPermissions() {
        return null;
    }

    public PermissionType getPermissionTypeRequiredForWrite() {
        return PermissionType.write;
    }

    public UUID getLastSyncFromRepositoryId() {
        return HistoFrame.dnGetlastSyncFromRepositoryId(this) == null ? null : UUID.fromString(HistoFrame.dnGetlastSyncFromRepositoryId(this));
    }

    public void setLastSyncFromRepositoryId(UUID repositoryId) {
        if (!Util.equal((Object)this.getLastSyncFromRepositoryId(), (Object)repositoryId)) {
            HistoFrame.dnSetlastSyncFromRepositoryId(this, repositoryId == null ? null : repositoryId.toString());
        }
    }

    static {
        EnhancementHelper.registerClass((Class)HistoFrame.___dn$loadClass("org.subshare.local.persistence.HistoFrame"), (Persistable)new HistoFrame());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        HistoFrame result = new HistoFrame();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        HistoFrame result = new HistoFrame();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.fromRepositoryId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.histoFrameId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.lastSyncFromRepositoryId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 3: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 4: {
                this.sealed = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 5: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.fromRepositoryId);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.histoFrameId);
                break;
            }
            case 2: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.lastSyncFromRepositoryId);
                break;
            }
            case 3: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.sealed);
                break;
            }
            case 5: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(HistoFrame obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.fromRepositoryId = obj.fromRepositoryId;
                break;
            }
            case 1: {
                this.histoFrameId = obj.histoFrameId;
                break;
            }
            case 2: {
                this.lastSyncFromRepositoryId = obj.lastSyncFromRepositoryId;
                break;
            }
            case 3: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 4: {
                this.sealed = obj.sealed;
                break;
            }
            case 5: {
                this.signature = obj.signature;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof HistoFrame)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.HistoFrame");
        }
        HistoFrame other = (HistoFrame)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"fromRepositoryId", "histoFrameId", "lastSyncFromRepositoryId", "localRevision", "sealed", "signature"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 6 + Entity.dnGetManagedFieldCount();
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static String dnGetfromRepositoryId(HistoFrame objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.fromRepositoryId);
        }
        return objPC.fromRepositoryId;
    }

    private static void dnSetfromRepositoryId(HistoFrame objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.fromRepositoryId, val);
        } else {
            objPC.fromRepositoryId = val;
        }
    }

    private static String dnGethistoFrameId(HistoFrame objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.histoFrameId);
        }
        return objPC.histoFrameId;
    }

    private static void dnSethistoFrameId(HistoFrame objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.histoFrameId, val);
        } else {
            objPC.histoFrameId = val;
        }
    }

    private static String dnGetlastSyncFromRepositoryId(HistoFrame objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId);
        }
        return objPC.lastSyncFromRepositoryId;
    }

    private static void dnSetlastSyncFromRepositoryId(HistoFrame objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId, val);
        } else {
            objPC.lastSyncFromRepositoryId = val;
        }
    }

    private static long dnGetlocalRevision(HistoFrame objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(HistoFrame objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static Date dnGetsealed(HistoFrame objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4 + dnInheritedFieldCount)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.sealed);
        }
        return objPC.sealed;
    }

    private static void dnSetsealed(HistoFrame objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.sealed, (Object)val);
        } else {
            objPC.sealed = val;
        }
    }

    private static SignatureImpl dnGetsignature(HistoFrame objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(HistoFrame objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }
}

