/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;

public class Util {
    private Util() {
    }

    public static byte[] longToBytes(long value) {
        byte[] bytes = new byte[8];
        Util.longToBytes(value, bytes, 0);
        return bytes;
    }

    public static void longToBytes(long value, byte[] bytes, int index) {
        Objects.requireNonNull(bytes, "bytes");
        if (bytes.length - index < 8) {
            throw new IllegalArgumentException("bytes.length - index < 8");
        }
        for (int i = 0; i < 8; ++i) {
            bytes[index + i] = (byte)(value >>> 8 * (7 - i));
        }
    }

    public static long bytesToLong(byte[] bytes) {
        Objects.requireNonNull(bytes, "bytes");
        if (bytes.length != 8) {
            throw new IllegalArgumentException("bytes.length != 8");
        }
        return Util.bytesToLong(bytes, 0);
    }

    public static long bytesToLong(byte[] bytes, int index) {
        Objects.requireNonNull(bytes, "bytes");
        if (bytes.length - index < 8) {
            throw new IllegalArgumentException("bytes.length - index < 8");
        }
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value |= (long)(bytes[index + i] & 0xFF) << 8 * (7 - i);
        }
        return value;
    }

    public static byte[] intToBytes(int value) {
        byte[] bytes = new byte[4];
        Util.intToBytes(value, bytes, 0);
        return bytes;
    }

    public static void intToBytes(int value, byte[] bytes, int index) {
        Objects.requireNonNull(bytes, "bytes");
        if (bytes.length - index < 4) {
            throw new IllegalArgumentException("bytes.length - index < 4");
        }
        for (int i = 0; i < 4; ++i) {
            bytes[index + i] = (byte)(value >>> 8 * (3 - i));
        }
    }

    public static int bytesToInt(byte[] bytes) {
        Objects.requireNonNull(bytes, "bytes");
        if (bytes.length != 4) {
            throw new IllegalArgumentException("bytes.length != 4");
        }
        return Util.bytesToInt(bytes, 0);
    }

    public static int bytesToInt(byte[] bytes, int index) {
        Objects.requireNonNull(bytes, "bytes");
        if (bytes.length - index < 4) {
            throw new IllegalArgumentException("bytes.length - index < 4");
        }
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value = (int)((long)value | (long)(bytes[index + i] & 0xFF) << 8 * (3 - i));
        }
        return value;
    }

    public static String encodeHexStr(byte[] buf) {
        return Util.encodeHexStr(buf, 0, buf.length);
    }

    public static String encodeHexStr(byte[] buf, int pos, int len) {
        StringBuilder hex = new StringBuilder();
        while (len-- > 0) {
            byte ch;
            int d;
            hex.append((char)((d = (ch = buf[pos++]) >> 4 & 0xF) >= 10 ? 87 + d : 48 + d));
            d = ch & 0xF;
            hex.append((char)(d >= 10 ? 87 + d : 48 + d));
        }
        return hex.toString();
    }

    public static byte[] decodeHexStr(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("The hex string must have an even number of characters!");
        }
        byte[] res = new byte[hex.length() / 2];
        int m = 0;
        for (int i = 0; i < hex.length(); i += 2) {
            res[m++] = (byte)Integer.parseInt(hex.substring(i, i + 2), 16);
        }
        return res;
    }

    public static <E> Iterator<E> nullToEmpty(Iterator<E> iterator) {
        if (iterator == null) {
            return Collections.emptyList().iterator();
        }
        return iterator;
    }

    public static final void doNothing() {
    }
}

