/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.client.ssl;

import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.rest.client.ssl.CallbackDeniedTrustException;
import co.codewizards.cloudstore.rest.client.ssl.CheckServerTrustedCertificateExceptionContext;
import co.codewizards.cloudstore.rest.client.ssl.CheckServerTrustedCertificateExceptionResult;
import co.codewizards.cloudstore.rest.client.ssl.DynamicX509TrustManagerCallback;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class DynamicX509TrustManager
implements X509TrustManager {
    private static final int LOCKFILE_TIMEOUT_MS = 10000;
    private static final char[] TRUST_STORE_PASSWORD_CHAR_ARRAY = "CloudStore".toCharArray();
    private final File trustStoreFile;
    private final DynamicX509TrustManagerCallback callback;
    private X509TrustManager trustManager;
    private final List<Certificate> tempCertList = new ArrayList<Certificate>();

    public DynamicX509TrustManager(File trustStoreFile, DynamicX509TrustManagerCallback callback) {
        this.trustStoreFile = Objects.requireNonNull(trustStoreFile, "trustStoreFile");
        this.callback = Objects.requireNonNull(callback, "callback");
        this.reloadTrustManager();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        Objects.requireNonNull(chain, "chain");
        if (chain.length < 1) {
            throw new IllegalArgumentException("chain is empty!");
        }
        try {
            this.trustManager.checkServerTrusted(chain, authType);
        }
        catch (Exception cx) {
            CheckServerTrustedCertificateExceptionResult result = this.callback.handleCheckServerTrustedCertificateException(new CheckServerTrustedCertificateExceptionContext(chain, cx));
            if (result == null) {
                throw new IllegalStateException("Implementation error: callback.handleCheckServerTrustedCertificateException(...) returned null! callback.class=" + this.callback.getClass().getName());
            }
            if (!result.isTrusted()) {
                throw new CallbackDeniedTrustException(cx);
            }
            this.addServerCertAndReload(chain[0], result.isPermanent());
            this.trustManager.checkServerTrusted(chain, authType);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] issuers = this.trustManager.getAcceptedIssuers();
        return issuers;
    }

    private void reloadTrustManager() {
        try {
            KeyStore trustStore = this.readTrustStore();
            for (Certificate cert : this.tempCertList) {
                trustStore.setCertificateEntry(this.sha1(cert), cert);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            TrustManager[] tms = tmf.getTrustManagers();
            for (int i = 0; i < tms.length; ++i) {
                if (!(tms[i] instanceof X509TrustManager)) continue;
                this.trustManager = (X509TrustManager)tms[i];
                return;
            }
            throw new NoSuchAlgorithmException("No X509TrustManager in TrustManagerFactory");
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    private String sha1(Certificate cert) {
        try {
            byte[] certEncoded = Objects.requireNonNull(cert, "cert").getEncoded();
            byte[] hash = HashUtil.hash((String)"SHA", (InputStream)new ByteArrayInputStream(certEncoded));
            return HashUtil.encodeHexStr((byte[])hash);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    private KeyStore readTrustStore() {
        KeyStore keyStore;
        block15: {
            LockFile lockFile = this.acquireTrustStoreFileLockFile();
            try {
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                try (BufferedInputStream in = new BufferedInputStream(StreamUtil.castStream((IInputStream)lockFile.createInputStream()));){
                    ((InputStream)in).mark(1);
                    boolean empty = ((InputStream)in).read() < 0;
                    ((InputStream)in).reset();
                    ks.load(empty ? null : in, TRUST_STORE_PASSWORD_CHAR_ARRAY);
                }
                keyStore = ks;
                if (lockFile == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (lockFile != null) {
                        try {
                            lockFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException x) {
                    throw x;
                }
                catch (Exception x) {
                    throw new RuntimeException(x);
                }
            }
            lockFile.close();
        }
        return keyStore;
    }

    private void writeTrustStore(KeyStore trustStore) {
        try (LockFile lockFile = this.acquireTrustStoreFileLockFile();
             OutputStream out = StreamUtil.castStream((IOutputStream)lockFile.createOutputStream());){
            trustStore.store(out, TRUST_STORE_PASSWORD_CHAR_ARRAY);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServerCertAndReload(Certificate cert, boolean permanent) {
        try {
            block13: {
                if (permanent) {
                    try (LockFile lockFile = this.acquireTrustStoreFileLockFile();){
                        Lock lock = lockFile.getLock();
                        lock.lock();
                        try {
                            KeyStore trustStore = this.readTrustStore();
                            trustStore.setCertificateEntry(this.sha1(cert), cert);
                            this.writeTrustStore(trustStore);
                            break block13;
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
                this.tempCertList.add(cert);
            }
            this.reloadTrustManager();
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    private LockFile acquireTrustStoreFileLockFile() {
        return LockFileFactory.getInstance().acquire(this.trustStoreFile, 10000L);
    }
}

