/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.filetree;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.gui.filetree.FileTreeItem;
import org.subshare.gui.filetree.FileTreePane;
import org.subshare.gui.filetree.FsHomeFileTreeItem;
import org.subshare.gui.filetree.FsRootFileTreeItem;

public class RootFileTreeItem
extends FileTreeItem<String> {
    private static final Logger logger = LoggerFactory.getLogger(RootFileTreeItem.class);
    private final FileTreePane fileTreePane;

    public RootFileTreeItem(FileTreePane fileTreePane) {
        super("");
        this.fileTreePane = Objects.requireNonNull(fileTreePane, "fileTreePane");
        this.getChildren();
    }

    @Override
    protected FileTreePane getFileTreePane() {
        return this.fileTreePane;
    }

    @Override
    public ObservableList<TreeItem<FileTreeItem<?>>> getChildren() {
        return super.getChildren();
    }

    @Override
    protected List<FileTreeItem<?>> loadChildren() {
        File[] roots;
        LinkedList result = new LinkedList();
        File homeDir = IOUtil.getUserHome();
        result.add(new FsHomeFileTreeItem(homeDir));
        for (File root : roots = OioFileFactory.listRootFiles()) {
            if (!root.isDirectoryNoFollowSymLinks()) {
                logger.warn("loadChildren: root is not a directory: " + root);
            }
            FsRootFileTreeItem treeItem = new FsRootFileTreeItem(root);
            result.add(treeItem);
        }
        return result;
    }
}

