/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.maintree;

import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.bean.WeakPropertyChangeListener;
import co.codewizards.cloudstore.core.util.ReflectionUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;

public class MainTreeItem<T>
extends TreeItem<String> {
    private static final EventType<?> VALUE_OBJECT_CHANGED_EVENT = new EventType(MainTreeItem.treeNotificationEvent(), "ValueObjectChangedEvent");
    private ObjectProperty<T> valueObject;
    private final PropertyChangeListener valueObjectPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            MainTreeItem.this.setValue(MainTreeItem.this.getValueString());
        }
    };
    private WeakPropertyChangeListener valueObjectWeakPropertyChangeListener;
    private Parent mainDetailContent;

    public MainTreeItem() {
        this(null);
    }

    public MainTreeItem(T valueObject) {
        this(valueObject, null);
    }

    public MainTreeItem(T valueObject, Node graphic) {
        this.valueObjectProperty().addListener(new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                MainTreeItem.this.setValue(MainTreeItem.this.getValueString());
            }
        });
        this.setValueObject(valueObject);
        this.setGraphic(graphic);
    }

    protected String getValueString() {
        T valueObject = this.getValueObject();
        return valueObject == null ? "" : valueObject.toString();
    }

    public T getValueObject() {
        return (T)this.valueObjectProperty().get();
    }

    public void setValueObject(T valueObject) {
        this.valueObjectProperty().set(valueObject);
    }

    public final ObjectProperty<T> valueObjectProperty() {
        if (this.valueObject == null) {
            this.valueObject = new ObjectPropertyBase<T>(){

                public void set(T newValue) {
                    Object old = this.get();
                    if (old != null && old != newValue) {
                        MainTreeItem.this.unhookPropertyChangeListener(old);
                    }
                    super.set(newValue);
                    if (newValue != null && old != newValue) {
                        MainTreeItem.this.hookPropertyChangeListener(newValue);
                    }
                }

                protected void invalidated() {
                    MainTreeItem.this.fireEvent(new MainTreeItemEvent((EventType<? extends Event>)VALUE_OBJECT_CHANGED_EVENT, MainTreeItem.this));
                }

                public Object getBean() {
                    return MainTreeItem.this;
                }

                public String getName() {
                    return "valueObject";
                }
            };
        }
        return this.valueObject;
    }

    private void hookPropertyChangeListener(Object object) {
        List addPropertyChangeListenerMethods = ReflectionUtil.getDeclaredMethods(object.getClass(), (String)"addPropertyChangeListener");
        if (!addPropertyChangeListenerMethods.isEmpty()) {
            this.valueObjectWeakPropertyChangeListener = PropertyChangeListenerUtil.addWeakPropertyChangeListener((Object)object, (PropertyChangeListener)this.valueObjectPropertyChangeListener);
        }
    }

    private void unhookPropertyChangeListener(Object object) {
        if (this.valueObjectWeakPropertyChangeListener != null) {
            this.valueObjectWeakPropertyChangeListener.removePropertyChangeListener();
            this.valueObjectWeakPropertyChangeListener = null;
        }
    }

    private void fireEvent(MainTreeItemEvent evt) {
        Event.fireEvent((EventTarget)this, (Event)evt);
    }

    public Parent getMainDetailContent() {
        if (this.mainDetailContent == null) {
            this.mainDetailContent = this.createMainDetailContent();
        }
        return this.mainDetailContent;
    }

    protected Parent createMainDetailContent() {
        return null;
    }

    protected TreeView<String> getTreeView() {
        MainTreeItem parent = (MainTreeItem)this.getParent();
        Objects.requireNonNull(parent, "parent");
        return parent.getTreeView();
    }

    public static class MainTreeItemEvent
    extends TreeItem.TreeModificationEvent<String> {
        private static final long serialVersionUID = 1L;
        private final MainTreeItem<?> mainTreeItem;

        public MainTreeItemEvent(EventType<? extends Event> eventType, MainTreeItem<?> mainTreeItem) {
            super(eventType, mainTreeItem);
            this.mainTreeItem = mainTreeItem;
        }

        public MainTreeItem<?> getMainTreeItem() {
            return this.mainTreeItem;
        }
    }
}

