/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.rest.server.service;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.ls.core.invoke.ClassManager;
import co.codewizards.cloudstore.ls.core.invoke.InvokeMethodExecutor;
import co.codewizards.cloudstore.ls.core.invoke.MethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.MethodInvocationResponse;
import co.codewizards.cloudstore.ls.core.invoke.ObjectManager;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRefWithRefId;
import co.codewizards.cloudstore.ls.core.invoke.filter.ExtMethodInvocationRequest;
import co.codewizards.cloudstore.ls.rest.server.InverseInvoker;
import co.codewizards.cloudstore.ls.rest.server.service.AbstractService;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="InvokeMethod")
@Consumes(value={"application/java-native+oref"})
@Produces(value={"application/java-native+oref"})
public class InvokeMethodService
extends AbstractService {
    private static final InvokeMethodExecutor invokeMethodExecutor = new InvokeMethodExecutor();

    @POST
    public MethodInvocationResponse performMethodInvocation(MethodInvocationRequest methodInvocationRequest) throws Throwable {
        Objects.requireNonNull(methodInvocationRequest, "methodInvocationRequest");
        InverseInvoker inverseInvoker = this.getInverseInvoker();
        ObjectManager objectManager = inverseInvoker.getObjectManager();
        ClassManager classManager = objectManager.getClassManager();
        String className = methodInvocationRequest.getClassName();
        Class clazz = className == null ? null : classManager.getClassOrFail(className);
        String methodName = methodInvocationRequest.getMethodName();
        if ("*objectRef_incRefCount*".equals(methodName)) {
            ObjectRefWithRefId[] objectRefWithRefIds;
            for (ObjectRefWithRefId objectRefWithRefId : objectRefWithRefIds = (ObjectRefWithRefId[])Util.cast((Object)methodInvocationRequest.getArguments()[0])) {
                objectManager.incRefCount(objectRefWithRefId.object, objectRefWithRefId.refId);
            }
            return MethodInvocationResponse.forInvocation(null, null);
        }
        if ("*objectRef_decRefCount*".equals(methodName)) {
            ObjectRefWithRefId[] objectRefWithRefIds;
            for (ObjectRefWithRefId objectRefWithRefId : objectRefWithRefIds = (ObjectRefWithRefId[])Util.cast((Object)methodInvocationRequest.getArguments()[0])) {
                objectManager.decRefCount(objectRefWithRefId.object, objectRefWithRefId.refId);
            }
            return MethodInvocationResponse.forInvocation(null, null);
        }
        if ("*objectManager_close*".equals(methodName)) {
            objectManager.close();
            return MethodInvocationResponse.forInvocation(null, null);
        }
        ExtMethodInvocationRequest extMethodInvocationRequest = new ExtMethodInvocationRequest(objectManager, methodInvocationRequest, clazz);
        return invokeMethodExecutor.execute(extMethodInvocationRequest);
    }

    @GET
    @Path(value="{delayedResponseId}")
    public MethodInvocationResponse getDelayedMethodInvocationResponse(@PathParam(value="delayedResponseId") Uid delayedResponseId) throws Throwable {
        Objects.requireNonNull(delayedResponseId, "delayedResponseId");
        this.getInverseInvoker().getObjectManager();
        return invokeMethodExecutor.getDelayedResponse(delayedResponseId);
    }
}

