/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Date;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPAlgorithmParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKdfParameters;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPPrivateKey;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcaPGPKeyConverter {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private KeyFingerPrintCalculator fingerPrintCalculator = new JcaKeyFingerprintCalculator();

    public JcaPGPKeyConverter setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaPGPKeyConverter setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        return this;
    }

    public PublicKey getPublicKey(PGPPublicKey publicKey) throws PGPException {
        PublicKeyPacket publicPk = publicKey.getPublicKeyPacket();
        try {
            switch (publicPk.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rsaK = (RSAPublicBCPGKey)publicPk.getKey();
                    RSAPublicKeySpec rsaSpec = new RSAPublicKeySpec(rsaK.getModulus(), rsaK.getPublicExponent());
                    KeyFactory fact = this.helper.createKeyFactory("RSA");
                    return fact.generatePublic(rsaSpec);
                }
                case 17: {
                    DSAPublicBCPGKey dsaK = (DSAPublicBCPGKey)publicPk.getKey();
                    DSAPublicKeySpec dsaSpec = new DSAPublicKeySpec(dsaK.getY(), dsaK.getP(), dsaK.getQ(), dsaK.getG());
                    KeyFactory fact = this.helper.createKeyFactory("DSA");
                    return fact.generatePublic(dsaSpec);
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elK = (ElGamalPublicBCPGKey)publicPk.getKey();
                    DHPublicKeySpec elSpec = new DHPublicKeySpec(elK.getY(), elK.getP(), elK.getG());
                    KeyFactory fact = this.helper.createKeyFactory("ElGamal");
                    return fact.generatePublic(elSpec);
                }
                case 18: {
                    ECDHPublicBCPGKey ecdhK = (ECDHPublicBCPGKey)publicPk.getKey();
                    X9ECParameters ecdhParams = JcaJcePGPUtil.getX9Parameters(ecdhK.getCurveOID());
                    org.bouncycastle.math.ec.ECPoint ecdhPoint = JcaJcePGPUtil.decodePoint(ecdhK.getEncodedPoint(), ecdhParams.getCurve());
                    ECPublicKeySpec ecDhSpec = new ECPublicKeySpec(new ECPoint(ecdhPoint.getAffineXCoord().toBigInteger(), ecdhPoint.getAffineYCoord().toBigInteger()), this.getECParameterSpec(ecdhK.getCurveOID(), ecdhParams));
                    KeyFactory fact = this.helper.createKeyFactory("ECDH");
                    return fact.generatePublic(ecDhSpec);
                }
                case 19: {
                    ECDSAPublicBCPGKey ecdsaK = (ECDSAPublicBCPGKey)publicPk.getKey();
                    X9ECParameters ecdsaParams = JcaJcePGPUtil.getX9Parameters(ecdsaK.getCurveOID());
                    org.bouncycastle.math.ec.ECPoint ecdsaPoint = JcaJcePGPUtil.decodePoint(ecdsaK.getEncodedPoint(), ecdsaParams.getCurve());
                    ECPublicKeySpec ecDsaSpec = new ECPublicKeySpec(new ECPoint(ecdsaPoint.getAffineXCoord().toBigInteger(), ecdsaPoint.getAffineYCoord().toBigInteger()), this.getECParameterSpec(ecdsaK.getCurveOID(), ecdsaParams));
                    KeyFactory fact = this.helper.createKeyFactory("ECDSA");
                    return fact.generatePublic(ecDsaSpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("exception constructing public key", e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PGPPublicKey getPGPPublicKey(int algorithm, PGPAlgorithmParameters algorithmParameters, PublicKey pubKey, Date time) throws PGPException {
        void var5_15;
        if (pubKey instanceof RSAPublicKey) {
            RSAPublicKey rK = (RSAPublicKey)pubKey;
            RSAPublicBCPGKey rSAPublicBCPGKey = new RSAPublicBCPGKey(rK.getModulus(), rK.getPublicExponent());
            return new PGPPublicKey(new PublicKeyPacket(algorithm, time, (BCPGKey)var5_15), this.fingerPrintCalculator);
        } else if (pubKey instanceof DSAPublicKey) {
            DSAPublicKey dK = (DSAPublicKey)pubKey;
            DSAParams dP = dK.getParams();
            DSAPublicBCPGKey dSAPublicBCPGKey = new DSAPublicBCPGKey(dP.getP(), dP.getQ(), dP.getG(), dK.getY());
            return new PGPPublicKey(new PublicKeyPacket(algorithm, time, (BCPGKey)var5_15), this.fingerPrintCalculator);
        } else if (pubKey instanceof DHPublicKey) {
            DHPublicKey eK = (DHPublicKey)pubKey;
            DHParameterSpec eS = eK.getParams();
            ElGamalPublicBCPGKey elGamalPublicBCPGKey = new ElGamalPublicBCPGKey(eS.getP(), eS.getG(), eK.getY());
            return new PGPPublicKey(new PublicKeyPacket(algorithm, time, (BCPGKey)var5_15), this.fingerPrintCalculator);
        } else {
            if (!(pubKey instanceof ECPublicKey)) throw new PGPException("unknown key class");
            SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded());
            ASN1ObjectIdentifier curveOid = ASN1ObjectIdentifier.getInstance((Object)keyInfo.getAlgorithm().getParameters());
            X9ECParameters params = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)curveOid);
            DEROctetString key = new DEROctetString(keyInfo.getPublicKeyData().getBytes());
            X9ECPoint derQ = new X9ECPoint(params.getCurve(), (ASN1OctetString)key);
            if (algorithm == 18) {
                PGPKdfParameters kdfParams = (PGPKdfParameters)algorithmParameters;
                if (kdfParams == null) {
                    kdfParams = new PGPKdfParameters(8, 7);
                }
                ECDHPublicBCPGKey eCDHPublicBCPGKey = new ECDHPublicBCPGKey(curveOid, derQ.getPoint(), kdfParams.getHashAlgorithm(), kdfParams.getSymmetricWrapAlgorithm());
                return new PGPPublicKey(new PublicKeyPacket(algorithm, time, (BCPGKey)var5_15), this.fingerPrintCalculator);
            } else {
                if (algorithm != 19) throw new PGPException("unknown EC algorithm");
                ECDSAPublicBCPGKey eCDSAPublicBCPGKey = new ECDSAPublicBCPGKey(curveOid, derQ.getPoint());
            }
        }
        return new PGPPublicKey(new PublicKeyPacket(algorithm, time, (BCPGKey)var5_15), this.fingerPrintCalculator);
    }

    public PGPPublicKey getPGPPublicKey(int algorithm, PublicKey pubKey, Date time) throws PGPException {
        return this.getPGPPublicKey(algorithm, null, pubKey, time);
    }

    public PrivateKey getPrivateKey(PGPPrivateKey privKey) throws PGPException {
        if (privKey instanceof JcaPGPPrivateKey) {
            return ((JcaPGPPrivateKey)privKey).getPrivateKey();
        }
        PublicKeyPacket pubPk = privKey.getPublicKeyPacket();
        BCPGKey privPk = privKey.getPrivateKeyDataPacket();
        try {
            switch (pubPk.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rsaPub = (RSAPublicBCPGKey)pubPk.getKey();
                    RSASecretBCPGKey rsaPriv = (RSASecretBCPGKey)privPk;
                    RSAPrivateCrtKeySpec rsaPrivSpec = new RSAPrivateCrtKeySpec(rsaPriv.getModulus(), rsaPub.getPublicExponent(), rsaPriv.getPrivateExponent(), rsaPriv.getPrimeP(), rsaPriv.getPrimeQ(), rsaPriv.getPrimeExponentP(), rsaPriv.getPrimeExponentQ(), rsaPriv.getCrtCoefficient());
                    KeyFactory fact = this.helper.createKeyFactory("RSA");
                    return fact.generatePrivate(rsaPrivSpec);
                }
                case 17: {
                    DSAPublicBCPGKey dsaPub = (DSAPublicBCPGKey)pubPk.getKey();
                    DSASecretBCPGKey dsaPriv = (DSASecretBCPGKey)privPk;
                    DSAPrivateKeySpec dsaPrivSpec = new DSAPrivateKeySpec(dsaPriv.getX(), dsaPub.getP(), dsaPub.getQ(), dsaPub.getG());
                    KeyFactory fact = this.helper.createKeyFactory("DSA");
                    return fact.generatePrivate(dsaPrivSpec);
                }
                case 18: {
                    ECDHPublicBCPGKey ecdhPub = (ECDHPublicBCPGKey)pubPk.getKey();
                    ECSecretBCPGKey ecdhK = (ECSecretBCPGKey)privPk;
                    ECPrivateKeySpec ecDhSpec = new ECPrivateKeySpec(ecdhK.getX(), this.getECParameterSpec(ecdhPub.getCurveOID()));
                    KeyFactory fact = this.helper.createKeyFactory("ECDH");
                    return fact.generatePrivate(ecDhSpec);
                }
                case 19: {
                    ECDSAPublicBCPGKey ecdsaPub = (ECDSAPublicBCPGKey)pubPk.getKey();
                    ECSecretBCPGKey ecdsaK = (ECSecretBCPGKey)privPk;
                    ECPrivateKeySpec ecDsaSpec = new ECPrivateKeySpec(ecdsaK.getX(), this.getECParameterSpec(ecdsaPub.getCurveOID()));
                    KeyFactory fact = this.helper.createKeyFactory("ECDSA");
                    return fact.generatePrivate(ecDsaSpec);
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elPub = (ElGamalPublicBCPGKey)pubPk.getKey();
                    ElGamalSecretBCPGKey elPriv = (ElGamalSecretBCPGKey)privPk;
                    DHPrivateKeySpec elSpec = new DHPrivateKeySpec(elPriv.getX(), elPub.getP(), elPub.getG());
                    KeyFactory fact = this.helper.createKeyFactory("ElGamal");
                    return fact.generatePrivate(elSpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception constructing key", e);
        }
    }

    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pub, PrivateKey privKey) throws PGPException {
        BCPGObject privPk;
        switch (pub.getAlgorithm()) {
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKey rsK = (RSAPrivateCrtKey)privKey;
                privPk = new RSASecretBCPGKey(rsK.getPrivateExponent(), rsK.getPrimeP(), rsK.getPrimeQ());
                break;
            }
            case 17: {
                DSAPrivateKey dsK = (DSAPrivateKey)privKey;
                privPk = new DSASecretBCPGKey(dsK.getX());
                break;
            }
            case 16: 
            case 20: {
                DHPrivateKey esK = (DHPrivateKey)privKey;
                privPk = new ElGamalSecretBCPGKey(esK.getX());
                break;
            }
            case 18: 
            case 19: {
                ECPrivateKey ecK = (ECPrivateKey)privKey;
                privPk = new ECSecretBCPGKey(ecK.getS());
                break;
            }
            default: {
                throw new PGPException("unknown key class");
            }
        }
        return new PGPPrivateKey(pub.getKeyID(), pub.getPublicKeyPacket(), (BCPGKey)((Object)privPk));
    }

    private ECParameterSpec getECParameterSpec(ASN1ObjectIdentifier curveOid) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException {
        return this.getECParameterSpec(curveOid, JcaJcePGPUtil.getX9Parameters(curveOid));
    }

    private ECParameterSpec getECParameterSpec(ASN1ObjectIdentifier curveOid, X9ECParameters x9Params) throws InvalidParameterSpecException, NoSuchProviderException, NoSuchAlgorithmException {
        AlgorithmParameters params = this.helper.createAlgorithmParameters("EC");
        params.init(new ECGenParameterSpec(ECNamedCurveTable.getName((ASN1ObjectIdentifier)curveOid)));
        return params.getParameterSpec(ECParameterSpec.class);
    }
}

