/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.datanucleus.cache.CacheUniqueKey;
import org.datanucleus.cache.Level1Cache;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.util.ConcurrentReferenceHashMap;

public class WeakRefCache
implements Level1Cache {
    public static final String NAME = "weak";
    private Map<Object, ObjectProvider> weakCache = new ConcurrentReferenceHashMap<Object, ObjectProvider>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);
    private Map<CacheUniqueKey, ObjectProvider> weakCacheUnique = new ConcurrentReferenceHashMap<CacheUniqueKey, ObjectProvider>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    @Override
    public ObjectProvider put(Object id, ObjectProvider op) {
        return this.weakCache.put(id, op);
    }

    @Override
    public ObjectProvider get(Object id) {
        return this.weakCache.get(id);
    }

    @Override
    public boolean containsKey(Object id) {
        return this.weakCache.containsKey(id);
    }

    @Override
    public ObjectProvider remove(Object id) {
        ObjectProvider op = this.weakCache.remove(id);
        if (this.weakCacheUnique.containsValue(op)) {
            Iterator<Map.Entry<CacheUniqueKey, ObjectProvider>> entrySetIter = this.weakCacheUnique.entrySet().iterator();
            while (entrySetIter.hasNext()) {
                Map.Entry<CacheUniqueKey, ObjectProvider> entry = entrySetIter.next();
                if (entry.getValue() != op) continue;
                entrySetIter.remove();
            }
        }
        return op;
    }

    @Override
    public void clear() {
        this.weakCache.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.weakCache.containsValue(value);
    }

    @Override
    public Set entrySet() {
        return this.weakCache.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.weakCache.isEmpty();
    }

    @Override
    public Set keySet() {
        return this.weakCache.keySet();
    }

    @Override
    public void putAll(Map t) {
        this.weakCache.putAll(t);
    }

    @Override
    public int size() {
        return this.weakCache.size();
    }

    @Override
    public Collection values() {
        return this.weakCache.values();
    }

    @Override
    public ObjectProvider getUnique(CacheUniqueKey key) {
        return this.weakCacheUnique.get(key);
    }

    @Override
    public Object putUnique(CacheUniqueKey key, ObjectProvider op) {
        return this.weakCacheUnique.put(key, op);
    }
}

