/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.rest.server.auth;

import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.ls.rest.server.auth.AuthManager;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthFilter
implements ContainerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(AuthFilter.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpServletRequest request;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        CharArrayWriter caw;
        char[] ca;
        char[] password;
        StringBuilder userNameSB;
        byte[] basicAuthDecodedBA;
        block18: {
            String authorizationHeader = this.request.getHeader("Authorization");
            if (authorizationHeader == null || authorizationHeader.isEmpty()) {
                logger.debug("getAuth: There is no 'Authorization' header. Replying with a Status.UNAUTHORIZED response asking for 'Basic' authentication.");
                throw this.newUnauthorizedException();
            }
            logger.debug("getAuth: 'Authorization' header: {}", (Object)authorizationHeader);
            if (!authorizationHeader.startsWith("Basic")) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).type("application/xml").entity((Object)new Error("Only 'Basic' authentication is supported!")).build());
            }
            String basicAuthEncoded = authorizationHeader.substring("Basic".length()).trim();
            basicAuthDecodedBA = this.getBasicAuthEncodedBA(basicAuthEncoded);
            userNameSB = new StringBuilder();
            password = null;
            ByteArrayInputStream in = new ByteArrayInputStream(basicAuthDecodedBA);
            ca = null;
            caw = new CharArrayWriter(basicAuthDecodedBA.length + 1);
            CharArrayReader car = null;
            try {
                int passwordSize;
                int charsRead;
                InputStreamReader r = new InputStreamReader((InputStream)in, "UTF-8");
                int charsReadTotal = 0;
                do {
                    char[] c = new char[10];
                    charsRead = r.read(c);
                    caw.write(c);
                    if (charsRead <= 0) continue;
                    charsReadTotal += charsRead;
                } while (charsRead >= 0);
                charsRead = 0;
                ca = caw.toCharArray();
                car = new CharArrayReader(ca);
                int charsReadTotalCheck = 0;
                while (charsRead >= 0 && charsRead < charsReadTotal) {
                    char[] cbuf = new char[1];
                    charsRead = car.read(cbuf);
                    if (charsRead > 0) {
                        charsReadTotalCheck += charsRead;
                    }
                    if (cbuf[0] == ':') break;
                    userNameSB.append(cbuf[0]);
                }
                if (charsRead < 0 || charsRead >= charsReadTotal || (passwordSize = car.read(password = new char[charsReadTotal - charsReadTotalCheck])) + charsReadTotalCheck == charsReadTotal) break block18;
                throw new IllegalStateException("passwordSize and charsRead must match charsReadTotal! passwordSize=" + passwordSize + ", charsRead=" + charsRead + ", charsReadTotal=" + charsReadTotal);
            }
            catch (Exception e) {
                try {
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/xml").entity((Object)new Error((Throwable)e)).build());
                }
                catch (Throwable throwable) {
                    Arrays.fill(basicAuthDecodedBA, (byte)0);
                    if (ca != null) {
                        Arrays.fill(ca, '\u0000');
                    }
                    if (caw != null) {
                        char[] zeroArray = new char[caw.size()];
                        caw.reset();
                        try {
                            caw.write(zeroArray);
                            caw = null;
                        }
                        catch (IOException e2) {
                            throw new RuntimeException(e2);
                        }
                    }
                    throw throwable;
                }
            }
        }
        Arrays.fill(basicAuthDecodedBA, (byte)0);
        if (ca != null) {
            Arrays.fill(ca, '\u0000');
        }
        if (caw != null) {
            char[] zeroArray = new char[caw.size()];
            caw.reset();
            try {
                caw.write(zeroArray);
                caw = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String userName = userNameSB.toString();
        boolean passwordValid = AuthManager.getInstance().isPasswordValid(password);
        Arrays.fill(password, '\u0000');
        if (passwordValid) {
            requestContext.setSecurityContext((SecurityContext)new SecurityContextImpl(userName, "https".equals(this.uriInfo.getRequestUri().getScheme())));
            return;
        }
        throw this.newUnauthorizedException();
    }

    private WebApplicationException newUnauthorizedException() {
        return new NotAuthorizedException((Object)"Basic realm=\"CloudStoreServer.Local\"", new Object[0]);
    }

    private byte[] getBasicAuthEncodedBA(String basicAuthEncoded) {
        byte[] basicAuthDecodedBA;
        try {
            basicAuthDecodedBA = Base64.getDecoder().decode(basicAuthEncoded.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
        return basicAuthDecodedBA;
    }

    public static class SecurityContextImpl
    implements SecurityContext {
        private final Principal principal;
        private final boolean secure;

        public SecurityContextImpl(final String userName, boolean secure) {
            this.principal = new Principal(){

                @Override
                public String getName() {
                    return userName;
                }
            };
            this.secure = secure;
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role) {
            if ("admin".equals(role)) {
                return false;
            }
            if ("user".equals(role)) {
                return this.principal != null;
            }
            return false;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getAuthenticationScheme() {
            if (this.principal == null) {
                return null;
            }
            return "BASIC";
        }
    }
}

