/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.dbupdate;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.RepositoryCorruptException;
import co.codewizards.cloudstore.core.util.PropertiesUtil;
import co.codewizards.cloudstore.local.db.DatabaseAdapter;
import co.codewizards.cloudstore.local.dbupdate.DbUpdateStep;
import co.codewizards.cloudstore.local.dbupdate.DbUpdateStepRegistry;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.SortedMap;

public class DbUpdateManager {
    protected final File localRoot;
    protected final DbUpdateStepRegistry dbUpdateStepRegistry;
    protected final DatabaseAdapter databaseAdapter;

    public DbUpdateManager(File localRoot, DbUpdateStepRegistry dbUpdateStepRegistry, DatabaseAdapter databaseAdapter) {
        this.localRoot = Objects.requireNonNull(localRoot, "localRoot");
        this.dbUpdateStepRegistry = Objects.requireNonNull(dbUpdateStepRegistry, "dbUpdateStepRegistry");
        this.databaseAdapter = Objects.requireNonNull(databaseAdapter, "databaseAdapter");
    }

    protected File getMetaDir() {
        return this.localRoot.createFile(new String[]{LocalRepoManager.META_DIR_NAME});
    }

    public Properties readRepositoryProperties() {
        Properties repositoryProperties;
        File repositoryPropertiesFile = OioFileFactory.createFile((File)this.getMetaDir(), (String[])new String[]{LocalRepoManager.REPOSITORY_PROPERTIES_FILE_NAME});
        if (!repositoryPropertiesFile.exists()) {
            throw new RepositoryCorruptException(this.localRoot, String.format("Meta-directory does not contain '%s'!", LocalRepoManager.REPOSITORY_PROPERTIES_FILE_NAME));
        }
        try {
            repositoryProperties = PropertiesUtil.load((File)repositoryPropertiesFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return repositoryProperties;
    }

    public int readRepositoryVersion() {
        int ver;
        Properties repositoryProperties = this.readRepositoryProperties();
        String version = repositoryProperties.getProperty("repository.version");
        if (version == null || version.isEmpty()) {
            throw new RepositoryCorruptException(this.localRoot, String.format("Meta-file '%s' does not contain property '%s'!", LocalRepoManager.REPOSITORY_PROPERTIES_FILE_NAME, "repository.version"));
        }
        version = version.trim();
        try {
            ver = Integer.parseInt(version);
        }
        catch (NumberFormatException x) {
            throw new RepositoryCorruptException(this.localRoot, String.format("Meta-file '%s' contains an illegal value (not a number) for property '%s'!", LocalRepoManager.REPOSITORY_PROPERTIES_FILE_NAME, "repository.version"));
        }
        return ver;
    }

    public void performUpdate() {
        int lastVersion = this.readRepositoryVersion();
        SortedMap<Integer, List<DbUpdateStep>> version2dbUpdateSteps = this.dbUpdateStepRegistry.getDbUpdateStepsAfter(lastVersion);
        for (Map.Entry<Integer, List<DbUpdateStep>> me : version2dbUpdateSteps.entrySet()) {
            int version = me.getKey();
            for (DbUpdateStep dbUpdateStep : me.getValue()) {
                try {
                    dbUpdateStep.setDatabaseAdapter(this.databaseAdapter);
                    dbUpdateStep.performUpdate();
                }
                catch (Exception x) {
                    throw new RepositoryCorruptException(this.localRoot, String.format("Updating repository via '%s' failed!", dbUpdateStep.getClass().getName()), (Throwable)x);
                }
            }
            this.writeRepositoryVersion(version);
            lastVersion = version;
        }
        int version = this.readRepositoryVersion();
        if (lastVersion != version) {
            throw new RepositoryCorruptException(this.localRoot, String.format("Writing lastVersion seems to have failed! Newly read version=%d, but expected version=%d!", version, lastVersion));
        }
    }

    protected void writeRepositoryVersion(int version) {
        Properties repositoryProperties;
        File repositoryPropertiesFile = OioFileFactory.createFile((File)this.getMetaDir(), (String[])new String[]{LocalRepoManager.REPOSITORY_PROPERTIES_FILE_NAME});
        if (!repositoryPropertiesFile.exists()) {
            throw new RepositoryCorruptException(this.localRoot, String.format("Meta-directory does not contain '%s'!", LocalRepoManager.REPOSITORY_PROPERTIES_FILE_NAME));
        }
        try {
            repositoryProperties = PropertiesUtil.load((File)repositoryPropertiesFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        repositoryProperties.setProperty("repository.version", Integer.toString(version));
        try {
            PropertiesUtil.store((File)repositoryPropertiesFile, (Properties)repositoryProperties, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

