/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import javax.jdo.PersistenceManager;

public interface CloudStorePersistenceCapableClassesProvider {
    public int getOrderHint();

    public Class<?>[] getPersistenceCapableClasses();

    public static class Helper {
        public static List<Class<?>> getPersistenceCapableClasses() {
            ArrayList resultList = new ArrayList();
            HashSet<Class> resultSet = new HashSet<Class>();
            LinkedList<CloudStorePersistenceCapableClassesProvider> providers = new LinkedList<CloudStorePersistenceCapableClassesProvider>();
            ServiceLoader<CloudStorePersistenceCapableClassesProvider> sl = ServiceLoader.load(CloudStorePersistenceCapableClassesProvider.class);
            for (CloudStorePersistenceCapableClassesProvider provider : sl) {
                providers.add(provider);
            }
            Collections.sort(providers, new Comparator<CloudStorePersistenceCapableClassesProvider>(){

                @Override
                public int compare(CloudStorePersistenceCapableClassesProvider o1, CloudStorePersistenceCapableClassesProvider o2) {
                    int res = Integer.compare(o1.getOrderHint(), o2.getOrderHint());
                    if (res == 0) {
                        res = o1.getClass().getName().compareTo(o2.getClass().getName());
                    }
                    return res;
                }
            });
            for (CloudStorePersistenceCapableClassesProvider provider : providers) {
                Class<?>[] classes = provider.getPersistenceCapableClasses();
                if (classes == null) continue;
                for (Class<?> clazz : classes) {
                    Class c = ObjectFactoryUtil.getExtendingClass(clazz);
                    if (!resultSet.add(c)) continue;
                    resultList.add(c);
                }
            }
            return resultList;
        }

        public static void initPersistenceCapableClasses(PersistenceManager pm) {
            for (Class<?> clazz : Helper.getPersistenceCapableClasses()) {
                pm.getExtent(clazz);
            }
        }
    }
}

