/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.util.UUID;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.annotations.Discriminator;
import javax.jdo.annotations.DiscriminatorStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Unique;
import javax.jdo.listener.StoreCallback;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;

@PersistenceCapable
@Discriminator(strategy=DiscriminatorStrategy.VALUE_MAP)
@Unique(name="Repository_repositoryId", members={"repositoryId"})
public abstract class Repository
extends Entity
implements StoreCallback,
Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    private String repositoryId;
    private long revision;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private byte[] publicKey;
    private static final String[] dnFieldNames = Repository.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = Repository.__dnGetInheritedFieldCount();

    public Repository() {
    }

    protected Repository(UUID repositoryId) {
        this.repositoryId = repositoryId == null ? null : repositoryId.toString();
    }

    public UUID getRepositoryId() {
        if (Repository.dnGetrepositoryId(this) == null) {
            Repository.dnSetrepositoryId(this, this.createRepositoryId().toString());
        }
        return UUID.fromString(Repository.dnGetrepositoryId(this));
    }

    protected UUID createRepositoryId() {
        return UUID.randomUUID();
    }

    public long getRevision() {
        return Repository.dnGetrevision(this);
    }

    public void setRevision(long revision) {
        if (!Util.equal((long)Repository.dnGetrevision(this), (long)revision)) {
            Repository.dnSetrevision(this, revision);
        }
    }

    public byte[] getPublicKey() {
        return Repository.dnGetpublicKey(this);
    }

    public void setPublicKey(byte[] publicKey) {
        if (!Util.equal((byte[])Repository.dnGetpublicKey(this), (byte[])publicKey)) {
            Repository.dnSetpublicKey(this, publicKey);
        }
    }

    public void jdoPreStore() {
        this.getRepositoryId();
    }

    static {
        EnhancementHelper.registerClass((Class)Repository.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Repository"), null);
    }

    @Override
    public boolean dnIsDetached() {
        return false;
    }

    @Override
    public Persistable dnNewInstance(StateManager sm) {
        throw new JDOFatalInternalException("Cannot instantiate abstract class.");
    }

    @Override
    public Persistable dnNewInstance(StateManager sm, Object obj) {
        throw new JDOFatalInternalException("Cannot instantiate abstract class.");
    }

    @Override
    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.publicKey = (byte[])this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.repositoryId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.revision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    @Override
    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.publicKey);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.repositoryId);
                break;
            }
            case 2: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.revision);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(Repository obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.publicKey = obj.publicKey;
                break;
            }
            case 1: {
                this.repositoryId = obj.repositoryId;
                break;
            }
            case 2: {
                this.revision = obj.revision;
                break;
            }
            default: {
                super.dnCopyField(obj, index);
            }
        }
    }

    @Override
    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Repository)) {
            throw new IllegalArgumentException("object is not an object of type co.codewizards.cloudstore.local.persistence.Repository");
        }
        Repository other = (Repository)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"publicKey", "repositoryId", "revision"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 3 + Entity.dnGetManagedFieldCount();
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static byte[] dnGetpublicKey(Repository objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return (byte[])objPC.dnStateManager.getObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.publicKey);
        }
        return objPC.publicKey;
    }

    private static void dnSetpublicKey(Repository objPC, byte[] val) {
        if (objPC.dnStateManager == null) {
            objPC.publicKey = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.publicKey, (Object)val);
        }
    }

    private static String dnGetrepositoryId(Repository objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.repositoryId);
        }
        return objPC.repositoryId;
    }

    private static void dnSetrepositoryId(Repository objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.repositoryId, val);
        } else {
            objPC.repositoryId = val;
        }
    }

    private static long dnGetrevision(Repository objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.revision);
        }
        return objPC.revision;
    }

    private static void dnSetrevision(Repository objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.revision, val);
        } else {
            objPC.revision = val;
        }
    }
}

