/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.dto;

import co.codewizards.cloudstore.core.Uid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.subshare.core.dto.PlainHistoCryptoRepoFileDto;

public class PlainHistoCryptoRepoFileDtoTreeNode
implements Iterable<PlainHistoCryptoRepoFileDtoTreeNode> {
    private static final Comparator<PlainHistoCryptoRepoFileDtoTreeNode> nodeComparatorByNameOnly = new Comparator<PlainHistoCryptoRepoFileDtoTreeNode>(){

        @Override
        public int compare(PlainHistoCryptoRepoFileDtoTreeNode node0, PlainHistoCryptoRepoFileDtoTreeNode node1) {
            String name0 = node0.getPlainHistoCryptoRepoFileDto().getRepoFileDto().getName();
            String name1 = node1.getPlainHistoCryptoRepoFileDto().getRepoFileDto().getName();
            return name0.compareTo(name1);
        }
    };
    private PlainHistoCryptoRepoFileDtoTreeNode parent;
    private final PlainHistoCryptoRepoFileDto plainHistoCryptoRepoFileDto;
    private final SortedSet<PlainHistoCryptoRepoFileDtoTreeNode> children = new TreeSet<PlainHistoCryptoRepoFileDtoTreeNode>(nodeComparatorByNameOnly);
    private List<PlainHistoCryptoRepoFileDtoTreeNode> flattenedTreeList;

    public static PlainHistoCryptoRepoFileDtoTreeNode createTree(Collection<PlainHistoCryptoRepoFileDto> plainHistoCryptoRepoFileDtos) throws IllegalArgumentException {
        Objects.requireNonNull(plainHistoCryptoRepoFileDtos, "plainHistoCryptoRepoFileDtos");
        if (plainHistoCryptoRepoFileDtos.isEmpty()) {
            return null;
        }
        HashMap<Uid, PlainHistoCryptoRepoFileDtoTreeNode> id2RepoFileDtoTreeNode = new HashMap<Uid, PlainHistoCryptoRepoFileDtoTreeNode>();
        for (PlainHistoCryptoRepoFileDto plainHistoCryptoRepoFileDto : plainHistoCryptoRepoFileDtos) {
            id2RepoFileDtoTreeNode.put(plainHistoCryptoRepoFileDto.getCryptoRepoFileId(), new PlainHistoCryptoRepoFileDtoTreeNode(plainHistoCryptoRepoFileDto));
        }
        PlainHistoCryptoRepoFileDtoTreeNode rootNode = null;
        for (PlainHistoCryptoRepoFileDtoTreeNode node : id2RepoFileDtoTreeNode.values()) {
            Uid parentId = node.getPlainHistoCryptoRepoFileDto().getParentCryptoRepoFileId();
            if (parentId == null) {
                if (rootNode != null) {
                    throw new IllegalArgumentException("Multiple root nodes!");
                }
                rootNode = node;
                continue;
            }
            PlainHistoCryptoRepoFileDtoTreeNode parentNode = (PlainHistoCryptoRepoFileDtoTreeNode)id2RepoFileDtoTreeNode.get(parentId);
            if (parentNode == null) {
                throw new IllegalArgumentException("parentEntityID unknown: " + parentId);
            }
            parentNode.addChild(node);
        }
        if (rootNode == null) {
            throw new IllegalArgumentException("There is no root node!");
        }
        return rootNode;
    }

    protected PlainHistoCryptoRepoFileDtoTreeNode(PlainHistoCryptoRepoFileDto plainHistoCryptoRepoFileDto) {
        this.plainHistoCryptoRepoFileDto = Objects.requireNonNull(plainHistoCryptoRepoFileDto, "plainHistoCryptoRepoFileDto");
    }

    public PlainHistoCryptoRepoFileDto getPlainHistoCryptoRepoFileDto() {
        return this.plainHistoCryptoRepoFileDto;
    }

    public PlainHistoCryptoRepoFileDtoTreeNode getParent() {
        return this.parent;
    }

    protected void setParent(PlainHistoCryptoRepoFileDtoTreeNode parent) {
        this.parent = parent;
    }

    public Set<PlainHistoCryptoRepoFileDtoTreeNode> getChildren() {
        return Collections.unmodifiableSet(this.children);
    }

    protected void addChild(PlainHistoCryptoRepoFileDtoTreeNode child) {
        child.setParent(this);
        this.children.add(child);
    }

    public String getPath() {
        PlainHistoCryptoRepoFileDtoTreeNode parent = this.getParent();
        if (parent == null) {
            return this.getPlainHistoCryptoRepoFileDto().getRepoFileDto().getName();
        }
        return parent.getPath() + "/" + this.getPlainHistoCryptoRepoFileDto().getRepoFileDto().getName();
    }

    public List<PlainHistoCryptoRepoFileDtoTreeNode> getLeafs() {
        ArrayList<PlainHistoCryptoRepoFileDtoTreeNode> leafs = new ArrayList<PlainHistoCryptoRepoFileDtoTreeNode>();
        this.populateLeafs(this, leafs);
        return leafs;
    }

    private void populateLeafs(PlainHistoCryptoRepoFileDtoTreeNode node, List<PlainHistoCryptoRepoFileDtoTreeNode> leafs) {
        if (node.getChildren().isEmpty()) {
            leafs.add(node);
        }
        for (PlainHistoCryptoRepoFileDtoTreeNode child : node.getChildren()) {
            this.populateLeafs(child, leafs);
        }
    }

    @Override
    public Iterator<PlainHistoCryptoRepoFileDtoTreeNode> iterator() {
        return this.getFlattenedTreeList().iterator();
    }

    public int size() {
        return this.getFlattenedTreeList().size();
    }

    private List<PlainHistoCryptoRepoFileDtoTreeNode> getFlattenedTreeList() {
        if (this.flattenedTreeList == null) {
            ArrayList<PlainHistoCryptoRepoFileDtoTreeNode> list = new ArrayList<PlainHistoCryptoRepoFileDtoTreeNode>();
            this.flattenTree(list, this);
            this.flattenedTreeList = list;
        }
        return this.flattenedTreeList;
    }

    private void flattenTree(List<PlainHistoCryptoRepoFileDtoTreeNode> result, PlainHistoCryptoRepoFileDtoTreeNode node) {
        result.add(node);
        for (PlainHistoCryptoRepoFileDtoTreeNode child : node.getChildren()) {
            this.flattenTree(result, child);
        }
    }

    public PlainHistoCryptoRepoFileDtoTreeNode getRoot() {
        PlainHistoCryptoRepoFileDtoTreeNode parent = this.getParent();
        if (parent == null) {
            return this;
        }
        return parent.getRoot();
    }
}

