/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.user;

import java.util.ArrayList;
import java.util.Objects;
import org.subshare.core.dto.UserDto;
import org.subshare.core.dto.UserRepoKeyPublicKeyDto;
import org.subshare.core.dto.UserRepoKeyRingDto;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.user.User;
import org.subshare.core.user.UserImpl;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyPublicKeyDtoWithSignatureConverter;
import org.subshare.core.user.UserRepoKeyRing;
import org.subshare.core.user.UserRepoKeyRingDtoConverter;

public class UserDtoConverter {
    private final UserRepoKeyPublicKeyDtoWithSignatureConverter userRepoKeyPublicKeyDtoWithSignatureConverter = new UserRepoKeyPublicKeyDtoWithSignatureConverter();
    private final UserRepoKeyRingDtoConverter userRepoKeyRingDtoConverter = new UserRepoKeyRingDtoConverter();

    public UserDto toUserDto(User user) {
        Objects.requireNonNull(user, "user");
        UserDto userDto = new UserDto();
        userDto.setUserId(user.getUserId());
        userDto.setFirstName(user.getFirstName());
        userDto.setLastName(user.getLastName());
        userDto.setPgpKeyIds(new ArrayList<PgpKeyId>(user.getPgpKeyIds()));
        userDto.setEmails(new ArrayList<String>(user.getEmails()));
        UserRepoKeyRing userRepoKeyRing = user.getUserRepoKeyRing();
        if (userRepoKeyRing != null) {
            userDto.setUserRepoKeyRingDto(this.userRepoKeyRingDtoConverter.toUserRepoKeyRingDto(userRepoKeyRing));
        } else {
            for (UserRepoKey.PublicKeyWithSignature publicKey : user.getUserRepoKeyPublicKeys()) {
                userDto.getUserRepoKeyPublicKeyDtos().add(this.userRepoKeyPublicKeyDtoWithSignatureConverter.toUserRepoKeyPublicKeyDto(publicKey));
            }
        }
        userDto.setChanged(user.getChanged());
        return userDto;
    }

    public User fromUserDto(UserDto userDto) {
        Objects.requireNonNull(userDto, "userDto");
        UserImpl user = new UserImpl();
        user.setUserId(userDto.getUserId());
        user.setFirstName(userDto.getFirstName());
        user.setLastName(userDto.getLastName());
        user.getPgpKeyIds().addAll(userDto.getPgpKeyIds());
        user.getEmails().addAll(userDto.getEmails());
        UserRepoKeyRingDto userRepoKeyRingDto = userDto.getUserRepoKeyRingDto();
        if (userRepoKeyRingDto != null) {
            user.setUserRepoKeyRing(this.userRepoKeyRingDtoConverter.fromUserRepoKeyRingDto(userRepoKeyRingDto));
        } else {
            for (UserRepoKeyPublicKeyDto userRepoKeyPublicKeyDto : userDto.getUserRepoKeyPublicKeyDtos()) {
                user.getUserRepoKeyPublicKeys().add(this.userRepoKeyPublicKeyDtoWithSignatureConverter.fromUserRepoKeyPublicKeyDto(userRepoKeyPublicKeyDto));
            }
        }
        user.setChanged(userDto.getChanged());
        return user;
    }
}

