/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.imp.fromserver;

import co.codewizards.cloudstore.core.io.IByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.ls.client.util.ByteArrayInputStreamLs;
import co.codewizards.cloudstore.ls.client.util.ByteArrayOutputStreamLs;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.subshare.core.pgp.CertifyPgpKeyParam;
import org.subshare.core.pgp.ImportKeysResult;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.TempImportKeysResult;
import org.subshare.core.user.ImportUsersFromPgpKeysResult;
import org.subshare.core.user.UserRegistry;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.ls.UserRegistryLs;
import org.subshare.gui.pgp.certify.CertifyPgpKeyData;
import org.subshare.gui.pgp.imp.fromserver.ImportPgpKeyFromServerData;
import org.subshare.gui.pgp.imp.fromserver.Messages;
import org.subshare.gui.pgp.imp.fromserver.SearchCriteriaWizardPage;
import org.subshare.gui.wizard.Wizard;

public class ImportPgpKeyFromServerWizard
extends Wizard {
    private final ImportPgpKeyFromServerData importPgpKeyFromServerData = new ImportPgpKeyFromServerData();
    private volatile Set<PgpKeyId> selectedPgpKeyIds;
    private volatile TempImportKeysResult tempImportKeysResult;
    private volatile ImportKeysResult importKeysResult;
    private volatile ImportUsersFromPgpKeysResult importUsersFromPgpKeysResult;

    public ImportPgpKeyFromServerWizard() {
        this.setFirstPage(new SearchCriteriaWizardPage(this.importPgpKeyFromServerData));
    }

    public ImportPgpKeyFromServerData getImportPgpKeyFromServerData() {
        return this.importPgpKeyFromServerData;
    }

    @Override
    protected void finishing() {
        super.finishing();
        this.tempImportKeysResult = this.importPgpKeyFromServerData.getTempImportKeysResult();
        Objects.requireNonNull(this.tempImportKeysResult, "tempImportKeysResult");
        this.selectedPgpKeyIds = new HashSet<PgpKeyId>((Collection<PgpKeyId>)this.importPgpKeyFromServerData.getSelectedPgpKeyIds());
        this.importKeysResult = null;
    }

    @Override
    protected void finish(ProgressMonitor monitor) throws Exception {
        Pgp pgp = PgpLs.getPgpOrFail();
        UserRegistry userRegistry = UserRegistryLs.getUserRegistry();
        Pgp tempPgp = this.tempImportKeysResult.getTempPgp();
        HashSet<PgpKey> tempPgpKeys = new HashSet<PgpKey>(this.selectedPgpKeyIds.size());
        for (PgpKeyId pgpKeyId : this.selectedPgpKeyIds) {
            tempPgpKeys.add(Objects.requireNonNull(tempPgp.getPgpKey(pgpKeyId), "tempPgp.getPgpKey(" + pgpKeyId + ")"));
            CertifyPgpKeyData certifyPgpKeyData = (CertifyPgpKeyData)this.importPgpKeyFromServerData.getPgpKeyId2CertifyPgpKeyData().get((Object)pgpKeyId);
            if (certifyPgpKeyData.getPgp() == null || certifyPgpKeyData.getPgpKey() == null || certifyPgpKeyData.isSkip()) continue;
            CertifyPgpKeyParam certifyPgpKeyParam = new CertifyPgpKeyParam();
            certifyPgpKeyParam.setPgpKey(certifyPgpKeyData.getPgpKey());
            certifyPgpKeyParam.setCertificationLevel(certifyPgpKeyData.getCertificationLevel());
            certifyPgpKeyParam.setSignPgpKey(certifyPgpKeyData.getSignPgpKey());
            tempPgp.certify(certifyPgpKeyParam);
        }
        IByteArrayOutputStream bout = ByteArrayOutputStreamLs.create();
        tempPgp.exportPublicKeys(tempPgpKeys, (IOutputStream)bout);
        this.importKeysResult = pgp.importKeys((IInputStream)ByteArrayInputStreamLs.create((IByteArrayOutputStream)bout));
        Objects.requireNonNull(this.importKeysResult, "importKeysResult");
        pgp.updateTrustDb();
        HashMap<PgpKeyId, PgpKey> pgpKeyId2PgpKey = new HashMap<PgpKeyId, PgpKey>();
        for (ImportKeysResult.ImportedMasterKey importedMasterKey : this.importKeysResult.getPgpKeyId2ImportedMasterKey().values()) {
            PgpKeyId pgpKeyId = importedMasterKey.getPgpKeyId();
            PgpKey pgpKey = pgp.getPgpKey(pgpKeyId);
            Objects.requireNonNull(pgpKey, "pgp.getPgpKey(" + pgpKeyId + ")");
            pgpKeyId2PgpKey.put(pgpKeyId, pgpKey);
        }
        this.importUsersFromPgpKeysResult = userRegistry.importUsersFromPgpKeys(pgpKeyId2PgpKey.values());
    }

    @Override
    protected void preFinished() {
        super.preFinished();
        this.importPgpKeyFromServerData.setImportKeysResult(Objects.requireNonNull(this.importKeysResult, "importKeysResult"));
        this.importPgpKeyFromServerData.setImportUsersResult(Objects.requireNonNull(this.importUsersFromPgpKeysResult, "importUsersFromPgpKeysResult"));
    }

    @Override
    public String getTitle() {
        return Messages.getString("ImportPgpKeyFromServerWizard.title");
    }
}

