/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.resolvecollision.collision;

import co.codewizards.cloudstore.core.util.DateUtil;
import java.util.Objects;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import org.subshare.core.dto.CollisionPrivateDto;
import org.subshare.gui.resolvecollision.CollisionDtoWithPlainHistoCryptoRepoFileDto;
import org.subshare.gui.resolvecollision.collision.CollisionData;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.wizard.WizardPageContentGridPane;

public class CollisionPane
extends WizardPageContentGridPane {
    private final CollisionData collisionData;
    @FXML
    private CheckBox resolvedCheckBox;
    @FXML
    private TextArea commentTextArea;

    public CollisionPane(CollisionData collisionData) {
        FxmlUtil.loadDynamicComponentFxml(CollisionPane.class, this);
        this.collisionData = Objects.requireNonNull(collisionData, "collisionData");
        CollisionDtoWithPlainHistoCryptoRepoFileDto collisionDtoWithPlainHistoCryptoRepoFileDto = collisionData.getCollisionDtoWithPlainHistoCryptoRepoFileDto();
        CollisionPrivateDto collisionPrivateDto = collisionDtoWithPlainHistoCryptoRepoFileDto.getCollisionPrivateDto();
        this.resolvedCheckBox.setSelected(collisionPrivateDto.getResolved() != null);
        this.resolvedCheckBox.selectedProperty().addListener(observable -> this.updateResolved());
        this.commentTextArea.setText(collisionPrivateDto.getComment());
        this.commentTextArea.textProperty().addListener(observable -> this.updateComment());
    }

    private void updateResolved() {
        CollisionDtoWithPlainHistoCryptoRepoFileDto collisionDtoWithPlainHistoCryptoRepoFileDto = this.collisionData.getCollisionDtoWithPlainHistoCryptoRepoFileDto();
        CollisionPrivateDto collisionPrivateDto = collisionDtoWithPlainHistoCryptoRepoFileDto.getCollisionPrivateDto();
        boolean newResolved = this.resolvedCheckBox.selectedProperty().get();
        if (newResolved) {
            collisionPrivateDto.setResolved(DateUtil.now());
        } else {
            collisionPrivateDto.setResolved(null);
        }
    }

    private void updateComment() {
        CollisionDtoWithPlainHistoCryptoRepoFileDto collisionDtoWithPlainHistoCryptoRepoFileDto = this.collisionData.getCollisionDtoWithPlainHistoCryptoRepoFileDto();
        CollisionPrivateDto collisionPrivateDto = collisionDtoWithPlainHistoCryptoRepoFileDto.getCollisionPrivateDto();
        String newComment = this.commentTextArea.getText();
        collisionPrivateDto.setComment(newComment);
    }

    public void requestFocus() {
        super.requestFocus();
        this.resolvedCheckBox.requestFocus();
    }

    @Override
    protected boolean isComplete() {
        return true;
    }
}

