/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.user;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import org.subshare.core.user.User;
import org.subshare.gui.user.EditUserEvent;
import org.subshare.gui.user.EditUserListener;

public class EditUserManager {
    private final ObservableSet<User> editedUsers = FXCollections.observableSet(new LinkedHashSet());
    private final ObservableSet<User> unmodifiableEditedUsers = FXCollections.unmodifiableObservableSet(this.editedUsers);
    private final List<EditUserListener> editUserListeners = new CopyOnWriteArrayList<EditUserListener>();

    public ObservableSet<User> getEditedUsers() {
        return this.unmodifiableEditedUsers;
    }

    public void edit(Collection<? extends User> users) {
        Objects.requireNonNull(users, "users");
        this.editedUsers.addAll(users);
        EditUserEvent event = new EditUserEvent(this, users);
        for (EditUserListener listener : this.editUserListeners) {
            listener.onEdit(event);
        }
    }

    public void endEditing(Collection<? extends User> users) {
        Objects.requireNonNull(users, "users");
        this.editedUsers.removeAll(users);
    }

    public void addEditUserListener(EditUserListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.editUserListeners.add(listener);
    }

    public void removeEditUserListener(EditUserListener listener) {
        this.editUserListeners.remove(listener);
    }
}

