/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.dto;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.dto.CollisionDto;
import org.subshare.local.persistence.Collision;
import org.subshare.local.persistence.CollisionDao;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoKeyDao;
import org.subshare.local.persistence.HistoCryptoRepoFile;
import org.subshare.local.persistence.HistoCryptoRepoFileDao;

public class CollisionDtoConverter {
    private static final Logger logger = LoggerFactory.getLogger(CollisionDtoConverter.class);
    private final LocalRepoTransaction transaction;

    public static CollisionDtoConverter create(LocalRepoTransaction transaction) {
        return (CollisionDtoConverter)ObjectFactoryUtil.createObject(CollisionDtoConverter.class, (Object[])new Object[]{transaction});
    }

    protected CollisionDtoConverter(LocalRepoTransaction transaction) {
        this.transaction = Objects.requireNonNull(transaction, "transaction");
    }

    public CollisionDto toCollisionDto(Collision collision) {
        Objects.requireNonNull(collision, "collision");
        CollisionDto result = new CollisionDto();
        result.setCollisionId(collision.getCollisionId());
        result.setHistoCryptoRepoFileId1(collision.getHistoCryptoRepoFile1().getHistoCryptoRepoFileId());
        result.setHistoCryptoRepoFileId2(collision.getHistoCryptoRepoFile2() == null ? null : collision.getHistoCryptoRepoFile2().getHistoCryptoRepoFileId());
        result.setDuplicateCryptoRepoFileId(collision.getDuplicateCryptoRepoFileId());
        result.setCryptoKeyId(Objects.requireNonNull(collision.getCryptoKey(), "collision.cryptoKey").getCryptoKeyId());
        result.setCollisionPrivateDtoData(collision.getCollisionPrivateDtoData());
        result.setSignature(collision.getSignature());
        return result;
    }

    public Collision putCollisionDto(CollisionDto collisionDto) {
        Objects.requireNonNull(collisionDto, "collisionDto");
        CollisionDao cDao = (CollisionDao)((Object)this.transaction.getDao(CollisionDao.class));
        HistoCryptoRepoFileDao hcrfDao = (HistoCryptoRepoFileDao)((Object)this.transaction.getDao(HistoCryptoRepoFileDao.class));
        HistoCryptoRepoFile histoCryptoRepoFile1 = hcrfDao.getHistoCryptoRepoFileOrFail(collisionDto.getHistoCryptoRepoFileId1());
        Uid duplicateCryptoRepoFileId = collisionDto.getDuplicateCryptoRepoFileId();
        CryptoKeyDao cryptoKeyDao = (CryptoKeyDao)((Object)this.transaction.getDao(CryptoKeyDao.class));
        Collision result = cDao.getCollision(collisionDto.getCollisionId());
        if (result == null) {
            result = new Collision(collisionDto.getCollisionId());
        }
        result.setHistoCryptoRepoFile1(histoCryptoRepoFile1);
        result.setHistoCryptoRepoFile2(collisionDto.getHistoCryptoRepoFileId2() == null ? null : hcrfDao.getHistoCryptoRepoFileOrFail(collisionDto.getHistoCryptoRepoFileId2()));
        result.setDuplicateCryptoRepoFileId(duplicateCryptoRepoFileId);
        CryptoKey cryptoKey = cryptoKeyDao.getCryptoKeyOrFail(collisionDto.getCryptoKeyId());
        result.setCryptoKey(cryptoKey);
        result.setCollisionPrivateDtoData(collisionDto.getCollisionPrivateDtoData());
        result.setSignature(collisionDto.getSignature());
        result = (Collision)cDao.makePersistent(result);
        return result;
    }
}

