/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.db.IgnoreDatabaseMigraterComparison;
import co.codewizards.cloudstore.local.persistence.NormalFile;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Objects;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.Discriminator;
import javax.jdo.annotations.DiscriminatorStrategy;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.PersistenceCapable;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signature;
import org.subshare.local.persistence.CryptoRepoFileDao;
import org.subshare.local.persistence.SignatureImpl;
import org.subshare.local.persistence.SsRepoFile;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.SUPERCLASS_TABLE)
@Discriminator(strategy=DiscriminatorStrategy.VALUE_MAP, value="SsNormalFile")
public class SsNormalFile
extends NormalFile
implements SsRepoFile,
Persistable {
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private long lengthWithPadding = -1L;
    private static final String[] dnFieldNames = SsNormalFile.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = SsNormalFile.__dnGetInheritedFieldCount();

    public String getSignedDataType() {
        return "NormalFile";
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[9];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((String)this.getName());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource(this.getParent() == null ? null : this.getParent().getName());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource((long)this.getLength());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[5] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[6] = InputStreamSource.Helper.createInputStreamSource((long)this.getLengthWithPadding());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[7] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[8] = InputStreamSource.Helper.createInputStreamSource((Date)this.getLastModified());
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public long getLengthWithPadding() {
        return SsNormalFile.dnGetlengthWithPadding(this);
    }

    public void setLengthWithPadding(long lengthWithPadding) {
        SsNormalFile.dnSetlengthWithPadding(this, lengthWithPadding);
    }

    public Signature getSignature() {
        return SsNormalFile.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)this.getSignature(), (Object)signature)) {
            SsNormalFile.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    @IgnoreDatabaseMigraterComparison
    public Uid getCryptoRepoFileIdControllingPermissions() {
        PersistenceManager pm = Objects.requireNonNull(JDOHelper.getPersistenceManager((Object)this), "JDOHelper.getPersistenceManager(this)");
        return ((CryptoRepoFileDao)new CryptoRepoFileDao().persistenceManager(pm)).getCryptoRepoFileOrFail((RepoFile)this).getCryptoRepoFileId();
    }

    @IgnoreDatabaseMigraterComparison
    public PermissionType getPermissionTypeRequiredForWrite() {
        return PermissionType.write;
    }

    static {
        EnhancementHelper.registerClass((Class)SsNormalFile.___dn$loadClass("org.subshare.local.persistence.SsNormalFile"), (Persistable)new SsNormalFile());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        SsNormalFile result = new SsNormalFile();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        SsNormalFile result = new SsNormalFile();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.lengthWithPadding = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 1: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.lengthWithPadding);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(SsNormalFile obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.lengthWithPadding = obj.lengthWithPadding;
                break;
            }
            case 1: {
                this.signature = obj.signature;
                break;
            }
            default: {
                super.dnCopyField((NormalFile)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof SsNormalFile)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.SsNormalFile");
        }
        SsNormalFile other = (SsNormalFile)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"lengthWithPadding", "signature"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return NormalFile.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 2 + NormalFile.dnGetManagedFieldCount();
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static long dnGetlengthWithPadding(SsNormalFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.lengthWithPadding);
        }
        return objPC.lengthWithPadding;
    }

    private static void dnSetlengthWithPadding(SsNormalFile objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.lengthWithPadding, val);
        } else {
            objPC.lengthWithPadding = val;
        }
    }

    private static SignatureImpl dnGetsignature(SsNormalFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(SsNormalFile objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }
}

