/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.histo;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.subshare.core.dto.HistoFrameDto;
import org.subshare.core.repo.LocalRepo;
import org.subshare.core.repo.listener.LocalRepoCommitEventListener;
import org.subshare.core.repo.listener.LocalRepoCommitEventManager;
import org.subshare.core.repo.listener.WeakLocalRepoCommitEventListener;
import org.subshare.core.repo.local.HistoFrameFilter;
import org.subshare.core.repo.local.SsLocalRepoMetaData;
import org.subshare.core.user.User;
import org.subshare.gui.concurrent.SsTask;
import org.subshare.gui.histo.HistoFrameListItem;
import org.subshare.gui.ls.LocalRepoCommitEventManagerLs;
import org.subshare.gui.ls.LocalRepoManagerFactoryLs;
import org.subshare.gui.ls.UserRegistryLs;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.util.PlatformUtil;

public class HistoFrameListPane
extends VBox {
    private LocalRepo localRepo;
    private boolean populatePending;
    @FXML
    private TableView<HistoFrameListItem> tableView;
    @FXML
    private TableColumn<HistoFrameListItem, Date> signatureCreatedColumn;
    @FXML
    private TableColumn<HistoFrameListItem, String> signingUserNameColumn;
    private final Map<Uid, String> userRepoKey2UserName = Collections.synchronizedMap(new HashMap());
    private HistoFrameFilter filter = new HistoFrameFilter();
    private final LocalRepoCommitEventListener localRepoCommitEventListener;
    private WeakLocalRepoCommitEventListener weakLocalRepoCommitEventListener;
    private static final Timer deferredUpdateUiTimer = new Timer(true);
    private TimerTask deferredUpdateUiTimerTask;
    private final Callback<TableColumn<HistoFrameListItem, Date>, TableCell<HistoFrameListItem, Date>> signatureCreateColumnCellFactory;

    public HistoFrameListPane() {
        this.filter.setMaxResultSize(-1);
        this.signatureCreateColumnCellFactory = new Callback<TableColumn<HistoFrameListItem, Date>, TableCell<HistoFrameListItem, Date>>(){
            private final DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);

            public TableCell<HistoFrameListItem, Date> call(TableColumn<HistoFrameListItem, Date> tableColumn) {
                return new TableCell<HistoFrameListItem, Date>(){

                    protected void updateItem(Date value, boolean empty) {
                        super.updateItem((Object)value, empty);
                        if (value == null || empty) {
                            this.setText(null);
                        } else {
                            this.setText(dateFormat.format(value));
                        }
                    }
                };
            }
        };
        FxmlUtil.loadDynamicComponentFxml(HistoFrameListPane.class, this);
        this.signatureCreatedColumn.setCellFactory(this.signatureCreateColumnCellFactory);
        this.localRepoCommitEventListener = event -> {
            if (!event.getModifications().isEmpty()) {
                this.scheduleDeferredUpdateUiTimerTask();
            }
        };
    }

    public ReadOnlyObjectProperty<HistoFrameListItem> selectedItemProperty() {
        return this.tableView.getSelectionModel().selectedItemProperty();
    }

    public LocalRepo getLocalRepo() {
        return this.localRepo;
    }

    public void setLocalRepo(LocalRepo localRepo) {
        PlatformUtil.assertFxApplicationThread();
        if (Util.equal((Object)this.localRepo, (Object)localRepo)) {
            return;
        }
        if (this.weakLocalRepoCommitEventListener != null) {
            this.weakLocalRepoCommitEventListener.removeLocalRepoCommitEventListener();
            this.weakLocalRepoCommitEventListener = null;
        }
        this.localRepo = localRepo;
        this.tableView.getItems().clear();
        if (localRepo != null) {
            UUID localRepositoryId = localRepo.getRepositoryId();
            LocalRepoCommitEventManager localRepoCommitEventManager = LocalRepoCommitEventManagerLs.getLocalRepoCommitEventManager();
            this.weakLocalRepoCommitEventListener = new WeakLocalRepoCommitEventListener(localRepoCommitEventManager, localRepositoryId, this.localRepoCommitEventListener);
            this.weakLocalRepoCommitEventListener.addLocalRepoCommitEventListener();
        }
        this.populatePending = true;
        Platform.runLater(() -> this.postSetLocalRepoOrLocalPath());
    }

    public String getLocalPath() {
        return this.filter.getLocalPath();
    }

    public void setLocalPath(String localPath) {
        PlatformUtil.assertFxApplicationThread();
        this.filter.setLocalPath(localPath);
        this.tableView.getItems().clear();
        this.populatePending = true;
        Platform.runLater(() -> this.postSetLocalRepoOrLocalPath());
    }

    private void postSetLocalRepoOrLocalPath() {
        PlatformUtil.assertFxApplicationThread();
        if (this.populatePending) {
            this.populatePending = false;
            this.populateTableViewAsync();
        }
    }

    private synchronized void scheduleDeferredUpdateUiTimerTask() {
        if (this.deferredUpdateUiTimerTask != null) {
            this.deferredUpdateUiTimerTask.cancel();
            this.deferredUpdateUiTimerTask = null;
        }
        this.deferredUpdateUiTimerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HistoFrameListPane histoFrameListPane = HistoFrameListPane.this;
                synchronized (histoFrameListPane) {
                    HistoFrameListPane.this.deferredUpdateUiTimerTask = null;
                }
                Platform.runLater(() -> HistoFrameListPane.this.updateUi());
            }
        };
        deferredUpdateUiTimer.schedule(this.deferredUpdateUiTimerTask, 500L);
    }

    private void updateUi() {
        new Service<List<HistoFrameDto>>(){

            protected Task<List<HistoFrameDto>> createTask() {
                return new SsTask<List<HistoFrameDto>>(){

                    protected List<HistoFrameDto> call() throws Exception {
                        try (LocalRepoManager localRepoManager = HistoFrameListPane.this.createLocalRepoManager();){
                            SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
                            ArrayList histoFrameDtos = new ArrayList(localRepoMetaData.getHistoFrameDtos(HistoFrameListPane.this.filter));
                            HistoFrameListPane.this.sortHistoFrameDtosBySignatureCreatedNewestFirst(histoFrameDtos);
                            for (HistoFrameDto histoFrameDto : histoFrameDtos) {
                                HistoFrameListPane.this.getUserNameByUserRepoKeyId(histoFrameDto.getSignature().getSigningUserRepoKeyId());
                            }
                            ArrayList arrayList = histoFrameDtos;
                            return arrayList;
                        }
                    }

                    protected void succeeded() {
                        List histoFrameDtos;
                        try {
                            histoFrameDtos = (List)this.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        ArrayList oldSelectedItems = new ArrayList(HistoFrameListPane.this.tableView.getSelectionModel().getSelectedItems());
                        HistoFrameListPane.this.tableView.getItems().clear();
                        Map histoFrameId2Item = HistoFrameListPane.this.addTableItemsViewCallback(histoFrameDtos);
                        for (HistoFrameListItem oldItem : oldSelectedItems) {
                            HistoFrameListItem newItem = (HistoFrameListItem)histoFrameId2Item.get(oldItem.getHistoFrameDto().getHistoFrameId());
                            if (newItem == null) continue;
                            HistoFrameListPane.this.tableView.getSelectionModel().select((Object)newItem);
                        }
                    }
                };
            }
        }.start();
    }

    private String getUserNameByUserRepoKeyId(Uid userRepoKeyId) {
        Objects.requireNonNull(userRepoKeyId, "userRepoKeyId");
        String userName = this.userRepoKey2UserName.get(userRepoKeyId);
        if (userName == null) {
            User user = UserRegistryLs.getUserRegistry().getUserByUserRepoKeyId(userRepoKeyId);
            userName = user == null ? String.format("<%s>", userRepoKeyId) : this.getUserName(user);
            this.userRepoKey2UserName.put(userRepoKeyId, userName);
        }
        return userName;
    }

    private String getUserName(User user) {
        String email;
        List emails;
        String lastName;
        Objects.requireNonNull(user, "user");
        StringBuilder sb = new StringBuilder();
        String firstName = StringUtil.trim((String)user.getFirstName());
        if (!StringUtil.isEmpty((String)firstName)) {
            sb.append(firstName);
        }
        if (!StringUtil.isEmpty((String)(lastName = StringUtil.trim((String)user.getLastName())))) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(lastName);
        }
        if (!(emails = user.getEmails()).isEmpty() && !StringUtil.isEmpty((String)(email = StringUtil.trim((String)((String)emails.get(0)))))) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append('<').append(email).append('>');
        }
        return sb.toString();
    }

    private void populateTableViewAsync() {
        if (this.localRepo == null) {
            return;
        }
        new Service<List<HistoFrameDto>>(){

            protected Task<List<HistoFrameDto>> createTask() {
                return new SsTask<List<HistoFrameDto>>(){

                    protected List<HistoFrameDto> call() throws Exception {
                        if (HistoFrameListPane.this.localRepo == null) {
                            return Collections.emptyList();
                        }
                        try (LocalRepoManager localRepoManager = HistoFrameListPane.this.createLocalRepoManager();){
                            SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
                            ArrayList histoFrameDtos = new ArrayList(localRepoMetaData.getHistoFrameDtos(HistoFrameListPane.this.filter));
                            HistoFrameListPane.this.sortHistoFrameDtosBySignatureCreatedNewestFirst(histoFrameDtos);
                            for (HistoFrameDto histoFrameDto : histoFrameDtos) {
                                HistoFrameListPane.this.getUserNameByUserRepoKeyId(histoFrameDto.getSignature().getSigningUserRepoKeyId());
                            }
                            ArrayList arrayList = histoFrameDtos;
                            return arrayList;
                        }
                    }

                    protected void succeeded() {
                        List histoFrameDtos;
                        try {
                            histoFrameDtos = (List)this.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        HistoFrameListPane.this.addTableItemsViewCallback(histoFrameDtos);
                    }
                };
            }
        }.start();
    }

    private void sortHistoFrameDtosBySignatureCreatedNewestFirst(List<HistoFrameDto> histoFrameDtos) {
        Collections.sort(histoFrameDtos, (o1, o2) -> {
            Date signatureCreated1 = Objects.requireNonNull(o1.getSignature(), "o1.signature").getSignatureCreated();
            Objects.requireNonNull(signatureCreated1, "o1.signature.signatureCreated");
            Date signatureCreated2 = Objects.requireNonNull(o2.getSignature(), "o2.signature").getSignatureCreated();
            Objects.requireNonNull(signatureCreated2, "o2.signature.signatureCreated");
            return -1 * signatureCreated1.compareTo(signatureCreated2);
        });
    }

    private Map<Uid, HistoFrameListItem> addTableItemsViewCallback(List<HistoFrameDto> histoFrameDtos) {
        HashMap<Uid, HistoFrameListItem> histoFrameId2Item = new HashMap<Uid, HistoFrameListItem>();
        for (HistoFrameDto histoFrameDto : histoFrameDtos) {
            String userName = this.getUserNameByUserRepoKeyId(histoFrameDto.getSignature().getSigningUserRepoKeyId());
            HistoFrameListItem userListItem = new HistoFrameListItem(histoFrameDto, userName);
            histoFrameId2Item.put(userListItem.getHistoFrameDto().getHistoFrameId(), userListItem);
            this.tableView.getItems().add((Object)userListItem);
        }
        this.tableView.requestLayout();
        return histoFrameId2Item;
    }

    private LocalRepoManager createLocalRepoManager() {
        LocalRepo localRepo = Objects.requireNonNull(this.getLocalRepo(), "localRepo");
        return LocalRepoManagerFactoryLs.getLocalRepoManagerFactory().createLocalRepoManagerForExistingRepository(localRepo.getLocalRoot());
    }
}

