/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.histo;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.dto.DirectoryDto;
import co.codewizards.cloudstore.core.dto.NormalFileDto;
import co.codewizards.cloudstore.core.dto.SymlinkDto;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.CollectionUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import org.subshare.core.dto.PlainHistoCryptoRepoFileDto;
import org.subshare.core.repo.LocalRepo;
import org.subshare.core.repo.local.PlainHistoCryptoRepoFileFilter;
import org.subshare.core.repo.local.SsLocalRepoMetaData;
import org.subshare.gui.IconSize;
import org.subshare.gui.concurrent.SsTask;
import org.subshare.gui.filetree.FileIconRegistry;
import org.subshare.gui.histo.HistoCryptoRepoFileTreeItem;
import org.subshare.gui.ls.LocalRepoManagerFactoryLs;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.util.PlatformUtil;

public class HistoFramePane
extends BorderPane {
    private LocalRepo localRepo;
    private String localPath;
    private boolean populatePending;
    private Image collisionUnresolvedIcon;
    private Image collisionResolvedIcon;
    private final ObjectProperty<Uid> histoFrameId = new SimpleObjectProperty<Uid>((Object)this, "histoFrameId"){

        public void set(Uid newValue) {
            super.set((Object)newValue);
            HistoFramePane.this.populateTreeTableViewAsync();
        }
    };
    @FXML
    private TreeTableView<HistoCryptoRepoFileTreeItem> treeTableView;
    @FXML
    private TreeTableColumn<HistoCryptoRepoFileTreeItem, String> nameTreeTableColumn;
    private PlainHistoCryptoRepoFileFilter filter;
    private final Map<PlainHistoCryptoRepoFileDto.Action, Image> action2ActionIcon = new HashMap<PlainHistoCryptoRepoFileDto.Action, Image>();
    private final Callback<TreeTableColumn<HistoCryptoRepoFileTreeItem, String>, TreeTableCell<HistoCryptoRepoFileTreeItem, String>> nameColumnCellFactory;

    public LocalRepo getLocalRepo() {
        return this.localRepo;
    }

    public void setLocalRepo(LocalRepo localRepo) {
        PlatformUtil.assertFxApplicationThread();
        if (Util.equal((Object)this.localRepo, (Object)localRepo)) {
            return;
        }
        this.localRepo = localRepo;
        this.populatePending = true;
        Platform.runLater(() -> this.postSetLocalRepoOrLocalPath());
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        PlatformUtil.assertFxApplicationThread();
        if (Util.equal((Object)this.localPath, (Object)localPath)) {
            return;
        }
        this.localPath = localPath;
        this.populatePending = true;
        Platform.runLater(() -> this.postSetLocalRepoOrLocalPath());
    }

    private void postSetLocalRepoOrLocalPath() {
        PlatformUtil.assertFxApplicationThread();
        if (this.populatePending) {
            this.populatePending = false;
            this.populateTreeTableViewAsync();
        }
    }

    public HistoFramePane() {
        for (PlainHistoCryptoRepoFileDto.Action action : PlainHistoCryptoRepoFileDto.Action.values()) {
            String imageName = "Action_" + action.name() + IconSize._16x16.name() + ".png";
            URL url = HistoFramePane.class.getResource(imageName);
            if (url == null) {
                throw new IllegalStateException("Resource not found: " + imageName);
            }
            Image image = new Image(url.toString());
            this.action2ActionIcon.put(action, image);
        }
        this.nameColumnCellFactory = new Callback<TreeTableColumn<HistoCryptoRepoFileTreeItem, String>, TreeTableCell<HistoCryptoRepoFileTreeItem, String>>(){

            public TreeTableCell<HistoCryptoRepoFileTreeItem, String> call(TreeTableColumn<HistoCryptoRepoFileTreeItem, String> param) {
                return new TreeTableCell<HistoCryptoRepoFileTreeItem, String>(){

                    protected void updateItem(String value, boolean empty) {
                        super.updateItem((Object)value, empty);
                        HistoCryptoRepoFileTreeItem treeItem = (HistoCryptoRepoFileTreeItem)((Object)this.getTreeTableRow().getItem());
                        if (value == null || treeItem == null || empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(value);
                            List icons = CollectionUtil.asListWithoutNullElements((Object[])new Image[]{HistoFramePane.this.getFileIcon(treeItem), (Image)HistoFramePane.this.action2ActionIcon.get(treeItem.getPlainHistoCryptoRepoFileDto().getAction()), HistoFramePane.this.getCollisionIcon(treeItem)});
                            if (icons.isEmpty()) {
                                this.setGraphic(null);
                            } else if (icons.size() == 1) {
                                this.setGraphic((Node)new ImageView((Image)icons.get(0)));
                            } else {
                                HBox box = new HBox();
                                for (Image icon : icons) {
                                    box.getChildren().add((Object)new ImageView(icon));
                                }
                                this.setGraphic((Node)box);
                            }
                        }
                    }
                };
            }
        };
        FxmlUtil.loadDynamicComponentFxml(HistoFramePane.class, this);
        this.nameTreeTableColumn.setCellFactory(this.nameColumnCellFactory);
        this.treeTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    public ObservableList<TreeItem<HistoCryptoRepoFileTreeItem>> getSelectedHistoCryptoRepoFileTreeItems() {
        return this.treeTableView.getSelectionModel().getSelectedItems();
    }

    public ObjectProperty<Uid> histoFrameIdProperty() {
        return this.histoFrameId;
    }

    public Uid getHistoFrameId() {
        return (Uid)this.histoFrameId.get();
    }

    public void setHistoFrameId(Uid histoFrameId) {
        this.histoFrameId.set((Object)histoFrameId);
    }

    private void populateTreeTableViewAsync() {
        LocalRepo localRepo = this.getLocalRepo();
        Uid histoFrameId = this.getHistoFrameId();
        this.treeTableView.setRoot(null);
        if (localRepo == null || histoFrameId == null) {
            return;
        }
        this.filter = new PlainHistoCryptoRepoFileFilter();
        this.filter.setFillParents(true);
        this.filter.setHistoFrameId(histoFrameId);
        this.filter.setLocalPath(this.localPath);
        new Service<HistoCryptoRepoFileTreeItem>(){
            private final PlainHistoCryptoRepoFileFilter filter;
            {
                this.filter = HistoFramePane.this.filter;
            }

            protected Task<HistoCryptoRepoFileTreeItem> createTask() {
                return new SsTask<HistoCryptoRepoFileTreeItem>(){

                    protected HistoCryptoRepoFileTreeItem call() throws Exception {
                        try (LocalRepoManager localRepoManager = HistoFramePane.this.createLocalRepoManager();){
                            SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
                            Collection plainHistoCryptoRepoFileDtos = localRepoMetaData.getPlainHistoCryptoRepoFileDtos(filter);
                            HistoCryptoRepoFileTreeItem.Root root = HistoFramePane.this.buildTree(plainHistoCryptoRepoFileDtos);
                            return root;
                        }
                    }

                    protected void succeeded() {
                        HistoCryptoRepoFileTreeItem rootTreeItem;
                        if (filter != HistoFramePane.this.filter) {
                            return;
                        }
                        try {
                            rootTreeItem = (HistoCryptoRepoFileTreeItem)((Object)this.get());
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        HistoFramePane.this.treeTableView.setRoot((TreeItem)rootTreeItem);
                    }
                };
            }
        }.start();
    }

    private HistoCryptoRepoFileTreeItem.Root buildTree(Collection<PlainHistoCryptoRepoFileDto> plainHistoCryptoRepoFileDtos) {
        Objects.requireNonNull(plainHistoCryptoRepoFileDtos, "plainHistoCryptoRepoFileDtos");
        HistoCryptoRepoFileTreeItem.Root root = new HistoCryptoRepoFileTreeItem.Root();
        HashMap<Uid, HistoCryptoRepoFileTreeItem> cryptoRepoFileId2HistoCryptoRepoFileTreeItem = new HashMap<Uid, HistoCryptoRepoFileTreeItem>(plainHistoCryptoRepoFileDtos.size());
        for (PlainHistoCryptoRepoFileDto plainHistoCryptoRepoFileDto : plainHistoCryptoRepoFileDtos) {
            HistoCryptoRepoFileTreeItem item = new HistoCryptoRepoFileTreeItem(plainHistoCryptoRepoFileDto);
            cryptoRepoFileId2HistoCryptoRepoFileTreeItem.put(item.getCryptoRepoFileId(), item);
            item.setExpanded(true);
        }
        for (HistoCryptoRepoFileTreeItem item : cryptoRepoFileId2HistoCryptoRepoFileTreeItem.values()) {
            Uid parentCryptoRepoFileId = item.getPlainHistoCryptoRepoFileDto().getParentCryptoRepoFileId();
            if (parentCryptoRepoFileId == null) {
                root.getChildren().add((Object)item);
                continue;
            }
            HistoCryptoRepoFileTreeItem parentItem = (HistoCryptoRepoFileTreeItem)((Object)cryptoRepoFileId2HistoCryptoRepoFileTreeItem.get(parentCryptoRepoFileId));
            if (parentItem == null) {
                throw new IllegalStateException("No parent with cryptoRepoFileId=" + parentCryptoRepoFileId);
            }
            parentItem.getChildren().add((Object)item);
        }
        if (!StringUtil.isEmpty((String)this.localPath) && !root.getChildren().isEmpty()) {
            HistoCryptoRepoFileTreeItem newRoot = root;
            for (String pathSegment : this.localPath.split("/")) {
                newRoot = newRoot.getChildOrFail(pathSegment);
            }
            root.getChildren().clear();
            root.getChildren().add((Object)newRoot);
        }
        return root;
    }

    private LocalRepoManager createLocalRepoManager() {
        LocalRepo localRepo = Objects.requireNonNull(this.getLocalRepo(), "localRepo");
        return LocalRepoManagerFactoryLs.getLocalRepoManagerFactory().createLocalRepoManagerForExistingRepository(localRepo.getLocalRoot());
    }

    private Image getCollisionIcon(HistoCryptoRepoFileTreeItem treeItem) {
        Objects.requireNonNull(treeItem, "treeItem");
        if (!treeItem.hasCollision()) {
            return null;
        }
        if (treeItem.hasUnresolvedCollision()) {
            return this.getCollisionUnresolvedIcon();
        }
        return this.getCollisionResolvedIcon();
    }

    private Image getFileIcon(HistoCryptoRepoFileTreeItem treeItem) {
        Objects.requireNonNull(treeItem, "treeItem");
        String iconId = treeItem.getRepoFileDto() instanceof DirectoryDto ? "directory" : (treeItem.getRepoFileDto() instanceof NormalFileDto ? "file-empty" : (treeItem.getRepoFileDto() instanceof SymlinkDto ? "symlink" : null));
        Image fileIcon = iconId == null ? null : FileIconRegistry.getInstance().getIcon(iconId, IconSize._16x16);
        return fileIcon;
    }

    private Image getCollisionUnresolvedIcon() {
        if (this.collisionUnresolvedIcon == null) {
            String fileName = "collision-unresolved_16x16.png";
            URL url = HistoFramePane.class.getResource("collision-unresolved_16x16.png");
            if (url == null) {
                throw new IllegalArgumentException(String.format("Resource '%s' not found!", "collision-unresolved_16x16.png"));
            }
            this.collisionUnresolvedIcon = new Image(url.toExternalForm());
        }
        return this.collisionUnresolvedIcon;
    }

    private Image getCollisionResolvedIcon() {
        if (this.collisionResolvedIcon == null) {
            String fileName = "collision-resolved_16x16.png";
            URL url = HistoFramePane.class.getResource("collision-resolved_16x16.png");
            if (url == null) {
                throw new IllegalArgumentException(String.format("Resource '%s' not found!", "collision-resolved_16x16.png"));
            }
            this.collisionResolvedIcon = new Image(url.toExternalForm());
        }
        return this.collisionResolvedIcon;
    }
}

