/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.assignownertrust;

import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpOwnerTrust;
import org.subshare.core.user.User;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.pgp.assignownertrust.AssignOwnerTrustData;
import org.subshare.gui.pgp.assignownertrust.Messages;
import org.subshare.gui.pgp.assignownertrust.selectownertrust.SelectOwnerTrustWizardPage;
import org.subshare.gui.wizard.Wizard;

public class AssignOwnerTrustWizard
extends Wizard {
    private final AssignOwnerTrustData assignOwnerTrustData;
    private final Pgp pgp;

    public AssignOwnerTrustWizard(AssignOwnerTrustData assignOwnerTrustData) {
        super(new SelectOwnerTrustWizardPage(assignOwnerTrustData));
        this.assignOwnerTrustData = Objects.requireNonNull(assignOwnerTrustData, "assignOwnerTrustData");
        User user = assignOwnerTrustData.getUser();
        Objects.requireNonNull(user, "assignOwnerTrustData.user");
        this.pgp = PgpLs.getPgpOrFail();
        Set userPgpKeys = user.getPgpKeys();
        for (PgpKey pgpKey : assignOwnerTrustData.getPgpKeys()) {
            if (userPgpKeys.contains(pgpKey)) continue;
            throw new IllegalArgumentException(String.format("pgpKey in assignOwnerTrustData.pgpKeys does not belong to user! pgpKeyId='%s' userId='%s' userFirstName='%s' userLastName='%s'", pgpKey.getPgpKeyId(), user.getUserId(), user.getFirstName(), user.getLastName()));
        }
    }

    @Override
    public String getTitle() {
        return Messages.getString("AssignOwnerTrustWizard.title");
    }

    @Override
    public void init() {
        super.init();
        this.setPrefSize(600.0, 500.0);
        this.determineOwnerTrust();
        this.determineAssignToAllPgpKeys();
    }

    private void determineOwnerTrust() {
        PgpOwnerTrust ownerTrust = this.assignOwnerTrustData.getOwnerTrust();
        if (ownerTrust == null) {
            PgpOwnerTrust ot;
            for (PgpKey pgpKey : this.assignOwnerTrustData.getPgpKeys()) {
                ot = this.pgp.getOwnerTrust(pgpKey);
                if (ownerTrust != null && ownerTrust.compareTo((Enum)ot) >= 0) continue;
                ownerTrust = ot;
            }
            if (ownerTrust == null) {
                for (PgpKey pgpKey : this.assignOwnerTrustData.getUser().getPgpKeys()) {
                    ot = this.pgp.getOwnerTrust(pgpKey);
                    if (ownerTrust != null && ownerTrust.compareTo((Enum)ot) >= 0) continue;
                    ownerTrust = ot;
                }
            }
            if (ownerTrust == null) {
                ownerTrust = PgpOwnerTrust.UNKNOWN;
            }
            this.assignOwnerTrustData.setOwnerTrust(ownerTrust);
        }
    }

    private void determineAssignToAllPgpKeys() {
        if (this.assignOwnerTrustData.getAssignToAllPgpKeys() == null) {
            Set userPgpKeys = this.assignOwnerTrustData.getUser().getPgpKeys();
            Set<PgpKey> selectedPgpKeys = this.assignOwnerTrustData.getPgpKeys();
            if (selectedPgpKeys.isEmpty() || userPgpKeys.size() == 1 || userPgpKeys.equals(selectedPgpKeys)) {
                this.assignOwnerTrustData.setAssignToAllPgpKeys(true);
            } else {
                HashSet<PgpOwnerTrust> ownerTrustsOfSelectedKeys = new HashSet<PgpOwnerTrust>();
                HashSet<PgpOwnerTrust> ownerTrustsOfNonSelectedKeys = new HashSet<PgpOwnerTrust>();
                for (PgpKey pgpKey : userPgpKeys) {
                    PgpOwnerTrust ownerTrust = this.pgp.getOwnerTrust(pgpKey);
                    if (selectedPgpKeys.contains(pgpKey)) {
                        ownerTrustsOfSelectedKeys.add(ownerTrust);
                        continue;
                    }
                    ownerTrustsOfNonSelectedKeys.add(ownerTrust);
                }
                if (ownerTrustsOfNonSelectedKeys.size() == 1 && ownerTrustsOfNonSelectedKeys.iterator().next() == PgpOwnerTrust.UNKNOWN) {
                    this.assignOwnerTrustData.setAssignToAllPgpKeys(true);
                } else {
                    this.assignOwnerTrustData.setAssignToAllPgpKeys(ownerTrustsOfNonSelectedKeys.size() == 1 && ownerTrustsOfSelectedKeys.containsAll(ownerTrustsOfNonSelectedKeys));
                }
            }
        }
    }

    @Override
    protected void finish(ProgressMonitor monitor) throws Exception {
        Set pgpKeys = this.assignOwnerTrustData.getAssignToAllPgpKeys() != false ? this.assignOwnerTrustData.getUser().getPgpKeys() : this.assignOwnerTrustData.getPgpKeys();
        PgpOwnerTrust ownerTrust = this.assignOwnerTrustData.getOwnerTrust();
        for (PgpKey pgpKey : pgpKeys) {
            this.pgp.setOwnerTrust(pgpKey, ownerTrust);
        }
        this.pgp.updateTrustDb();
    }
}

