/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.selectuser;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.GridPane;
import org.subshare.core.user.User;
import org.subshare.gui.selectuser.SelectUserPane;
import org.subshare.gui.util.FxmlUtil;

public abstract class SelectUserPaneWithButtonBar
extends GridPane {
    private SelectUserPane selectUserPane;
    @FXML
    private Button okButton;
    @FXML
    private Button cancelButton;

    public SelectUserPaneWithButtonBar(List<User> users, Collection<User> selectedUsers, SelectionMode selectionMode, String headerText) {
        Objects.requireNonNull(users, "users");
        Objects.requireNonNull(selectionMode, "selectionMode");
        FxmlUtil.loadDynamicComponentFxml(SelectUserPaneWithButtonBar.class, this);
        this.selectUserPane = new SelectUserPane(users, selectedUsers, selectionMode, headerText){

            @Override
            protected void updateComplete() {
                super.updateComplete();
                SelectUserPaneWithButtonBar.this.okButton.setDisable(this.getSelectedUsers().isEmpty());
            }
        };
        this.add((Node)this.selectUserPane, 0, 0);
    }

    public void requestFocus() {
        super.requestFocus();
        this.selectUserPane.requestFocus();
    }

    @FXML
    protected abstract void okButtonClicked(ActionEvent var1);

    @FXML
    protected abstract void cancelButtonClicked(ActionEvent var1);

    public ObservableSet<User> getSelectedUsers() {
        return this.selectUserPane.getSelectedUsers();
    }
}

