/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.locker.transport;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import org.subshare.core.locker.transport.LockerTransportFactory;

public class LockerTransportFactoryRegistry {
    private List<LockerTransportFactory> lockerTransportFactories;

    public static LockerTransportFactoryRegistry getInstance() {
        return LockerTransportFactoryRegistryHolder.instance;
    }

    protected LockerTransportFactoryRegistry() {
    }

    public LockerTransportFactory getLockerTransportFactoryOrFail(URL url) {
        LockerTransportFactory lockerTransportFactory = this.getLockerTransportFactory(url);
        if (lockerTransportFactory == null) {
            throw new IllegalStateException("There is no LockerTransportFactory supporting this URL: " + url);
        }
        return lockerTransportFactory;
    }

    public LockerTransportFactory getLockerTransportFactory(URL remoteRoot) {
        for (LockerTransportFactory factory : this.getLockerTransportFactories()) {
            if (!factory.isSupported(remoteRoot)) continue;
            return factory;
        }
        return null;
    }

    public List<LockerTransportFactory> getLockerTransportFactories(URL remoteRoot) {
        ArrayList<LockerTransportFactory> result = new ArrayList<LockerTransportFactory>();
        for (LockerTransportFactory factory : this.getLockerTransportFactories()) {
            if (!factory.isSupported(remoteRoot)) continue;
            result.add(factory);
        }
        return Collections.unmodifiableList(result);
    }

    public synchronized List<LockerTransportFactory> getLockerTransportFactories() {
        List<LockerTransportFactory> lockerTransportFactories = this.lockerTransportFactories;
        if (lockerTransportFactories == null) {
            lockerTransportFactories = LockerTransportFactoryRegistry.loadLockerTransportFactoriesViaServiceLoader();
            LockerTransportFactoryRegistry.sortLockerTransportFactories(lockerTransportFactories);
            this.lockerTransportFactories = lockerTransportFactories = Collections.unmodifiableList(lockerTransportFactories);
        }
        return lockerTransportFactories;
    }

    private static List<LockerTransportFactory> loadLockerTransportFactoriesViaServiceLoader() {
        ArrayList<LockerTransportFactory> lockerTransportFactories = new ArrayList<LockerTransportFactory>();
        ServiceLoader<LockerTransportFactory> sl = ServiceLoader.load(LockerTransportFactory.class);
        Iterator<LockerTransportFactory> it = sl.iterator();
        while (it.hasNext()) {
            lockerTransportFactories.add(it.next());
        }
        lockerTransportFactories.trimToSize();
        return lockerTransportFactories;
    }

    protected static int _compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static void sortLockerTransportFactories(List<LockerTransportFactory> lockerTransportFactories) {
        Collections.sort(lockerTransportFactories, new Comparator<LockerTransportFactory>(){

            @Override
            public int compare(LockerTransportFactory o1, LockerTransportFactory o2) {
                String name2;
                int result = -1 * LockerTransportFactoryRegistry._compare(o1.getPriority(), o2.getPriority());
                if (result != 0) {
                    return result;
                }
                String name1 = o1.getName() == null ? "" : o1.getName();
                result = name1.compareTo(name2 = o2.getName() == null ? "" : o2.getName());
                if (result != 0) {
                    return result;
                }
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
        });
    }

    public <F extends LockerTransportFactory> F getLockerTransportFactoryOrFail(Class<F> factoryClass) {
        F lockerTransportFactory = this.getLockerTransportFactory(factoryClass);
        if (lockerTransportFactory == null) {
            throw new IllegalArgumentException("There is no factory registered implementing this interface or extending this class: " + factoryClass.getName());
        }
        return lockerTransportFactory;
    }

    public <F extends LockerTransportFactory> F getLockerTransportFactory(Class<F> factoryClass) {
        Objects.requireNonNull(factoryClass, "factoryClass");
        List<LockerTransportFactory> lockerTransportFactories = this.getLockerTransportFactories();
        for (LockerTransportFactory lockerTransportFactory : lockerTransportFactories) {
            if (!factoryClass.isInstance(lockerTransportFactory)) continue;
            return (F)((LockerTransportFactory)factoryClass.cast(lockerTransportFactory));
        }
        return null;
    }

    private static class LockerTransportFactoryRegistryHolder {
        public static final LockerTransportFactoryRegistry instance = new LockerTransportFactoryRegistry();

        private LockerTransportFactoryRegistryHolder() {
        }
    }
}

